/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.prefixmapper;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.google.i18n.phonenumbers.prefixmapper.PhonePrefixMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefixTimeZonesMap
implements Externalizable {
    private final PhonePrefixMap phonePrefixMap = new PhonePrefixMap();
    private static final String RAW_STRING_TIMEZONES_SEPARATOR = "&";

    public void readPrefixTimeZonesMap(SortedMap<Integer, String> sortedPrefixTimeZoneMap) {
        this.phonePrefixMap.readPhonePrefixMap(sortedPrefixTimeZoneMap);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.phonePrefixMap.writeExternal(objectOutput);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.phonePrefixMap.readExternal(objectInput);
    }

    private List<String> lookupTimeZonesForNumber(long key) {
        String timezonesString = this.phonePrefixMap.lookup(key);
        if (timezonesString == null) {
            return new LinkedList<String>();
        }
        return this.tokenizeRawOutputString(timezonesString);
    }

    public List<String> lookupTimeZonesForNumber(Phonenumber.PhoneNumber number) {
        int n = number.getCountryCode();
        String string = String.valueOf(PhoneNumberUtil.getInstance().getNationalSignificantNumber(number));
        long phonePrefix = Long.parseLong(new StringBuilder(11 + String.valueOf(string).length()).append(n).append(string).toString());
        return this.lookupTimeZonesForNumber(phonePrefix);
    }

    public List<String> lookupCountryLevelTimeZonesForNumber(Phonenumber.PhoneNumber number) {
        return this.lookupTimeZonesForNumber(number.getCountryCode());
    }

    private List<String> tokenizeRawOutputString(String timezonesString) {
        StringTokenizer tokenizer = new StringTokenizer(timezonesString, RAW_STRING_TIMEZONES_SEPARATOR);
        LinkedList<String> timezonesList = new LinkedList<String>();
        while (tokenizer.hasMoreTokens()) {
            timezonesList.add(tokenizer.nextToken());
        }
        return timezonesList;
    }

    public String toString() {
        return this.phonePrefixMap.toString();
    }
}

