/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.geocoding;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.google.i18n.phonenumbers.geocoding.AreaCodeMap;
import com.google.i18n.phonenumbers.geocoding.MappingFileProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhoneNumberOfflineGeocoder {
    private static PhoneNumberOfflineGeocoder instance = null;
    private static final String MAPPING_DATA_DIRECTORY = "/com/google/i18n/phonenumbers/geocoding/data/";
    private static final Logger LOGGER = Logger.getLogger(PhoneNumberOfflineGeocoder.class.getName());
    private final PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
    private final String phonePrefixDataDirectory;
    private MappingFileProvider mappingFileProvider = new MappingFileProvider();
    private Map<String, AreaCodeMap> availablePhonePrefixMaps = new HashMap<String, AreaCodeMap>();

    PhoneNumberOfflineGeocoder(String phonePrefixDataDirectory) {
        this.phonePrefixDataDirectory = phonePrefixDataDirectory;
        this.loadMappingFileProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMappingFileProvider() {
        InputStream source = PhoneNumberOfflineGeocoder.class.getResourceAsStream(this.phonePrefixDataDirectory + "config");
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(source);
            this.mappingFileProvider.readExternal(in);
        }
        catch (IOException e) {
            try {
                LOGGER.log(Level.WARNING, e.toString());
            }
            catch (Throwable throwable) {
                PhoneNumberOfflineGeocoder.close(in);
                throw throwable;
            }
            PhoneNumberOfflineGeocoder.close(in);
        }
        PhoneNumberOfflineGeocoder.close(in);
    }

    private AreaCodeMap getPhonePrefixDescriptions(int prefixMapKey, String language, String script, String region) {
        String fileName = this.mappingFileProvider.getFileName(prefixMapKey, language, script, region);
        if (fileName.length() == 0) {
            return null;
        }
        if (!this.availablePhonePrefixMaps.containsKey(fileName)) {
            this.loadAreaCodeMapFromFile(fileName);
        }
        return this.availablePhonePrefixMaps.get(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAreaCodeMapFromFile(String fileName) {
        InputStream source = PhoneNumberOfflineGeocoder.class.getResourceAsStream(this.phonePrefixDataDirectory + fileName);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(source);
            AreaCodeMap map = new AreaCodeMap();
            map.readExternal(in);
            this.availablePhonePrefixMaps.put(fileName, map);
        }
        catch (IOException e) {
            try {
                LOGGER.log(Level.WARNING, e.toString());
            }
            catch (Throwable throwable) {
                PhoneNumberOfflineGeocoder.close(in);
                throw throwable;
            }
            PhoneNumberOfflineGeocoder.close(in);
        }
        PhoneNumberOfflineGeocoder.close(in);
    }

    private static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.toString());
            }
        }
    }

    public static synchronized PhoneNumberOfflineGeocoder getInstance() {
        if (instance == null) {
            instance = new PhoneNumberOfflineGeocoder(MAPPING_DATA_DIRECTORY);
        }
        return instance;
    }

    private String getCountryNameForNumber(Phonenumber.PhoneNumber number, Locale language) {
        String regionCode = this.phoneUtil.getRegionCodeForNumber(number);
        return this.getRegionDisplayName(regionCode, language);
    }

    private String getRegionDisplayName(String regionCode, Locale language) {
        return regionCode == null || regionCode.equals("ZZ") || regionCode.equals("001") ? "" : new Locale("", regionCode).getDisplayCountry(language);
    }

    public String getDescriptionForValidNumber(Phonenumber.PhoneNumber number, Locale languageCode) {
        String regionStr;
        String scriptStr;
        String langStr = languageCode.getLanguage();
        String areaDescription = this.getAreaDescriptionForNumber(number, langStr, scriptStr = "", regionStr = languageCode.getCountry());
        return areaDescription.length() > 0 ? areaDescription : this.getCountryNameForNumber(number, languageCode);
    }

    public String getDescriptionForValidNumber(Phonenumber.PhoneNumber number, Locale languageCode, String userRegion) {
        String regionCode = this.phoneUtil.getRegionCodeForNumber(number);
        if (userRegion.equals(regionCode)) {
            return this.getDescriptionForValidNumber(number, languageCode);
        }
        return this.getRegionDisplayName(regionCode, languageCode);
    }

    public String getDescriptionForNumber(Phonenumber.PhoneNumber number, Locale languageCode) {
        PhoneNumberUtil.PhoneNumberType numberType = this.phoneUtil.getNumberType(number);
        if (numberType == PhoneNumberUtil.PhoneNumberType.UNKNOWN) {
            return "";
        }
        if (!this.canBeGeocoded(numberType)) {
            return this.getCountryNameForNumber(number, languageCode);
        }
        return this.getDescriptionForValidNumber(number, languageCode);
    }

    public String getDescriptionForNumber(Phonenumber.PhoneNumber number, Locale languageCode, String userRegion) {
        PhoneNumberUtil.PhoneNumberType numberType = this.phoneUtil.getNumberType(number);
        if (numberType == PhoneNumberUtil.PhoneNumberType.UNKNOWN) {
            return "";
        }
        if (!this.canBeGeocoded(numberType)) {
            return this.getCountryNameForNumber(number, languageCode);
        }
        return this.getDescriptionForValidNumber(number, languageCode, userRegion);
    }

    private boolean canBeGeocoded(PhoneNumberUtil.PhoneNumberType numberType) {
        return numberType == PhoneNumberUtil.PhoneNumberType.FIXED_LINE || numberType == PhoneNumberUtil.PhoneNumberType.MOBILE || numberType == PhoneNumberUtil.PhoneNumberType.FIXED_LINE_OR_MOBILE;
    }

    private String getAreaDescriptionForNumber(Phonenumber.PhoneNumber number, String lang, String script, String region) {
        String description;
        int countryCallingCode = number.getCountryCode();
        int phonePrefix = countryCallingCode != 1 ? countryCallingCode : 1000 + (int)(number.getNationalNumber() / 10000000L);
        AreaCodeMap phonePrefixDescriptions = this.getPhonePrefixDescriptions(phonePrefix, lang, script, region);
        String string = description = phonePrefixDescriptions != null ? phonePrefixDescriptions.lookup(number) : null;
        if ((description == null || description.length() == 0) && this.mayFallBackToEnglish(lang)) {
            AreaCodeMap defaultMap = this.getPhonePrefixDescriptions(phonePrefix, "en", "", "");
            if (defaultMap == null) {
                return "";
            }
            description = defaultMap.lookup(number);
        }
        return description != null ? description : "";
    }

    private boolean mayFallBackToEnglish(String lang) {
        return !lang.equals("zh") && !lang.equals("ja") && !lang.equals("ko");
    }
}

