/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;

public class ShortSerializer
extends Serializer {
    private boolean optimizePositive = true;
    private static final byte SHORT = -128;
    private static final byte SHORT_POSITIVE = -1;

    public ShortSerializer() {
    }

    public ShortSerializer(Boolean optimizePositive) {
        this.optimizePositive = optimizePositive;
    }

    public Short readObjectData(ByteBuffer buffer, Class type) {
        short s = ShortSerializer.get(buffer, this.optimizePositive);
        if (Log.TRACE) {
            Log.trace((String)"kryo", (String)("Read short: " + s));
        }
        return s;
    }

    public void writeObjectData(ByteBuffer buffer, Object object) {
        ShortSerializer.put(buffer, (Short)object, this.optimizePositive);
        if (Log.TRACE) {
            Log.trace((String)"kryo", (String)("Wrote short: " + object));
        }
    }

    public static short put(ByteBuffer buffer, short value, boolean optimizePositive) {
        if (optimizePositive) {
            if (value >= 0 && value <= 254) {
                buffer.put((byte)value);
                return 1;
            }
            buffer.put((byte)-1);
            buffer.putShort(value);
        } else {
            if (value >= -127 && value <= 127) {
                buffer.put((byte)value);
                return 1;
            }
            buffer.put((byte)-128);
            buffer.putShort(value);
        }
        return 3;
    }

    public static short get(ByteBuffer buffer, boolean optimizePositive) {
        byte value = buffer.get();
        if (optimizePositive) {
            if (value == -1) {
                return buffer.getShort();
            }
            if (value < 0) {
                return (short)(value + 256);
            }
        } else if (value == -128) {
            return buffer.getShort();
        }
        return value;
    }
}

