/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java.maven;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.googlecode.jslint4java.JSLint;
import com.googlecode.jslint4java.JSLintBuilder;
import com.googlecode.jslint4java.JSLintResult;
import com.googlecode.jslint4java.Option;
import com.googlecode.jslint4java.UnicodeBomInputStream;
import com.googlecode.jslint4java.formatter.CheckstyleXmlFormatter;
import com.googlecode.jslint4java.formatter.JSLintResultFormatter;
import com.googlecode.jslint4java.formatter.JSLintXmlFormatter;
import com.googlecode.jslint4java.formatter.JUnitXmlFormatter;
import com.googlecode.jslint4java.formatter.PlainFormatter;
import com.googlecode.jslint4java.formatter.ReportFormatter;
import com.googlecode.jslint4java.maven.FileLister;
import com.googlecode.jslint4java.maven.MultiReportWriter;
import com.googlecode.jslint4java.maven.ReportWriter;
import com.googlecode.jslint4java.maven.ReportWriterImpl;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="lint", defaultPhase=LifecyclePhase.VERIFY)
public class JSLintMojo
extends AbstractMojo {
    private static final String REPORT_HTML = "report.html";
    private static final String REPORT_TXT = "report.txt";
    private static final String CHECKSTYLE_XML = "checkstyle.xml";
    private static final String DEFAULT_INCLUDES = "**/*.js";
    private static final String JSLINT_XML = "jslint.xml";
    private static final String JUNIT_XML = "junit.xml";
    @Parameter(property="excludes")
    private final List<String> excludes = Lists.newArrayList();
    @Parameter(property="includes")
    private final List<String> includes = Lists.newArrayList();
    @Parameter(readonly=true, required=true, defaultValue="${basedir}/src/main/webapp")
    private File defaultSourceFolder;
    @Parameter
    private File[] sourceFolders = new File[0];
    @Parameter
    private final Map<String, String> options = Maps.newHashMap();
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding = "UTF-8";
    @Parameter(property="jslint.outputFolder", defaultValue="${project.build.directory}/jslint4java")
    private File outputFolder = new File("target");
    @Parameter(property="jslint.failOnError", defaultValue="true")
    private boolean failOnError = true;
    @Parameter(property="jslint.source")
    private File jslintSource;
    @Parameter(property="jslint.timeout")
    private long timeout;
    @Parameter(property="jslint.skip", defaultValue="false")
    private boolean skip = false;

    void addOption(Option sloppy, String value) {
        this.options.put(sloppy.name().toLowerCase(Locale.ENGLISH), value);
    }

    private void applyDefaults() {
        if (this.includes.isEmpty()) {
            this.includes.add(DEFAULT_INCLUDES);
        }
        if (this.sourceFolders.length == 0) {
            this.sourceFolders = new File[]{this.defaultSourceFolder};
        }
    }

    private void applyOptions(JSLint jsLint) throws MojoExecutionException {
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            Option option;
            if (entry.getValue() == null || entry.getValue().equals("")) continue;
            try {
                option = Option.valueOf((String)entry.getKey().toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new MojoExecutionException("unknown option: " + entry.getKey());
            }
            jsLint.addOption(option, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping JSLint");
            return;
        }
        JSLint jsLint = this.applyJSlintSource();
        this.applyDefaults();
        this.applyOptions(jsLint);
        List<File> files = this.getFilesToProcess();
        int failures = 0;
        ReportWriter reporter = this.makeReportWriter();
        try {
            reporter.open();
            for (File file : files) {
                JSLintResult result = this.lintFile(jsLint, file);
                failures += result.getIssues().size();
                this.logIssues(result, reporter);
            }
        }
        finally {
            reporter.close();
        }
        if (failures > 0) {
            String message = "JSLint found " + failures + " problems in " + files.size() + " files";
            if (this.failOnError) {
                throw new MojoFailureException(message);
            }
            this.getLog().info((CharSequence)message);
        }
    }

    private JSLint applyJSlintSource() throws MojoExecutionException {
        JSLintBuilder builder = new JSLintBuilder();
        if (this.timeout > 0L) {
            builder.timeout(this.timeout);
        }
        if (this.jslintSource != null) {
            try {
                return builder.fromFile(this.jslintSource, Charset.forName(this.encoding));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cant' load jslint.js", (Exception)e);
            }
        }
        return builder.fromDefault();
    }

    @VisibleForTesting
    String getEncoding() {
        return this.encoding;
    }

    private List<File> getFilesToProcess() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("includes=" + this.includes));
        this.getLog().debug((CharSequence)("excludes=" + this.excludes));
        ArrayList files = Lists.newArrayList();
        for (File folder : this.sourceFolders) {
            this.getLog().debug((CharSequence)("searching " + folder));
            try {
                files.addAll(new FileLister(folder, this.includes, this.excludes).files());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error listing files", (Exception)e);
            }
        }
        return files;
    }

    @VisibleForTesting
    Map<String, String> getOptions() {
        return this.options;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSLintResult lintFile(JSLint jsLint, File file) throws MojoExecutionException {
        JSLintResult jSLintResult;
        this.getLog().debug((CharSequence)("lint " + file));
        BufferedReader reader = null;
        try {
            UnicodeBomInputStream stream = new UnicodeBomInputStream((InputStream)new FileInputStream(file));
            stream.skipBOM();
            reader = new BufferedReader(new InputStreamReader((InputStream)stream, this.getEncoding()));
            jSLintResult = jsLint.lint(file.toString(), (Reader)reader);
        }
        catch (FileNotFoundException e) {
            try {
                throw new MojoExecutionException("file not found: " + file, (Exception)e);
                catch (UnsupportedEncodingException e2) {
                    throw new MojoExecutionException("unsupported character encoding UTF-8", (Exception)e2);
                }
                catch (IOException e3) {
                    throw new MojoExecutionException("problem whilst linting " + file, (Exception)e3);
                }
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(reader);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)reader);
        return jSLintResult;
    }

    private void logIssues(JSLintResult result, ReportWriter reporter) {
        reporter.report(result);
        if (result.getIssues().isEmpty()) {
            return;
        }
        this.logIssuesToConsole(result);
    }

    private void logIssuesToConsole(JSLintResult result) {
        PlainFormatter formatter = new PlainFormatter();
        String report = formatter.format(result);
        for (String line : report.split("\n")) {
            this.getLog().info((CharSequence)line);
        }
    }

    private ReportWriter makeReportWriter() {
        ReportWriterImpl f1 = new ReportWriterImpl(new File(this.outputFolder, JSLINT_XML), (JSLintResultFormatter)new JSLintXmlFormatter());
        ReportWriterImpl f2 = new ReportWriterImpl(new File(this.outputFolder, JUNIT_XML), (JSLintResultFormatter)new JUnitXmlFormatter());
        ReportWriterImpl f3 = new ReportWriterImpl(new File(this.outputFolder, CHECKSTYLE_XML), (JSLintResultFormatter)new CheckstyleXmlFormatter());
        ReportWriterImpl f4 = new ReportWriterImpl(new File(this.outputFolder, REPORT_TXT), (JSLintResultFormatter)new PlainFormatter());
        ReportWriterImpl f5 = new ReportWriterImpl(new File(this.outputFolder, REPORT_HTML), (JSLintResultFormatter)new ReportFormatter());
        return new MultiReportWriter(f1, f2, f3, f4, f5);
    }

    public void setDefaultSourceFolder(File defaultSourceFolder) {
        this.defaultSourceFolder = defaultSourceFolder;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes.clear();
        this.excludes.addAll(excludes);
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public void setIncludes(List<String> includes) {
        this.includes.clear();
        this.includes.addAll(includes);
    }

    public void setJslint(File jslintSource) {
        this.jslintSource = jslintSource;
    }

    public void setOptions(Map<String, String> options) {
        this.options.clear();
        this.options.putAll(options);
    }

    public void setOutputFolder(File outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setSourceFolders(List<File> sourceFolders) {
        this.sourceFolders = sourceFolders.toArray(new File[sourceFolders.size()]);
    }
}

