/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java.maven;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class FileLister {
    private final List<String> includes = Lists.newArrayList();
    private final List<String> excludes = Lists.newArrayList();
    private final File sourceDirectory;

    public FileLister(File sourceDirectory, List<String> includes, List<String> excludes) {
        this.sourceDirectory = sourceDirectory;
        this.includes.addAll(includes);
        this.excludes.addAll(excludes);
        this.excludes.addAll(FileUtils.getDefaultExcludesAsList());
    }

    public List<File> files() throws IOException {
        if (!this.sourceDirectory.exists()) {
            return ImmutableList.of();
        }
        String includesStr = StringUtils.join(this.includes.iterator(), (String)",");
        String excludesStr = StringUtils.join(this.excludes.iterator(), (String)",");
        return FileUtils.getFiles((File)this.sourceDirectory, (String)includesStr, (String)excludesStr);
    }
}

