/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java.maven;

import com.googlecode.jslint4java.JSLintResult;
import com.googlecode.jslint4java.formatter.JSLintResultFormatter;
import com.googlecode.jslint4java.maven.ReportWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.codehaus.plexus.util.IOUtil;

public class ReportWriterImpl
implements ReportWriter {
    private final File reportFile;
    private final JSLintResultFormatter formatter;
    private BufferedWriter writer;

    public ReportWriterImpl(File reportFile, JSLintResultFormatter formatter) {
        this.reportFile = reportFile;
        this.formatter = formatter;
    }

    public void close() {
        try {
            if (this.formatter.footer() != null && this.writer != null) {
                this.writer.write(this.formatter.footer());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtil.close((Writer)this.writer);
        }
    }

    private void ensureReportDirectoryExists() {
        File parent = this.reportFile.getAbsoluteFile().getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
    }

    public File getReportFile() {
        return this.reportFile;
    }

    public void open() {
        this.ensureReportDirectoryExists();
        try {
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.reportFile), Charset.forName("UTF-8")));
            if (this.formatter.header() != null) {
                this.writer.write(this.formatter.header());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void report(JSLintResult result) {
        try {
            this.writer.write(this.formatter.format(result));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

