/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.standalone;

import java.lang.instrument.Instrumentation;
import mockit.coverage.CodeCoverage;
import mockit.coverage.standalone.CoverageControl;

public final class Startup {
    private static Instrumentation instrumentation;
    private static boolean inATestRun;
    private static boolean jmockitAvailable;

    public static void premain(String agentArgs, Instrumentation inst) {
        String startupMessage;
        instrumentation = inst;
        Startup.discoverOptionalDependenciesThatAreAvailableInClassPath();
        if (inATestRun) {
            startupMessage = "JMockit Coverage tool loaded";
        } else {
            startupMessage = "JMockit Coverage tool loaded; connect with a JMX client to control operation";
            CoverageControl.create();
        }
        inst.addTransformer(CodeCoverage.create(inATestRun));
        System.out.println();
        System.out.println(startupMessage);
        System.out.println();
    }

    private static void discoverOptionalDependenciesThatAreAvailableInClassPath() {
        inATestRun = Startup.isAvailableInClassPath("org.junit.Assert") || Startup.isAvailableInClassPath("org.testng.Assert");
        jmockitAvailable = Startup.isAvailableInClassPath("mockit.Invocations");
    }

    private static boolean isAvailableInClassPath(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Instrumentation instrumentation() {
        if (instrumentation == null) {
            instrumentation = mockit.internal.startup.Startup.instrumentation();
        }
        return instrumentation;
    }

    public static boolean isTestRun() {
        return inATestRun;
    }

    public static boolean isJMockitAvailable() {
        return jmockitAvailable;
    }

    static {
        inATestRun = true;
        jmockitAvailable = true;
    }
}

