/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.lineCoverage;

import mockit.coverage.lines.LineCoverageData;
import mockit.coverage.reporting.ListOfCallPoints;
import mockit.coverage.reporting.lineCoverage.LineSegmentsFormatter;
import mockit.coverage.reporting.parsing.LineParser;

final class LineCoverageFormatter {
    private final StringBuilder formattedLine = new StringBuilder(200);
    private final LineSegmentsFormatter segmentsFormatter;
    private final ListOfCallPoints listOfCallPoints;
    private LineCoverageData lineData;

    LineCoverageFormatter(boolean withCallPoints) {
        this.segmentsFormatter = new LineSegmentsFormatter(withCallPoints, this.formattedLine);
        this.listOfCallPoints = withCallPoints ? new ListOfCallPoints() : null;
    }

    String format(LineParser lineParser, LineCoverageData lineData) {
        this.lineData = lineData;
        this.formattedLine.setLength(0);
        this.formattedLine.append("<pre class='prettyprint");
        if (lineData.containsBranches()) {
            this.formatLineWithMultipleSegments(lineParser);
        } else {
            this.formatLineWithSingleSegment(lineParser);
        }
        return this.formattedLine.toString();
    }

    private void formatLineWithMultipleSegments(LineParser lineParser) {
        this.formattedLine.append(" jmp'>");
        this.segmentsFormatter.formatSegments(lineParser, this.lineData);
    }

    private void formatLineWithSingleSegment(LineParser lineParser) {
        boolean lineWithCallPoints;
        this.formattedLine.append(this.lineData.isCovered() ? " covered" : " uncovered");
        boolean bl = lineWithCallPoints = this.listOfCallPoints != null && this.lineData.containsCallPoints();
        if (lineWithCallPoints) {
            this.formattedLine.append(" cp' onclick='showHide(this)");
        }
        this.formattedLine.append("' id='l").append(lineParser.getNumber()).append("s0'>");
        this.formattedLine.append(lineParser.getInitialElement().toString()).append("</pre>");
        if (lineWithCallPoints) {
            this.listOfCallPoints.insertListOfCallPoints(this.lineData.getCallPoints());
            this.formattedLine.append(this.listOfCallPoints.getContents());
        }
    }
}

