/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.paths;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import mockit.coverage.paths.Path;

public class Node
implements Serializable {
    private static final long serialVersionUID = 7521062699264845946L;
    private final transient ThreadLocal<Boolean> reached = new ThreadLocal();
    public final int line;
    protected int segment;

    private Node(int line) {
        this.line = line;
    }

    void setSegmentAccordingToPrecedingNode(Node precedingNode) {
        int currentSegment = precedingNode.segment;
        this.segment = precedingNode instanceof Fork ? currentSegment + 1 : currentSegment;
    }

    public final int getSegment() {
        return this.segment;
    }

    final void setReached(Boolean reached) {
        this.reached.set(reached);
    }

    final boolean wasReached() {
        return this.reached.get() != null;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + ':' + this.line + '-' + this.segment;
    }

    static final class Goto
    extends Node
    implements ConditionalSuccessor,
    GotoSuccessor {
        private static final long serialVersionUID = -4715451134432419220L;
        Join nextNodeAfterGoto;

        Goto(int line) {
            super(line);
        }

        public void setNextNodeAfterGoto(Join join) {
            this.nextNodeAfterGoto = join;
        }

        public void addToPath(Path path) {
            path.addNode(this);
            this.nextNodeAfterGoto.addToPath(path);
        }
    }

    static final class Join
    extends Node
    implements ConditionalSuccessor,
    GotoSuccessor {
        private static final long serialVersionUID = -1983522899831071765L;
        ConditionalSuccessor nextNode;
        transient boolean fromTrivialFork;

        Join(int joiningLine) {
            super(joiningLine);
        }

        public void setNextNodeAfterGoto(Join newJoin) {
            this.nextNode = newJoin;
        }

        public void addToPath(Path path) {
            path.addNode(this);
            if (this.nextNode != null) {
                this.nextNode.addToPath(path);
            }
        }

        void setSegmentAccordingToPrecedingNode(Node precedingNode) {
            this.segment = precedingNode.segment + 1;
        }
    }

    static final class MultiFork
    extends Fork {
        private static final long serialVersionUID = 1220318686622690670L;
        final List<Join> caseNodes = new ArrayList<Join>();

        MultiFork(int line) {
            super(line);
        }

        void addNextNode(Join nextNode) {
            this.caseNodes.add(nextNode);
        }

        public void addToPath(Path path) {
            path.addNode(this);
            for (Join caseJoin : this.caseNodes) {
                this.createAlternatePath(path, caseJoin);
            }
        }
    }

    static final class SimpleFork
    extends Fork {
        private static final long serialVersionUID = -521666665272332763L;
        ConditionalSuccessor nextConsecutiveNode;
        Join nextNodeAfterJump;

        SimpleFork(int line) {
            super(line);
        }

        void addNextNode(Join nextNode) {
            this.nextNodeAfterJump = nextNode;
        }

        public void addToPath(Path path) {
            path.addNode(this);
            this.createAlternatePath(path, this.nextNodeAfterJump);
            this.nextConsecutiveNode.addToPath(path);
        }
    }

    public static abstract class Fork
    extends Node
    implements ConditionalSuccessor {
        private static final long serialVersionUID = -4995089238476806249L;

        Fork(int line) {
            super(line);
        }

        abstract void addNextNode(Join var1);

        final void createAlternatePath(Path parentPath, Join targetJoin) {
            Path alternatePath = new Path(parentPath, targetJoin.fromTrivialFork);
            targetJoin.addToPath(alternatePath);
        }
    }

    static final class BasicBlock
    extends Node
    implements ConditionalSuccessor,
    GotoSuccessor {
        private static final long serialVersionUID = 2637678937923952603L;
        ConditionalSuccessor nextConsecutiveNode;
        Join nextNodeAfterGoto;

        BasicBlock(int startingLine) {
            super(startingLine);
        }

        public void setNextNodeAfterGoto(Join newJoin) {
            this.nextNodeAfterGoto = newJoin;
        }

        public void addToPath(Path path) {
            path.addNode(this);
            if (this.nextNodeAfterGoto != null) {
                assert (this.nextConsecutiveNode == null);
                this.nextNodeAfterGoto.addToPath(path);
            } else if (this.nextConsecutiveNode != null) {
                this.nextConsecutiveNode.addToPath(path);
            }
        }
    }

    static final class Exit
    extends Node
    implements ConditionalSuccessor {
        private static final long serialVersionUID = -4801498566218642509L;
        final List<Path> paths = new ArrayList<Path>(4);

        Exit(int exitLine) {
            super(exitLine);
        }

        public void addToPath(Path path) {
            path.addNode(this);
            this.paths.add(path);
        }
    }

    static interface GotoSuccessor
    extends Serializable {
        public void setNextNodeAfterGoto(Join var1);
    }

    static interface ConditionalSuccessor
    extends Serializable {
        public void addToPath(Path var1);
    }

    static final class Entry
    extends Node {
        private static final long serialVersionUID = -3065417917872259568L;
        Fork nextNode;

        Entry(int entryLine) {
            super(entryLine);
        }
    }
}

