/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.lines;

import mockit.coverage.CallPoint;
import mockit.coverage.lines.LineSegmentData;
import mockit.external.asm4.Label;

public final class BranchCoverageData
extends LineSegmentData {
    private static final long serialVersionUID = 1003335601845442606L;
    public final transient Label jumpSource;
    public final transient Label jumpTarget;
    private int jumpExecutionCount;

    BranchCoverageData(Label jumpSource, Label jumpTarget) {
        this.jumpSource = jumpSource;
        this.jumpTarget = jumpTarget;
        this.jumpExecutionCount = -1;
        this.executionCount = -1;
    }

    public void setHasJumpTarget() {
        this.jumpExecutionCount = 0;
    }

    public void setHasNoJumpTarget() {
        this.executionCount = 0;
    }

    void registerJumpExecution(CallPoint callPoint) {
        assert (this.jumpExecutionCount >= 0) : "Illegal registerJumpExecution";
        ++this.jumpExecutionCount;
        this.addCallPointIfAny(callPoint);
    }

    void registerNoJumpExecution(CallPoint callPoint) {
        assert (this.executionCount >= 0) : "Illegal registerNoJumpExecution";
        ++this.executionCount;
        this.addCallPointIfAny(callPoint);
    }

    public boolean isCovered() {
        return super.isCovered() || this.jumpExecutionCount > 0;
    }

    public int getExecutionCount() {
        return this.executionCount > 0 ? this.executionCount : (this.jumpExecutionCount > 0 ? this.jumpExecutionCount : 0);
    }

    void addCountsFromPreviousTestRun(BranchCoverageData previousData) {
        this.addExecutionCountAndCallPointsFromPreviousTestRun(previousData);
        this.jumpExecutionCount += previousData.jumpExecutionCount;
    }

    void reset() {
        super.reset();
        this.jumpExecutionCount = 0;
    }
}

