/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32.symmetric;

import com.googlecode.javaewah32.BitmapStorage32;
import com.googlecode.javaewah32.symmetric.EWAHPointer32;
import com.googlecode.javaewah32.symmetric.UpdateableBitmapFunction32;
import java.util.Arrays;

public final class ThresholdFuncBitmap32
extends UpdateableBitmapFunction32 {
    private int min;
    private int[] buffers;
    private int bufferUsed;
    private int[] bufcounters = new int[64];
    private static final int[] zeroes64 = new int[64];

    public ThresholdFuncBitmap32(int min) {
        this.min = min;
        this.buffers = new int[16];
        this.bufferUsed = 0;
    }

    @Override
    public void dispatch(BitmapStorage32 out, int runbegin, int runend) {
        int runlength = runend - runbegin;
        if (this.hammingWeight >= this.min) {
            out.addStreamOfEmptyWords(true, runlength);
            return;
        }
        if (this.litWeight + this.hammingWeight < this.min) {
            out.addStreamOfEmptyWords(false, runlength);
        } else {
            int deficit = this.min - this.hammingWeight;
            if (deficit == 1) {
                this.orLiterals(out, runbegin, runlength);
                return;
            }
            this.bufferUsed = this.getNumberOfLiterals();
            if (this.bufferUsed == deficit) {
                this.andLiterals(out, runbegin, runlength);
            } else {
                this.generalLiterals(deficit, out, runbegin, runlength);
            }
        }
    }

    private int threshold2buf(int T, int[] buf, int bufUsed) {
        int result = 0;
        int[] counters = this.bufcounters;
        System.arraycopy(zeroes64, 0, counters, 0, 64);
        for (int k = 0; k < bufUsed; ++k) {
            int t;
            for (int bitset = buf[k]; bitset != 0; bitset ^= t) {
                t = bitset & -bitset;
                int n = Integer.bitCount(t - 1);
                counters[n] = counters[n] + 1;
            }
        }
        for (int pos = 0; pos < 64; ++pos) {
            if (counters[pos] < T) continue;
            result = (int)((long)result | 1L << pos);
        }
        return result;
    }

    private static int threshold3(int T, int[] buffers, int bufUsed) {
        if (buffers.length == 0) {
            return 0;
        }
        int[] v = new int[T];
        v[0] = buffers[0];
        for (int k = 1; k < bufUsed; ++k) {
            int m;
            int c = buffers[k];
            for (int j = m = Math.min(T - 1, k); j >= 1; --j) {
                int n = j;
                v[n] = v[n] | c & v[j - 1];
            }
            v[0] = v[0] | c;
        }
        return v[T - 1];
    }

    private int threshold4(int T, int[] buf, int bufUsed) {
        if (T >= 128) {
            return this.threshold2buf(T, buf, bufUsed);
        }
        int B = 0;
        for (int k = 0; k < bufUsed; ++k) {
            B += Integer.bitCount(buf[k]);
        }
        if (2 * B >= bufUsed * T) {
            return ThresholdFuncBitmap32.threshold3(T, buf, bufUsed);
        }
        return this.threshold2buf(T, buf, bufUsed);
    }

    private final void orLiterals(BitmapStorage32 out, int runbegin, int runlength) {
        for (int i = 0; i < runlength; ++i) {
            int w = 0;
            for (EWAHPointer32 R : this.getLiterals()) {
                w |= R.iterator.getLiteralWordAt(i + runbegin - R.beginOfRun());
            }
            out.add(w);
        }
    }

    private final void andLiterals(BitmapStorage32 out, int runbegin, int runlength) {
        for (int i = 0; i < runlength; ++i) {
            int w = -1;
            for (EWAHPointer32 R : this.getLiterals()) {
                w &= R.iterator.getLiteralWordAt(i + runbegin - R.beginOfRun());
            }
            out.add(w);
        }
    }

    private final void generalLiterals(int deficit, BitmapStorage32 out, int runbegin, int runlength) {
        if (this.bufferUsed > this.buffers.length) {
            this.buffers = Arrays.copyOf(this.buffers, 2 * this.bufferUsed);
        }
        for (int i = 0; i < runlength; ++i) {
            int p = 0;
            for (EWAHPointer32 R : this.getLiterals()) {
                this.buffers[p++] = R.iterator.getLiteralWordAt(i + runbegin - R.beginOfRun());
            }
            out.add(this.threshold4(deficit, this.buffers, this.bufferUsed));
        }
    }
}

