/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.EWAHCompressedBitmap;

public final class RunningLengthWord
implements Cloneable {
    public EWAHCompressedBitmap parent;
    public int position;
    public static final int RUNNING_LENGTH_BITS = 32;
    private static final int LITERAL_BITS = 31;
    public static final int LARGEST_LITERAL_COUNT = Integer.MAX_VALUE;
    public static final long LARGEST_RUNNING_LENGTH_COUNT = 0xFFFFFFFFL;
    private static final long RUNNING_LENGTH_PLUS_RUNNING_BIT = 0x1FFFFFFFFL;
    private static final long SHIFTED_LARGEST_RUNNING_LENGTH_COUNT = 0x1FFFFFFFEL;
    private static final long NOT_RUNNING_LENGTH_PLUS_RUNNING_BIT = -8589934592L;
    private static final long NOT_SHIFTED_LARGEST_RUNNING_LENGTH_COUNT = -8589934591L;

    RunningLengthWord(EWAHCompressedBitmap a, int p) {
        this.parent = a;
        this.position = p;
    }

    public int getNumberOfLiteralWords() {
        return (int)(this.parent.buffer[this.position] >>> 33);
    }

    public boolean getRunningBit() {
        return (this.parent.buffer[this.position] & 1L) != 0L;
    }

    public long getRunningLength() {
        return this.parent.buffer[this.position] >>> 1 & 0xFFFFFFFFL;
    }

    public void setNumberOfLiteralWords(long number) {
        int n = this.position;
        this.parent.buffer[n] = this.parent.buffer[n] | 0xFFFFFFFE00000000L;
        int n2 = this.position;
        this.parent.buffer[n2] = this.parent.buffer[n2] & (number << 33 | 0x1FFFFFFFFL);
    }

    public void setRunningBit(boolean b) {
        if (b) {
            int n = this.position;
            this.parent.buffer[n] = this.parent.buffer[n] | 1L;
        } else {
            int n = this.position;
            this.parent.buffer[n] = this.parent.buffer[n] & 0xFFFFFFFFFFFFFFFEL;
        }
    }

    public void setRunningLength(long number) {
        int n = this.position;
        this.parent.buffer[n] = this.parent.buffer[n] | 0x1FFFFFFFEL;
        int n2 = this.position;
        this.parent.buffer[n2] = this.parent.buffer[n2] & (number << 1 | 0xFFFFFFFE00000001L);
    }

    public long size() {
        return this.getRunningLength() + (long)this.getNumberOfLiteralWords();
    }

    public String toString() {
        return "running bit = " + this.getRunningBit() + " running length = " + this.getRunningLength() + " number of lit. words " + this.getNumberOfLiteralWords();
    }

    public RunningLengthWord clone() throws CloneNotSupportedException {
        RunningLengthWord answer = (RunningLengthWord)super.clone();
        answer.parent = this.parent;
        answer.position = this.position;
        return answer;
    }
}

