/*
 * Decompiled with CFR 0.152.
 */
package javaewah;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javaewah.BitCounter;
import javaewah.BitmapStorage;
import javaewah.BufferedRunningLengthWord;
import javaewah.EWAHIterator;
import javaewah.IntIterator;
import javaewah.IteratingBufferedRunningLengthWord;
import javaewah.NonEmptyVirtualStorage;
import javaewah.RunningLengthWord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EWAHCompressedBitmap
implements Cloneable,
Externalizable,
Iterable<Integer>,
BitmapStorage {
    static final int defaultbuffersize = 4;
    long[] buffer = null;
    int actualsizeinwords = 1;
    int sizeinbits = 0;
    RunningLengthWord rlw = null;
    public static final int wordinbits = 64;
    public static final boolean usetrailingzeros = true;

    public EWAHCompressedBitmap() {
        this.buffer = new long[4];
        this.rlw = new RunningLengthWord(this.buffer, 0);
    }

    public EWAHCompressedBitmap(int buffersize) {
        this.buffer = new long[buffersize];
        this.rlw = new RunningLengthWord(this.buffer, 0);
    }

    private EWAHIterator getEWAHIterator() {
        return new EWAHIterator(this.buffer, this.actualsizeinwords);
    }

    public EWAHCompressedBitmap xor(EWAHCompressedBitmap a) {
        EWAHCompressedBitmap container = new EWAHCompressedBitmap();
        container.reserve(this.actualsizeinwords + a.actualsizeinwords);
        this.xor(a, container);
        return container;
    }

    private void xor(EWAHCompressedBitmap a, BitmapStorage container) {
        EWAHIterator i = a.getEWAHIterator();
        EWAHIterator j = this.getEWAHIterator();
        if (!i.hasNext() || !j.hasNext()) {
            container.setSizeInBits(this.sizeInBits());
        }
        BufferedRunningLengthWord rlwi = new BufferedRunningLengthWord(i.next());
        BufferedRunningLengthWord rlwj = new BufferedRunningLengthWord(j.next());
        while (true) {
            long nbre_dirty_prey;
            int dw_predator;
            long tobediscarded;
            long preyrl;
            long predatorrl;
            BufferedRunningLengthWord predator;
            boolean i_is_prey = rlwi.size() < rlwj.size();
            BufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
            BufferedRunningLengthWord bufferedRunningLengthWord = predator = i_is_prey ? rlwj : rlwi;
            if (!prey.getRunningBit()) {
                predatorrl = predator.getRunningLength();
                tobediscarded = predatorrl >= (preyrl = prey.getRunningLength()) ? preyrl : predatorrl;
                container.addStreamOfEmptyWords(predator.getRunningBit(), tobediscarded);
                dw_predator = predator.dirtywordoffset + (i_is_prey ? j.dirtyWords() : i.dirtyWords());
                container.addStreamOfDirtyWords(i_is_prey ? j.buffer() : i.buffer(), dw_predator, (int)(preyrl - tobediscarded));
                predator.discardFirstWords(preyrl);
                prey.discardFirstWords(preyrl);
            } else {
                predatorrl = predator.getRunningLength();
                tobediscarded = predatorrl >= (preyrl = prey.getRunningLength()) ? preyrl : predatorrl;
                container.addStreamOfEmptyWords(!predator.getRunningBit(), tobediscarded);
                dw_predator = predator.dirtywordoffset + (i_is_prey ? j.dirtyWords() : i.dirtyWords());
                long[] buf = i_is_prey ? j.buffer() : i.buffer();
                int k = 0;
                while ((long)k < preyrl - tobediscarded) {
                    container.add(buf[k + dw_predator] ^ 0xFFFFFFFFFFFFFFFFL);
                    ++k;
                }
                predator.discardFirstWords(preyrl);
                prey.discardFirstWords(preyrl);
            }
            predatorrl = predator.getRunningLength();
            if (predatorrl > 0L) {
                int tobediscarded2;
                if (!predator.getRunningBit()) {
                    int nbre_dirty_prey2 = prey.getNumberOfLiteralWords();
                    tobediscarded2 = predatorrl >= (long)nbre_dirty_prey2 ? nbre_dirty_prey2 : (int)predatorrl;
                    int dw_prey = prey.dirtywordoffset + (i_is_prey ? i.dirtyWords() : j.dirtyWords());
                    predator.discardFirstWords(tobediscarded2);
                    prey.discardFirstWords(tobediscarded2);
                    container.addStreamOfDirtyWords(i_is_prey ? i.buffer() : j.buffer(), dw_prey, tobediscarded2);
                } else {
                    int nbre_dirty_prey3 = prey.getNumberOfLiteralWords();
                    tobediscarded2 = predatorrl >= (long)nbre_dirty_prey3 ? nbre_dirty_prey3 : (int)predatorrl;
                    int dw_prey = prey.dirtywordoffset + (i_is_prey ? i.dirtyWords() : j.dirtyWords());
                    predator.discardFirstWords(tobediscarded2);
                    prey.discardFirstWords(tobediscarded2);
                    long[] buf = i_is_prey ? i.buffer() : j.buffer();
                    for (int k = 0; k < tobediscarded2; ++k) {
                        container.add(buf[k + dw_prey] ^ 0xFFFFFFFFFFFFFFFFL);
                    }
                }
            }
            if ((nbre_dirty_prey = (long)prey.getNumberOfLiteralWords()) > 0L) {
                int k = 0;
                while ((long)k < nbre_dirty_prey) {
                    if (i_is_prey) {
                        container.add(i.buffer()[prey.dirtywordoffset + i.dirtyWords() + k] ^ j.buffer()[predator.dirtywordoffset + j.dirtyWords() + k]);
                    } else {
                        container.add(i.buffer()[predator.dirtywordoffset + i.dirtyWords() + k] ^ j.buffer()[prey.dirtywordoffset + j.dirtyWords() + k]);
                    }
                    ++k;
                }
                predator.discardFirstWords(nbre_dirty_prey);
            }
            if (i_is_prey) {
                if (!i.hasNext()) {
                    rlwi = null;
                    break;
                }
                rlwi.reset(i.next());
                continue;
            }
            if (!j.hasNext()) {
                rlwj = null;
                break;
            }
            rlwj.reset(j.next());
        }
        if (rlwi != null) {
            EWAHCompressedBitmap.discharge(rlwi, i, container);
        }
        if (rlwj != null) {
            EWAHCompressedBitmap.discharge(rlwj, j, container);
        }
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public EWAHCompressedBitmap and(EWAHCompressedBitmap a) {
        EWAHCompressedBitmap container = new EWAHCompressedBitmap();
        container.reserve(this.actualsizeinwords > a.actualsizeinwords ? this.actualsizeinwords : a.actualsizeinwords);
        this.and(a, container);
        return container;
    }

    private void and(EWAHCompressedBitmap a, BitmapStorage container) {
        EWAHIterator i = a.getEWAHIterator();
        EWAHIterator j = this.getEWAHIterator();
        if (!i.hasNext() || !j.hasNext()) {
            container.setSizeInBits(this.sizeInBits());
        }
        BufferedRunningLengthWord rlwi = new BufferedRunningLengthWord(i.next());
        BufferedRunningLengthWord rlwj = new BufferedRunningLengthWord(j.next());
        while (true) {
            int nbre_dirty_prey;
            long predatorrl;
            BufferedRunningLengthWord predator;
            boolean i_is_prey = rlwi.size() < rlwj.size();
            BufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
            BufferedRunningLengthWord bufferedRunningLengthWord = predator = i_is_prey ? rlwj : rlwi;
            if (!prey.getRunningBit()) {
                container.addStreamOfEmptyWords(false, prey.RunningLength);
                predator.discardFirstWords(prey.RunningLength);
                prey.RunningLength = 0L;
            } else {
                long preyrl;
                predatorrl = predator.getRunningLength();
                long tobediscarded = predatorrl >= (preyrl = prey.getRunningLength()) ? preyrl : predatorrl;
                container.addStreamOfEmptyWords(predator.getRunningBit(), tobediscarded);
                int dw_predator = predator.dirtywordoffset + (i_is_prey ? j.dirtyWords() : i.dirtyWords());
                container.addStreamOfDirtyWords(i_is_prey ? j.buffer() : i.buffer(), dw_predator, (int)(preyrl - tobediscarded));
                predator.discardFirstWords(preyrl);
                prey.RunningLength = 0L;
            }
            predatorrl = predator.getRunningLength();
            if (predatorrl > 0L) {
                if (!predator.getRunningBit()) {
                    int nbre_dirty_prey2 = prey.getNumberOfLiteralWords();
                    int tobediscarded = predatorrl >= (long)nbre_dirty_prey2 ? nbre_dirty_prey2 : (int)predatorrl;
                    predator.discardFirstWords(tobediscarded);
                    prey.discardFirstWords(tobediscarded);
                    container.addStreamOfEmptyWords(false, tobediscarded);
                } else {
                    int nbre_dirty_prey3 = prey.getNumberOfLiteralWords();
                    int dw_prey = prey.dirtywordoffset + (i_is_prey ? i.dirtyWords() : j.dirtyWords());
                    int tobediscarded = predatorrl >= (long)nbre_dirty_prey3 ? nbre_dirty_prey3 : (int)predatorrl;
                    container.addStreamOfDirtyWords(i_is_prey ? i.buffer() : j.buffer(), dw_prey, tobediscarded);
                    predator.discardFirstWords(tobediscarded);
                    prey.discardFirstWords(tobediscarded);
                }
            }
            if ((nbre_dirty_prey = prey.getNumberOfLiteralWords()) > 0) {
                for (int k = 0; k < nbre_dirty_prey; ++k) {
                    if (i_is_prey) {
                        container.add(i.buffer()[prey.dirtywordoffset + i.dirtyWords() + k] & j.buffer()[predator.dirtywordoffset + j.dirtyWords() + k]);
                        continue;
                    }
                    container.add(i.buffer()[predator.dirtywordoffset + i.dirtyWords() + k] & j.buffer()[prey.dirtywordoffset + j.dirtyWords() + k]);
                }
                predator.discardFirstWords(nbre_dirty_prey);
            }
            if (i_is_prey) {
                if (!i.hasNext()) {
                    rlwi = null;
                    break;
                }
                rlwi.reset(i.next());
                continue;
            }
            if (!j.hasNext()) {
                rlwj = null;
                break;
            }
            rlwj.reset(j.next());
        }
        if (rlwi != null) {
            EWAHCompressedBitmap.dischargeAsEmpty(rlwi, i, container);
        }
        if (rlwj != null) {
            EWAHCompressedBitmap.dischargeAsEmpty(rlwj, j, container);
        }
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public static EWAHCompressedBitmap and(EWAHCompressedBitmap ... bitmaps) {
        EWAHCompressedBitmap container = new EWAHCompressedBitmap();
        int largestSize = 0;
        for (EWAHCompressedBitmap bitmap : bitmaps) {
            largestSize = Math.max(bitmap.actualsizeinwords, largestSize);
        }
        container.reserve((int)((double)largestSize * 1.5));
        EWAHCompressedBitmap.and((BitmapStorage)container, bitmaps);
        return container;
    }

    public static int andCardinality(EWAHCompressedBitmap ... bitmaps) {
        BitCounter counter = new BitCounter();
        EWAHCompressedBitmap.and(counter, bitmaps);
        return counter.getCount();
    }

    /*
     * Unable to fully structure code
     */
    private static void and(BitmapStorage container, EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 2) {
            bitmaps[0].and(bitmaps[1], container);
            return;
        }
        sortedBitmaps = (EWAHCompressedBitmap[])bitmaps.clone();
        Arrays.sort(sortedBitmaps, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return a.sizeinbits < b.sizeinbits ? -1 : (a.sizeinbits == b.sizeinbits ? 0 : 1);
            }
        });
        maxSize = sortedBitmaps[sortedBitmaps.length - 1].sizeinbits;
        rlws = new IteratingBufferedRunningLengthWord[bitmaps.length];
        for (i = 0; i < sortedBitmaps.length; ++i) {
            iterator = sortedBitmaps[i].getEWAHIterator();
            if (!iterator.hasNext()) {
                if (maxSize > 0) {
                    EWAHCompressedBitmap.extendEmptyBits(container, 0, maxSize);
                }
                container.setSizeInBits(maxSize);
                return;
            }
            rlws[i] = new IteratingBufferedRunningLengthWord(iterator);
        }
        block1: while (true) {
            maxZeroRl = 0L;
            minOneRl = 0x7FFFFFFFFFFFFFFFL;
            minSize = 0x7FFFFFFFFFFFFFFFL;
            numEmptyRl = 0;
            if (rlws[0].size() == 0L) break;
            for (IteratingBufferedRunningLengthWord rlw : rlws) {
                size = rlw.size();
                minSize = Math.min(minSize, size);
                if (!rlw.getRunningBit()) {
                    rl = rlw.getRunningLength();
                    maxZeroRl = Math.max(maxZeroRl, rl);
                    minOneRl = 0L;
                    if (rl != 0L || size <= 0L) continue;
                    ++numEmptyRl;
                    continue;
                }
                rl = rlw.getRunningLength();
                minOneRl = Math.min(minOneRl, rl);
                if (rl != 0L || size <= 0L) continue;
                ++numEmptyRl;
            }
            if (maxZeroRl > 0L) {
                container.addStreamOfEmptyWords(false, maxZeroRl);
                arr$ = rlws;
                len$ = arr$.length;
                i$ = 0;
                while (true) {
                    if (i$ >= len$) continue block1;
                    rlw = arr$[i$];
                    rlw.discardFirstWords(maxZeroRl);
                    ++i$;
                }
            }
            if (minOneRl > 0L) {
                container.addStreamOfEmptyWords(true, minOneRl);
                arr$ = rlws;
                len$ = arr$.length;
                i$ = 0;
                while (true) {
                    if (i$ >= len$) continue block1;
                    rlw = arr$[i$];
                    rlw.discardFirstWords(minOneRl);
                    ++i$;
                }
            }
            index = 0;
            if (numEmptyRl == 1) {
                emptyRl = null;
                minNonEmptyRl = 0x7FFFFFFFFFFFFFFFL;
                for (IteratingBufferedRunningLengthWord rlw : rlws) {
                    rl = rlw.getRunningLength();
                    if (rl == 0L) {
                        if (!EWAHCompressedBitmap.$assertionsDisabled && emptyRl != null) {
                            throw new AssertionError();
                        }
                        emptyRl = rlw;
                        continue;
                    }
                    minNonEmptyRl = Math.min(minNonEmptyRl, rl);
                }
                v0 = wordsToWrite = minNonEmptyRl > minSize ? minSize : minNonEmptyRl;
                if (emptyRl != null) {
                    emptyRl.writeDirtyWords((int)wordsToWrite, container);
                }
                index = (int)((long)index + wordsToWrite);
            }
            while ((long)index < minSize) {
                word = -1L;
                for (IteratingBufferedRunningLengthWord rlw : rlws) {
                    if (rlw.getRunningLength() > (long)index) continue;
                    word &= rlw.getDirtyWordAt(index - (int)rlw.getRunningLength());
                }
                container.add(word);
                ++index;
            }
            arr$ = rlws;
            len$ = arr$.length;
            i$ = 0;
            while (true) {
                if (i$ >= len$) ** break;
                rlw = arr$[i$];
                rlw.discardFirstWords(minSize);
                ++i$;
            }
            break;
        }
        EWAHCompressedBitmap.extendEmptyBits(container, sortedBitmaps[0].sizeinbits, maxSize);
        container.setSizeInBits(maxSize);
    }

    public boolean intersects(EWAHCompressedBitmap a) {
        NonEmptyVirtualStorage nevs = new NonEmptyVirtualStorage();
        try {
            this.and(a, nevs);
        }
        catch (NonEmptyVirtualStorage.NonEmptyException nee) {
            return true;
        }
        return false;
    }

    public EWAHCompressedBitmap andNot(EWAHCompressedBitmap a) {
        EWAHCompressedBitmap container = new EWAHCompressedBitmap();
        container.reserve(this.actualsizeinwords > a.actualsizeinwords ? this.actualsizeinwords : a.actualsizeinwords);
        this.andNot(a, container);
        return container;
    }

    private void andNot(EWAHCompressedBitmap a, BitmapStorage container) {
        BufferedRunningLengthWord rlwi;
        EWAHIterator i = a.getEWAHIterator();
        EWAHIterator j = this.getEWAHIterator();
        if (!i.hasNext() || !j.hasNext()) {
            container.setSizeInBits(this.sizeInBits());
        }
        rlwi.setRunningBit(!(rlwi = new BufferedRunningLengthWord(i.next())).getRunningBit());
        BufferedRunningLengthWord rlwj = new BufferedRunningLengthWord(j.next());
        while (true) {
            int nbre_dirty_prey;
            long predatorrl;
            BufferedRunningLengthWord predator;
            boolean i_is_prey = rlwi.size() < rlwj.size();
            BufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
            BufferedRunningLengthWord bufferedRunningLengthWord = predator = i_is_prey ? rlwj : rlwi;
            if (!prey.getRunningBit()) {
                container.addStreamOfEmptyWords(false, prey.RunningLength);
                predator.discardFirstWords(prey.RunningLength);
                prey.RunningLength = 0L;
            } else {
                long preyrl;
                predatorrl = predator.getRunningLength();
                long tobediscarded = predatorrl >= (preyrl = prey.getRunningLength()) ? preyrl : predatorrl;
                container.addStreamOfEmptyWords(predator.getRunningBit(), tobediscarded);
                int dw_predator = predator.dirtywordoffset + (i_is_prey ? j.dirtyWords() : i.dirtyWords());
                if (i_is_prey) {
                    container.addStreamOfDirtyWords(j.buffer(), dw_predator, (int)(preyrl - tobediscarded));
                } else {
                    container.addStreamOfNegatedDirtyWords(i.buffer(), dw_predator, (int)(preyrl - tobediscarded));
                }
                predator.discardFirstWords(preyrl);
                prey.RunningLength = 0L;
            }
            predatorrl = predator.getRunningLength();
            if (predatorrl > 0L) {
                if (!predator.getRunningBit()) {
                    int nbre_dirty_prey2 = prey.getNumberOfLiteralWords();
                    int tobediscarded = predatorrl >= (long)nbre_dirty_prey2 ? nbre_dirty_prey2 : (int)predatorrl;
                    predator.discardFirstWords(tobediscarded);
                    prey.discardFirstWords(tobediscarded);
                    container.addStreamOfEmptyWords(false, tobediscarded);
                } else {
                    int tobediscarded;
                    int nbre_dirty_prey3 = prey.getNumberOfLiteralWords();
                    int dw_prey = prey.dirtywordoffset + (i_is_prey ? i.dirtyWords() : j.dirtyWords());
                    int n = tobediscarded = predatorrl >= (long)nbre_dirty_prey3 ? nbre_dirty_prey3 : (int)predatorrl;
                    if (i_is_prey) {
                        container.addStreamOfNegatedDirtyWords(i.buffer(), dw_prey, tobediscarded);
                    } else {
                        container.addStreamOfDirtyWords(j.buffer(), dw_prey, tobediscarded);
                    }
                    predator.discardFirstWords(tobediscarded);
                    prey.discardFirstWords(tobediscarded);
                }
            }
            if ((nbre_dirty_prey = prey.getNumberOfLiteralWords()) > 0) {
                for (int k = 0; k < nbre_dirty_prey; ++k) {
                    if (i_is_prey) {
                        container.add((i.buffer()[prey.dirtywordoffset + i.dirtyWords() + k] ^ 0xFFFFFFFFFFFFFFFFL) & j.buffer()[predator.dirtywordoffset + j.dirtyWords() + k]);
                        continue;
                    }
                    container.add((i.buffer()[predator.dirtywordoffset + i.dirtyWords() + k] ^ 0xFFFFFFFFFFFFFFFFL) & j.buffer()[prey.dirtywordoffset + j.dirtyWords() + k]);
                }
                predator.discardFirstWords(nbre_dirty_prey);
            }
            if (i_is_prey) {
                if (!i.hasNext()) {
                    rlwi = null;
                    break;
                }
                rlwi.reset(i.next());
                rlwi.setRunningBit(!rlwi.getRunningBit());
                continue;
            }
            if (!j.hasNext()) {
                rlwj = null;
                break;
            }
            rlwj.reset(j.next());
        }
        if (rlwi != null) {
            EWAHCompressedBitmap.dischargeAsEmpty(rlwi, i, container);
        }
        if (rlwj != null) {
            EWAHCompressedBitmap.discharge(rlwj, j, container);
        }
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public void not() {
        RunningLengthWord rlw1;
        EWAHIterator i = new EWAHIterator(this.buffer, this.actualsizeinwords);
        if (!i.hasNext()) {
            return;
        }
        do {
            rlw1.setRunningBit(!(rlw1 = i.next()).getRunningBit());
            for (int j = 0; j < rlw1.getNumberOfLiteralWords(); ++j) {
                i.buffer()[i.dirtyWords() + j] = i.buffer()[i.dirtyWords() + j] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        } while (i.hasNext());
        if (rlw1.getNumberOfLiteralWords() == 0) {
            return;
        }
        int usedbitsinlast = this.sizeinbits % 64;
        if (usedbitsinlast == 0) {
            return;
        }
        long[] lArray = i.buffer();
        int n = i.dirtyWords() + rlw1.getNumberOfLiteralWords() - 1;
        lArray[n] = lArray[n] & -1L >>> 64 - usedbitsinlast;
    }

    public EWAHCompressedBitmap or(EWAHCompressedBitmap a) {
        EWAHCompressedBitmap container = new EWAHCompressedBitmap();
        container.reserve(this.actualsizeinwords + a.actualsizeinwords);
        this.or(a, container);
        return container;
    }

    public int orCardinality(EWAHCompressedBitmap a) {
        BitCounter counter = new BitCounter();
        this.or(a, counter);
        return counter.getCount();
    }

    public int andCardinality(EWAHCompressedBitmap a) {
        BitCounter counter = new BitCounter();
        this.and(a, counter);
        return counter.getCount();
    }

    public int andNotCardinality(EWAHCompressedBitmap a) {
        BitCounter counter = new BitCounter();
        this.andNot(a, counter);
        return counter.getCount();
    }

    public int xorCardinality(EWAHCompressedBitmap a) {
        BitCounter counter = new BitCounter();
        this.xor(a, counter);
        return counter.getCount();
    }

    private void or(EWAHCompressedBitmap a, BitmapStorage container) {
        EWAHIterator i = a.getEWAHIterator();
        EWAHIterator j = this.getEWAHIterator();
        if (!i.hasNext() || !j.hasNext()) {
            container.setSizeInBits(this.sizeInBits());
            return;
        }
        BufferedRunningLengthWord rlwi = new BufferedRunningLengthWord(i.next());
        BufferedRunningLengthWord rlwj = new BufferedRunningLengthWord(j.next());
        while (true) {
            int nbre_dirty_prey;
            long predatorrl;
            BufferedRunningLengthWord predator;
            boolean i_is_prey = rlwi.size() < rlwj.size();
            BufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
            BufferedRunningLengthWord bufferedRunningLengthWord = predator = i_is_prey ? rlwj : rlwi;
            if (!prey.getRunningBit()) {
                long preyrl;
                predatorrl = predator.getRunningLength();
                long tobediscarded = predatorrl >= (preyrl = prey.getRunningLength()) ? preyrl : predatorrl;
                container.addStreamOfEmptyWords(predator.getRunningBit(), tobediscarded);
                int dw_predator = predator.dirtywordoffset + (i_is_prey ? j.dirtyWords() : i.dirtyWords());
                container.addStreamOfDirtyWords(i_is_prey ? j.buffer() : i.buffer(), dw_predator, (int)(preyrl - tobediscarded));
                predator.discardFirstWords(preyrl);
                prey.discardFirstWords(preyrl);
                prey.RunningLength = 0L;
            } else {
                container.addStreamOfEmptyWords(true, prey.RunningLength);
                predator.discardFirstWords(prey.RunningLength);
                prey.RunningLength = 0L;
            }
            predatorrl = predator.getRunningLength();
            if (predatorrl > 0L) {
                int tobediscarded;
                if (!predator.getRunningBit()) {
                    int nbre_dirty_prey2 = prey.getNumberOfLiteralWords();
                    tobediscarded = predatorrl >= (long)nbre_dirty_prey2 ? nbre_dirty_prey2 : (int)predatorrl;
                    int dw_prey = prey.dirtywordoffset + (i_is_prey ? i.dirtyWords() : j.dirtyWords());
                    predator.discardFirstWords(tobediscarded);
                    prey.discardFirstWords(tobediscarded);
                    container.addStreamOfDirtyWords(i_is_prey ? i.buffer() : j.buffer(), dw_prey, tobediscarded);
                } else {
                    int nbre_dirty_prey3 = prey.getNumberOfLiteralWords();
                    tobediscarded = predatorrl >= (long)nbre_dirty_prey3 ? nbre_dirty_prey3 : (int)predatorrl;
                    container.addStreamOfEmptyWords(true, tobediscarded);
                    predator.discardFirstWords(tobediscarded);
                    prey.discardFirstWords(tobediscarded);
                }
            }
            if ((nbre_dirty_prey = prey.getNumberOfLiteralWords()) > 0) {
                for (int k = 0; k < nbre_dirty_prey; ++k) {
                    if (i_is_prey) {
                        container.add(i.buffer()[prey.dirtywordoffset + i.dirtyWords() + k] | j.buffer()[predator.dirtywordoffset + j.dirtyWords() + k]);
                        continue;
                    }
                    container.add(i.buffer()[predator.dirtywordoffset + i.dirtyWords() + k] | j.buffer()[prey.dirtywordoffset + j.dirtyWords() + k]);
                }
                predator.discardFirstWords(nbre_dirty_prey);
            }
            if (i_is_prey) {
                if (!i.hasNext()) {
                    rlwi = null;
                    break;
                }
                rlwi.reset(i.next());
                continue;
            }
            if (!j.hasNext()) {
                rlwj = null;
                break;
            }
            rlwj.reset(j.next());
        }
        if (rlwi != null) {
            EWAHCompressedBitmap.discharge(rlwi, i, container);
        }
        if (rlwj != null) {
            EWAHCompressedBitmap.discharge(rlwj, j, container);
        }
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public static EWAHCompressedBitmap or(EWAHCompressedBitmap ... bitmaps) {
        EWAHCompressedBitmap container = new EWAHCompressedBitmap();
        int largestSize = 0;
        for (EWAHCompressedBitmap bitmap : bitmaps) {
            largestSize = Math.max(bitmap.actualsizeinwords, largestSize);
        }
        container.reserve((int)((double)largestSize * 1.5));
        EWAHCompressedBitmap.or((BitmapStorage)container, bitmaps);
        return container;
    }

    public static int orCardinality(EWAHCompressedBitmap ... bitmaps) {
        BitCounter counter = new BitCounter();
        EWAHCompressedBitmap.or(counter, bitmaps);
        return counter.getCount();
    }

    /*
     * Unable to fully structure code
     */
    private static void or(BitmapStorage container, EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 2) {
            bitmaps[0].or(bitmaps[1], container);
            return;
        }
        sortedBitmaps = (EWAHCompressedBitmap[])bitmaps.clone();
        Arrays.sort(sortedBitmaps, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return a.sizeinbits < b.sizeinbits ? 1 : (a.sizeinbits == b.sizeinbits ? 0 : -1);
            }
        });
        rlws = new IteratingBufferedRunningLengthWord[bitmaps.length];
        maxAvailablePos = 0;
        for (EWAHCompressedBitmap bitmap : sortedBitmaps) {
            iterator = bitmap.getEWAHIterator();
            if (!iterator.hasNext()) continue;
            rlws[maxAvailablePos++] = new IteratingBufferedRunningLengthWord(iterator);
        }
        if (maxAvailablePos == 0) {
            container.setSizeInBits(0);
            return;
        }
        maxSize = sortedBitmaps[0].sizeinbits;
        block1: while (true) {
            maxOneRl = 0L;
            minZeroRl = 0x7FFFFFFFFFFFFFFFL;
            minSize = 0x7FFFFFFFFFFFFFFFL;
            numEmptyRl = 0;
            for (i = 0; i < maxAvailablePos; ++i) {
                rlw = rlws[i];
                size = rlw.size();
                if (size == 0L) {
                    maxAvailablePos = i;
                    break;
                }
                minSize = Math.min(minSize, size);
                if (rlw.getRunningBit()) {
                    rl = rlw.getRunningLength();
                    maxOneRl = Math.max(maxOneRl, rl);
                    minZeroRl = 0L;
                    if (rl != 0L || size <= 0L) continue;
                    ++numEmptyRl;
                    continue;
                }
                rl = rlw.getRunningLength();
                minZeroRl = Math.min(minZeroRl, rl);
                if (rl != 0L || size <= 0L) continue;
                ++numEmptyRl;
            }
            if (maxAvailablePos == 0) break;
            if (maxAvailablePos == 1) {
                rlws[0].discharge(container);
                break;
            }
            if (maxOneRl > 0L) {
                container.addStreamOfEmptyWords(true, maxOneRl);
                i = 0;
                while (true) {
                    if (i >= maxAvailablePos) continue block1;
                    rlw = rlws[i];
                    rlw.discardFirstWords(maxOneRl);
                    ++i;
                }
            }
            if (minZeroRl > 0L) {
                container.addStreamOfEmptyWords(false, minZeroRl);
                i = 0;
                while (true) {
                    if (i >= maxAvailablePos) continue block1;
                    rlw = rlws[i];
                    rlw.discardFirstWords(minZeroRl);
                    ++i;
                }
            }
            index = 0;
            if (numEmptyRl == 1) {
                emptyRl = null;
                minNonEmptyRl = 0x7FFFFFFFFFFFFFFFL;
                for (i = 0; i < maxAvailablePos; ++i) {
                    rlw = rlws[i];
                    rl = rlw.getRunningLength();
                    if (rl == 0L) {
                        if (!EWAHCompressedBitmap.$assertionsDisabled && emptyRl != null) {
                            throw new AssertionError();
                        }
                        emptyRl = rlw;
                        continue;
                    }
                    minNonEmptyRl = Math.min(minNonEmptyRl, rl);
                }
                v0 = wordsToWrite = minNonEmptyRl > minSize ? minSize : minNonEmptyRl;
                if (emptyRl != null) {
                    emptyRl.writeDirtyWords((int)wordsToWrite, container);
                }
                index = (int)((long)index + wordsToWrite);
            }
            while ((long)index < minSize) {
                word = 0L;
                for (i = 0; i < maxAvailablePos; ++i) {
                    rlw = rlws[i];
                    if (rlw.getRunningLength() > (long)index) continue;
                    word |= rlw.getDirtyWordAt(index - (int)rlw.getRunningLength());
                }
                container.add(word);
                ++index;
            }
            i = 0;
            while (true) {
                if (i < maxAvailablePos) ** break;
                continue block1;
                rlw = rlws[i];
                rlw.discardFirstWords(minSize);
                ++i;
            }
            break;
        }
        container.setSizeInBits(maxSize);
    }

    protected static void discharge(BufferedRunningLengthWord initialWord, EWAHIterator iterator, BitmapStorage container) {
        BufferedRunningLengthWord runningLengthWord = initialWord;
        while (true) {
            long runningLength = runningLengthWord.getRunningLength();
            container.addStreamOfEmptyWords(runningLengthWord.getRunningBit(), runningLength);
            container.addStreamOfDirtyWords(iterator.buffer(), iterator.dirtyWords() + runningLengthWord.dirtywordoffset, runningLengthWord.getNumberOfLiteralWords());
            if (!iterator.hasNext()) break;
            runningLengthWord = new BufferedRunningLengthWord(iterator.next());
        }
    }

    private static void dischargeAsEmpty(BufferedRunningLengthWord initialWord, EWAHIterator iterator, BitmapStorage container) {
        BufferedRunningLengthWord runningLengthWord = initialWord;
        while (true) {
            long runningLength = runningLengthWord.getRunningLength();
            container.addStreamOfEmptyWords(false, runningLength + (long)runningLengthWord.getNumberOfLiteralWords());
            if (!iterator.hasNext()) break;
            runningLengthWord = new BufferedRunningLengthWord(iterator.next());
        }
    }

    public boolean set(int i) {
        if (i < this.sizeinbits) {
            return false;
        }
        int dist = (i + 64) / 64 - (this.sizeinbits + 64 - 1) / 64;
        this.sizeinbits = i + 1;
        if (dist > 0) {
            if (dist > 1) {
                this.fastaddStreamOfEmptyWords(false, dist - 1);
            }
            this.addLiteralWord(1L << i % 64);
            return true;
        }
        if (this.rlw.getNumberOfLiteralWords() == 0) {
            this.rlw.setRunningLength(this.rlw.getRunningLength() - 1L);
            this.addLiteralWord(1L << i % 64);
            return true;
        }
        int n = this.actualsizeinwords - 1;
        this.buffer[n] = this.buffer[n] | 1L << i % 64;
        if (this.buffer[this.actualsizeinwords - 1] == -1L) {
            this.buffer[this.actualsizeinwords - 1] = 0L;
            --this.actualsizeinwords;
            this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
            this.addEmptyWord(true);
        }
        return true;
    }

    @Override
    public void add(long newdata) {
        this.add(newdata, 64);
    }

    @Override
    public void addStreamOfEmptyWords(boolean v, long number) {
        if (number == 0L) {
            return;
        }
        this.sizeinbits = (int)((long)this.sizeinbits + number * 64L);
        if (this.rlw.getRunningBit() != v && this.rlw.size() == 0L) {
            this.rlw.setRunningBit(v);
        } else if (this.rlw.getNumberOfLiteralWords() != 0 || this.rlw.getRunningBit() != v) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
        }
        long runlen = this.rlw.getRunningLength();
        long whatwecanadd = number < 0xFFFFFFFFL - runlen ? number : 0xFFFFFFFFL - runlen;
        this.rlw.setRunningLength(runlen + whatwecanadd);
        number -= whatwecanadd;
        while (number >= 0xFFFFFFFFL) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(0xFFFFFFFFL);
            number -= 0xFFFFFFFFL;
        }
        if (number > 0L) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(number);
        }
    }

    private void fastaddStreamOfEmptyWords(boolean v, long number) {
        if (this.rlw.getRunningBit() != v && this.rlw.size() == 0L) {
            this.rlw.setRunningBit(v);
        } else if (this.rlw.getNumberOfLiteralWords() != 0 || this.rlw.getRunningBit() != v) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
        }
        long runlen = this.rlw.getRunningLength();
        long whatwecanadd = number < 0xFFFFFFFFL - runlen ? number : 0xFFFFFFFFL - runlen;
        this.rlw.setRunningLength(runlen + whatwecanadd);
        number -= whatwecanadd;
        while (number >= 0xFFFFFFFFL) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(0xFFFFFFFFL);
            number -= 0xFFFFFFFFL;
        }
        if (number > 0L) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(number);
        }
    }

    @Override
    public void addStreamOfNegatedDirtyWords(long[] data, int start, int number) {
        if (number == 0) {
            return;
        }
        int NumberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
        int whatwecanadd = number < Integer.MAX_VALUE - NumberOfLiteralWords ? number : Integer.MAX_VALUE - NumberOfLiteralWords;
        this.rlw.setNumberOfLiteralWords(NumberOfLiteralWords + whatwecanadd);
        int leftovernumber = number - whatwecanadd;
        this.negative_push_back(data, start, whatwecanadd);
        this.sizeinbits += whatwecanadd * 64;
        if (leftovernumber > 0) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            this.addStreamOfDirtyWords(data, start + whatwecanadd, leftovernumber);
        }
    }

    @Override
    public void addStreamOfDirtyWords(long[] data, int start, int number) {
        if (number == 0) {
            return;
        }
        int NumberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
        int whatwecanadd = number < Integer.MAX_VALUE - NumberOfLiteralWords ? number : Integer.MAX_VALUE - NumberOfLiteralWords;
        this.rlw.setNumberOfLiteralWords(NumberOfLiteralWords + whatwecanadd);
        int leftovernumber = number - whatwecanadd;
        this.push_back(data, start, whatwecanadd);
        this.sizeinbits += whatwecanadd * 64;
        if (leftovernumber > 0) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            this.addStreamOfDirtyWords(data, start + whatwecanadd, leftovernumber);
        }
    }

    public void add(long newdata, int bitsthatmatter) {
        this.sizeinbits += bitsthatmatter;
        if (newdata == 0L) {
            this.addEmptyWord(false);
        } else if (newdata == -1L) {
            this.addEmptyWord(true);
        } else {
            this.addLiteralWord(newdata);
        }
    }

    public int sizeInBits() {
        return this.sizeinbits;
    }

    @Override
    public void setSizeInBits(int size) {
        this.sizeinbits = size;
    }

    public boolean setSizeInBits(int size, boolean defaultvalue) {
        if (size < this.sizeinbits) {
            return false;
        }
        if (defaultvalue) {
            while (this.sizeinbits % 64 != 0 && this.sizeinbits < size) {
                this.set(this.sizeinbits);
            }
        }
        if (!defaultvalue) {
            EWAHCompressedBitmap.extendEmptyBits(this, this.sizeinbits, size);
        } else {
            int leftover = size % 64;
            this.addStreamOfEmptyWords(defaultvalue, size / 64 - this.sizeinbits / 64);
            long newdata = (1L << leftover) + ((1L << leftover) - 1L);
            this.addLiteralWord(newdata);
        }
        this.sizeinbits = size;
        return true;
    }

    private static void extendEmptyBits(BitmapStorage storage, int currentSize, int newSize) {
        int currentLeftover = currentSize % 64;
        int finalLeftover = newSize % 64;
        storage.addStreamOfEmptyWords(false, newSize / 64 - currentSize / 64 + (finalLeftover != 0 ? 1 : 0) + (currentLeftover != 0 ? -1 : 0));
    }

    public int sizeInBytes() {
        return this.actualsizeinwords * 8;
    }

    private boolean reserve(int size) {
        if (size > this.buffer.length) {
            long[] oldbuffer = this.buffer;
            this.buffer = new long[size];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.array = this.buffer;
            return true;
        }
        return false;
    }

    private void push_back(long data) {
        if (this.actualsizeinwords == this.buffer.length) {
            long[] oldbuffer = this.buffer;
            this.buffer = new long[oldbuffer.length * 2];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.array = this.buffer;
        }
        this.buffer[this.actualsizeinwords++] = data;
    }

    private void push_back(long[] data, int start, int number) {
        while (this.actualsizeinwords + number >= this.buffer.length) {
            long[] oldbuffer = this.buffer;
            this.buffer = new long[oldbuffer.length * 2];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.array = this.buffer;
        }
        System.arraycopy(data, start, this.buffer, this.actualsizeinwords, number);
        this.actualsizeinwords += number;
    }

    private void negative_push_back(long[] data, int start, int number) {
        while (this.actualsizeinwords + number >= this.buffer.length) {
            long[] oldbuffer = this.buffer;
            this.buffer = new long[oldbuffer.length * 2];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.array = this.buffer;
        }
        for (int k = 0; k < number; ++k) {
            this.buffer[this.actualsizeinwords + k] = data[start + k] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.actualsizeinwords += number;
    }

    private void addEmptyWord(boolean v) {
        boolean noliteralword = this.rlw.getNumberOfLiteralWords() == 0;
        long runlen = this.rlw.getRunningLength();
        if (noliteralword && runlen == 0L) {
            this.rlw.setRunningBit(v);
        }
        if (noliteralword && this.rlw.getRunningBit() == v && runlen < 0xFFFFFFFFL) {
            this.rlw.setRunningLength(runlen + 1L);
            return;
        }
        this.push_back(0L);
        this.rlw.position = this.actualsizeinwords - 1;
        this.rlw.setRunningBit(v);
        this.rlw.setRunningLength(1L);
    }

    private void addLiteralWord(long newdata) {
        int numbersofar = this.rlw.getNumberOfLiteralWords();
        if (numbersofar >= Integer.MAX_VALUE) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            this.rlw.setNumberOfLiteralWords(1L);
            this.push_back(newdata);
        }
        this.rlw.setNumberOfLiteralWords(numbersofar + 1);
        this.push_back(newdata);
    }

    public int cardinality() {
        int counter = 0;
        EWAHIterator i = new EWAHIterator(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            RunningLengthWord localrlw = i.next();
            if (localrlw.getRunningBit()) {
                counter = (int)((long)counter + 64L * localrlw.getRunningLength());
            }
            for (int j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                counter += Long.bitCount(i.buffer()[i.dirtyWords() + j]);
            }
        }
        return counter;
    }

    public String toString() {
        String ans = " EWAHCompressedBitmap, size in bits = " + this.sizeinbits + " size in words = " + this.actualsizeinwords + "\n";
        EWAHIterator i = new EWAHIterator(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            RunningLengthWord localrlw = i.next();
            ans = localrlw.getRunningBit() ? ans + localrlw.getRunningLength() + " 1x11\n" : ans + localrlw.getRunningLength() + " 0x00\n";
            ans = ans + localrlw.getNumberOfLiteralWords() + " dirties\n";
        }
        return ans;
    }

    public String toDebugString() {
        String ans = " EWAHCompressedBitmap, size in bits = " + this.sizeinbits + " size in words = " + this.actualsizeinwords + "\n";
        EWAHIterator i = new EWAHIterator(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            RunningLengthWord localrlw = i.next();
            ans = localrlw.getRunningBit() ? ans + localrlw.getRunningLength() + " 1x11\n" : ans + localrlw.getRunningLength() + " 0x00\n";
            ans = ans + localrlw.getNumberOfLiteralWords() + " dirties\n";
            for (int j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                long data = i.buffer()[i.dirtyWords() + j];
                ans = ans + "\t" + data + "\n";
            }
        }
        return ans;
    }

    public int[] toArray() {
        int[] ans = new int[this.cardinality()];
        int inanspos = 0;
        int pos = 0;
        EWAHIterator i = new EWAHIterator(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            int j;
            RunningLengthWord localrlw = i.next();
            if (localrlw.getRunningBit()) {
                j = 0;
                while ((long)j < localrlw.getRunningLength()) {
                    for (int c = 0; c < 64; ++c) {
                        ans[inanspos++] = pos++;
                    }
                    ++j;
                }
            } else {
                pos = (int)((long)pos + 64L * localrlw.getRunningLength());
            }
            for (j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                int ntz;
                for (long data = i.buffer()[i.dirtyWords() + j]; data != 0L; data ^= 1L << ntz) {
                    ntz = Long.numberOfTrailingZeros(data);
                    ans[inanspos++] = ntz + pos;
                }
                pos += 64;
            }
        }
        return ans;
    }

    public IntIterator intIterator() {
        final EWAHIterator i = new EWAHIterator(this.buffer, this.actualsizeinwords);
        return new IntIterator(){
            int pos = 0;
            RunningLengthWord localrlw = null;
            static final int initcapacity = 512;
            int[] localbuffer = new int[512];
            int localbuffersize = 0;
            int bufferpos = 0;
            boolean status = this.queryStatus();

            public boolean hasNext() {
                return this.status;
            }

            public boolean queryStatus() {
                while (this.localbuffersize == 0) {
                    if (!this.loadNextRLE()) {
                        return false;
                    }
                    this.loadBuffer();
                }
                return true;
            }

            private boolean loadNextRLE() {
                if (i.hasNext()) {
                    this.localrlw = i.next();
                    return true;
                }
                return false;
            }

            private void add(int val) {
                ++this.localbuffersize;
                if (this.localbuffersize > this.localbuffer.length) {
                    int[] oldbuffer = this.localbuffer;
                    this.localbuffer = new int[this.localbuffer.length * 2];
                    System.arraycopy(oldbuffer, 0, this.localbuffer, 0, oldbuffer.length);
                }
                this.localbuffer[this.localbuffersize - 1] = val;
            }

            private void loadBuffer() {
                int j;
                this.bufferpos = 0;
                this.localbuffersize = 0;
                if (this.localrlw.getRunningBit()) {
                    j = 0;
                    while ((long)j < this.localrlw.getRunningLength()) {
                        for (int c = 0; c < 64; ++c) {
                            this.add(this.pos++);
                        }
                        ++j;
                    }
                } else {
                    this.pos = (int)((long)this.pos + 64L * this.localrlw.getRunningLength());
                }
                for (j = 0; j < this.localrlw.getNumberOfLiteralWords(); ++j) {
                    int ntz;
                    for (long data = i.buffer()[i.dirtyWords() + j]; data != 0L; data ^= 1L << ntz) {
                        ntz = Long.numberOfTrailingZeros(data);
                        this.add(ntz + this.pos);
                    }
                    this.pos += 64;
                }
            }

            public int next() {
                int answer = this.localbuffer[this.bufferpos++];
                if (this.localbuffersize == this.bufferpos) {
                    this.localbuffersize = 0;
                    this.status = this.queryStatus();
                }
                return answer;
            }
        };
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private final IntIterator under;
            {
                this.under = EWAHCompressedBitmap.this.intIterator();
            }

            @Override
            public Integer next() {
                return new Integer(this.under.next());
            }

            @Override
            public boolean hasNext() {
                return this.under.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("bitsets do not support remove");
            }
        };
    }

    public List<Integer> getPositions() {
        ArrayList<Integer> v = new ArrayList<Integer>();
        EWAHIterator i = new EWAHIterator(this.buffer, this.actualsizeinwords);
        int pos = 0;
        while (i.hasNext()) {
            int j;
            RunningLengthWord localrlw = i.next();
            if (localrlw.getRunningBit()) {
                j = 0;
                while ((long)j < localrlw.getRunningLength()) {
                    for (int c = 0; c < 64; ++c) {
                        v.add(new Integer(pos++));
                    }
                    ++j;
                }
            } else {
                pos = (int)((long)pos + 64L * localrlw.getRunningLength());
            }
            for (j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                int ntz;
                for (long data = i.buffer()[i.dirtyWords() + j]; data != 0L; data ^= 1L << ntz) {
                    ntz = Long.numberOfTrailingZeros(data);
                    v.add(new Integer(ntz + pos));
                }
                pos += 64;
            }
        }
        while (v.size() > 0 && v.get(v.size() - 1) >= this.sizeinbits) {
            v.remove(v.size() - 1);
        }
        return v;
    }

    public boolean equals(Object o) {
        if (o instanceof EWAHCompressedBitmap) {
            EWAHCompressedBitmap other = (EWAHCompressedBitmap)o;
            if (this.sizeinbits == other.sizeinbits && this.actualsizeinwords == other.actualsizeinwords && this.rlw.position == other.rlw.position) {
                for (int k = 0; k < this.actualsizeinwords; ++k) {
                    if (this.buffer[k] == other.buffer[k]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int karprabin = 0;
        int B = 31;
        for (int k = 0; k < this.actualsizeinwords; ++k) {
            karprabin = (int)((long)karprabin + ((long)(31 * karprabin) + (this.buffer[k] & 0xFFFFFFFFL)));
            karprabin = (int)((long)karprabin + ((long)(31 * karprabin) + (this.buffer[k] >>> 32)));
        }
        return this.sizeinbits ^ karprabin;
    }

    public Object clone() throws CloneNotSupportedException {
        EWAHCompressedBitmap clone = (EWAHCompressedBitmap)super.clone();
        clone.buffer = (long[])this.buffer.clone();
        clone.rlw = new RunningLengthWord(clone.buffer, this.rlw.position);
        clone.actualsizeinwords = this.actualsizeinwords;
        clone.sizeinbits = this.sizeinbits;
        return clone;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.deserialize(in);
    }

    public void deserialize(DataInput in) throws IOException {
        this.sizeinbits = in.readInt();
        this.actualsizeinwords = in.readInt();
        if (this.buffer.length < this.actualsizeinwords) {
            this.buffer = new long[this.actualsizeinwords];
        }
        for (int k = 0; k < this.actualsizeinwords; ++k) {
            this.buffer[k] = in.readLong();
        }
        this.rlw = new RunningLengthWord(this.buffer, in.readInt());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    public void serialize(DataOutput out) throws IOException {
        out.writeInt(this.sizeinbits);
        out.writeInt(this.actualsizeinwords);
        for (int k = 0; k < this.actualsizeinwords; ++k) {
            out.writeLong(this.buffer[k]);
        }
        out.writeInt(this.rlw.position);
    }

    public int serializedSizeInBytes() {
        return this.sizeInBytes() + 12;
    }

    public void clear() {
        this.sizeinbits = 0;
        this.actualsizeinwords = 1;
        this.rlw.position = 0;
        this.buffer[0] = 0L;
    }
}

