/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.blaisemath.graph.view;

import com.google.common.base.Functions;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.googlecode.blaisemath.coordinate.CoordinateManager;
import com.googlecode.blaisemath.graph.layout.GraphLayoutManager;
import com.googlecode.blaisemath.graphics.Renderer;
import com.googlecode.blaisemath.graphics.impl.DelegatingNodeLinkGraphic;
import com.googlecode.blaisemath.primitive.AnchoredText;
import com.googlecode.blaisemath.style.AttributeSet;
import com.googlecode.blaisemath.style.ObjectStyler;
import com.googlecode.blaisemath.style.Styles;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VisualGraph<G> {
    public static final AttributeSet DEFAULT_NODE_STYLE = Styles.fillStroke((Color)new Color(0, 0, 128, 128), (Color)new Color(0, 0, 128, 192), (float)0.5f).and("marker-radius", (Object)Float.valueOf(3.0f));
    public static final AttributeSet DEFAULT_EDGE_STYLE = Styles.strokeWidth((Color)new Color(0, 128, 0, 128), (float)1.0f);
    private final @Nullable Supplier<DelegatingNodeLinkGraphic<Object, EndpointPair<Object>, G>> viewGraphSupplier;
    private @Nullable DelegatingNodeLinkGraphic<Object, EndpointPair<Object>, G> viewGraph;
    private GraphLayoutManager layoutManager;
    protected final PropertyChangeListener layoutListener;

    public VisualGraph(Graph graph) {
        this(GraphLayoutManager.create((Graph)graph), null);
    }

    public VisualGraph(GraphLayoutManager manager, @Nullable Supplier<DelegatingNodeLinkGraphic<Object, EndpointPair<Object>, G>> graphicSupplier) {
        this.viewGraphSupplier = graphicSupplier;
        this.layoutListener = evt -> this.initViewGraph();
        this.setLayoutManager(manager);
    }

    protected final void initViewGraph() {
        if (this.viewGraph == null) {
            if (this.viewGraphSupplier != null) {
                this.viewGraph = this.viewGraphSupplier.get();
            } else {
                this.viewGraph = new DelegatingNodeLinkGraphic(this.layoutManager.getCoordinateManager(), null, null, null);
                this.viewGraph.getNodeStyler().setStyle(DEFAULT_NODE_STYLE);
            }
            if (this.viewGraph.getNodeStyler().getStyleDelegate() == null) {
                this.viewGraph.getNodeStyler().setStyle(DEFAULT_NODE_STYLE);
            }
            if (this.viewGraph.getNodeStyler().getLabelDelegate() == null) {
                this.viewGraph.getNodeStyler().setLabelDelegate((Function)Functions.toStringFunction());
            }
            if (this.viewGraph.getNodeStyler().getTipDelegate() == null) {
                this.viewGraph.getNodeStyler().setTipDelegate((Function)Functions.toStringFunction());
            }
            if (this.viewGraph.getEdgeStyler().getStyleDelegate() == null) {
                this.viewGraph.getEdgeStyler().setStyle(DEFAULT_EDGE_STYLE);
            }
        } else {
            this.viewGraph.setCoordinateManager(this.layoutManager.getCoordinateManager());
        }
        this.viewGraph.setEdgeSet(this.layoutManager.getGraph().edges());
    }

    public DelegatingNodeLinkGraphic getViewGraph() {
        return this.viewGraph;
    }

    public GraphLayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public final void setLayoutManager(GraphLayoutManager manager) {
        if (this.layoutManager != manager) {
            if (this.layoutManager != null) {
                this.layoutManager.removePropertyChangeListener("graph", this.layoutListener);
            }
            this.layoutManager = manager;
            this.initViewGraph();
            this.layoutManager.addPropertyChangeListener("graph", this.layoutListener);
        }
    }

    public CoordinateManager getCoordinateManager() {
        return this.layoutManager.getCoordinateManager();
    }

    public Graph getGraph() {
        return this.layoutManager.getGraph();
    }

    public void setGraph(Graph g) {
        this.layoutManager.setGraph(g);
    }

    public ObjectStyler<Object> getNodeStyler() {
        return this.viewGraph.getNodeStyler();
    }

    public void setNodeStyler(ObjectStyler<Object> styler) {
        this.viewGraph.setNodeStyler(styler);
    }

    public Renderer<Point2D, G> getNodeRenderer() {
        return this.viewGraph.getNodeRenderer();
    }

    public void setNodeRenderer(Renderer<Point2D, G> renderer) {
        this.viewGraph.setNodeRenderer(renderer);
    }

    public Renderer<AnchoredText, G> getLabelRenderer() {
        return this.viewGraph.getLabelRenderer();
    }

    public void setLabelRenderer(Renderer<AnchoredText, G> renderer) {
        this.viewGraph.setLabelRenderer(renderer);
    }

    public ObjectStyler<EndpointPair<Object>> getEdgeStyler() {
        return this.viewGraph.getEdgeStyler();
    }

    public void setEdgeStyler(ObjectStyler<EndpointPair<Object>> styler) {
        this.viewGraph.setEdgeStyler(styler);
    }

    public Renderer<Shape, G> getEdgeRenderer() {
        return this.viewGraph.getEdgeRenderer();
    }

    public final void setEdgeRenderer(Renderer<Shape, G> renderer) {
        this.viewGraph.setEdgeRenderer(renderer);
    }
}

