/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.parser;

import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.datatable.value.BooleanValue;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.TextValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.AggregationType;
import com.google.visualization.datasource.query.ColumnColumnFilter;
import com.google.visualization.datasource.query.ColumnIsNullFilter;
import com.google.visualization.datasource.query.ColumnValueFilter;
import com.google.visualization.datasource.query.ComparisonFilter;
import com.google.visualization.datasource.query.CompoundFilter;
import com.google.visualization.datasource.query.NegationFilter;
import com.google.visualization.datasource.query.Query;
import com.google.visualization.datasource.query.QueryFilter;
import com.google.visualization.datasource.query.QueryFormat;
import com.google.visualization.datasource.query.QueryGroup;
import com.google.visualization.datasource.query.QueryLabels;
import com.google.visualization.datasource.query.QueryOptions;
import com.google.visualization.datasource.query.QueryPivot;
import com.google.visualization.datasource.query.QuerySelection;
import com.google.visualization.datasource.query.QuerySort;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import com.google.visualization.datasource.query.SimpleColumn;
import com.google.visualization.datasource.query.SortOrder;
import com.google.visualization.datasource.query.parser.GenericsHelper;
import com.google.visualization.datasource.query.parser.JavaCharStream;
import com.google.visualization.datasource.query.parser.ParseException;
import com.google.visualization.datasource.query.parser.ParserUtils;
import com.google.visualization.datasource.query.parser.QueryOptionEnum;
import com.google.visualization.datasource.query.parser.QueryParserConstants;
import com.google.visualization.datasource.query.parser.QueryParserTokenManager;
import com.google.visualization.datasource.query.parser.Token;
import com.google.visualization.datasource.query.scalarfunction.Constant;
import com.google.visualization.datasource.query.scalarfunction.CurrentDateTime;
import com.google.visualization.datasource.query.scalarfunction.DateDiff;
import com.google.visualization.datasource.query.scalarfunction.Difference;
import com.google.visualization.datasource.query.scalarfunction.Lower;
import com.google.visualization.datasource.query.scalarfunction.Modulo;
import com.google.visualization.datasource.query.scalarfunction.Product;
import com.google.visualization.datasource.query.scalarfunction.Quotient;
import com.google.visualization.datasource.query.scalarfunction.ScalarFunction;
import com.google.visualization.datasource.query.scalarfunction.Sum;
import com.google.visualization.datasource.query.scalarfunction.TimeComponentExtractor;
import com.google.visualization.datasource.query.scalarfunction.ToDate;
import com.google.visualization.datasource.query.scalarfunction.Upper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class QueryParser
implements QueryParserConstants {
    public QueryParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[48];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[6];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List jj_expentries = new ArrayList();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static Query parseString(String string) throws ParseException, InvalidQueryException {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        QueryParser queryParser = new QueryParser(bufferedReader);
        Query query = queryParser.queryStatement();
        return query;
    }

    public final Query queryStatement() throws ParseException, InvalidQueryException {
        Query query = new Query();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.selectClause(query);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.whereClause(query);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.groupByClause(query);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.pivotClause(query);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.orderByClause(query);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.skippingClause(query);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.limitClause(query);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.offsetClause(query);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.labelClause(query);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.formatClause(query);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                this.optionsClause(query);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        this.jj_consume_token(0);
        return query;
    }

    public final void selectClause(Query query) throws ParseException, InvalidQueryException {
        QuerySelection querySelection = new QuerySelection();
        this.jj_consume_token(5);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 63: 
            case 64: 
            case 66: 
            case 76: {
                AbstractColumn abstractColumn = this.abstractColumnDescriptor();
                querySelection.addColumn(abstractColumn);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 65: {
                            break;
                        }
                        default: {
                            this.jj_la1[11] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(65);
                    abstractColumn = this.abstractColumnDescriptor();
                    querySelection.addColumn(abstractColumn);
                }
                query.setSelection(querySelection);
                break;
            }
            case 74: {
                this.jj_consume_token(74);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void whereClause(Query query) throws ParseException, InvalidQueryException {
        this.jj_consume_token(6);
        QueryFilter queryFilter = this.logicalExpression();
        query.setFilter(queryFilter);
    }

    public final void groupByClause(Query query) throws ParseException, InvalidQueryException {
        QueryGroup queryGroup = new QueryGroup();
        this.jj_consume_token(7);
        this.jj_consume_token(10);
        AbstractColumn abstractColumn = this.abstractColumnDescriptor();
        queryGroup.addColumn(abstractColumn);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 65: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(65);
            abstractColumn = this.abstractColumnDescriptor();
            queryGroup.addColumn(abstractColumn);
        }
        query.setGroup(queryGroup);
    }

    public final void pivotClause(Query query) throws ParseException, InvalidQueryException {
        QueryPivot queryPivot = new QueryPivot();
        this.jj_consume_token(8);
        AbstractColumn abstractColumn = this.abstractColumnDescriptor();
        queryPivot.addColumn(abstractColumn);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 65: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(65);
            abstractColumn = this.abstractColumnDescriptor();
            queryPivot.addColumn(abstractColumn);
        }
        query.setPivot(queryPivot);
    }

    public final void orderByClause(Query query) throws ParseException, InvalidQueryException {
        QuerySort querySort = new QuerySort();
        this.jj_consume_token(9);
        this.jj_consume_token(10);
        AbstractColumn abstractColumn = this.abstractColumnDescriptor();
        SortOrder sortOrder = this.sortOrder();
        querySort.addSort(abstractColumn, sortOrder);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 65: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(65);
            abstractColumn = this.abstractColumnDescriptor();
            sortOrder = this.sortOrder();
            querySort.addSort(abstractColumn, sortOrder);
        }
        query.setSort(querySort);
    }

    public final void skippingClause(Query query) throws ParseException, InvalidQueryException {
        this.jj_consume_token(11);
        int n = this.integerLiteral();
        query.setRowSkipping(n);
    }

    public final void limitClause(Query query) throws ParseException, InvalidQueryException {
        this.jj_consume_token(12);
        int n = this.integerLiteral();
        query.setRowLimit(n);
    }

    public final void offsetClause(Query query) throws ParseException, InvalidQueryException {
        this.jj_consume_token(13);
        int n = this.integerLiteral();
        query.setRowOffset(n);
    }

    public final void labelClause(Query query) throws ParseException, InvalidQueryException {
        QueryLabels queryLabels = new QueryLabels();
        this.jj_consume_token(14);
        AbstractColumn abstractColumn = this.abstractColumnDescriptor();
        String string = this.stringLiteral();
        queryLabels.addLabel(abstractColumn, string);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 65: {
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(65);
            abstractColumn = this.abstractColumnDescriptor();
            string = this.stringLiteral();
            queryLabels.addLabel(abstractColumn, string);
        }
        query.setLabels(queryLabels);
    }

    public final void formatClause(Query query) throws ParseException, InvalidQueryException {
        QueryFormat queryFormat = new QueryFormat();
        this.jj_consume_token(15);
        AbstractColumn abstractColumn = this.abstractColumnDescriptor();
        String string = this.stringLiteral();
        queryFormat.addPattern(abstractColumn, string);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 65: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(65);
            abstractColumn = this.abstractColumnDescriptor();
            string = this.stringLiteral();
            queryFormat.addPattern(abstractColumn, string);
        }
        query.setUserFormatOptions(queryFormat);
    }

    public final void optionsClause(Query query) throws ParseException {
        QueryOptions queryOptions = new QueryOptions();
        this.jj_consume_token(16);
        block3: while (true) {
            QueryOptionEnum queryOptionEnum = this.queryOption();
            queryOptionEnum.setInQueryOptions(queryOptions);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: 
                case 34: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[18] = this.jj_gen;
        query.setOptions(queryOptions);
    }

    public final QueryFilter logicalExpression() throws ParseException, InvalidQueryException {
        QueryFilter queryFilter = this.possibleOrExpression();
        return queryFilter;
    }

    public final QueryFilter possibleOrExpression() throws ParseException, InvalidQueryException {
        ArrayList<QueryFilter> arrayList = new ArrayList<QueryFilter>();
        QueryFilter queryFilter = this.possibleAndExpression();
        arrayList.add(queryFilter);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(22);
            queryFilter = this.possibleAndExpression();
            arrayList.add(queryFilter);
        }
        if (arrayList.size() == 1) {
            return (QueryFilter)arrayList.get(0);
        }
        return new CompoundFilter(CompoundFilter.LogicalOperator.OR, GenericsHelper.makeTypedList(arrayList));
    }

    public final QueryFilter possibleAndExpression() throws ParseException, InvalidQueryException {
        ArrayList<QueryFilter> arrayList = new ArrayList<QueryFilter>();
        QueryFilter queryFilter = this.possibleNotExpression();
        arrayList.add(queryFilter);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(21);
            queryFilter = this.possibleNotExpression();
            arrayList.add(queryFilter);
        }
        if (arrayList.size() == 1) {
            return (QueryFilter)arrayList.get(0);
        }
        return new CompoundFilter(CompoundFilter.LogicalOperator.AND, GenericsHelper.makeTypedList(arrayList));
    }

    public final QueryFilter possibleNotExpression() throws ParseException, InvalidQueryException {
        QueryFilter queryFilter;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                QueryFilter queryFilter2 = this.primaryExpression();
                queryFilter = new NegationFilter(queryFilter2);
                break;
            }
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 63: 
            case 64: 
            case 66: 
            case 76: {
                QueryFilter queryFilter3;
                queryFilter = queryFilter3 = this.primaryExpression();
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return queryFilter;
    }

    public final QueryFilter primaryExpression() throws ParseException, InvalidQueryException {
        QueryFilter queryFilter;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            queryFilter = this.primitiveFilter();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 66: {
                    this.jj_consume_token(66);
                    queryFilter = this.logicalExpression();
                    this.jj_consume_token(67);
                    break;
                }
                default: {
                    this.jj_la1[22] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return queryFilter;
    }

    public final QueryFilter primitiveFilter() throws ParseException, InvalidQueryException {
        QueryFilter queryFilter;
        if (this.jj_2_3(Integer.MAX_VALUE)) {
            Value value = this.literal();
            ComparisonFilter.Operator operator = this.comparisonOperator();
            AbstractColumn abstractColumn = this.abstractColumnDescriptor();
            queryFilter = new ColumnValueFilter(abstractColumn, value, operator, true);
        } else {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: 
                case 20: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 63: 
                case 64: 
                case 66: 
                case 76: {
                    AbstractColumn abstractColumn = this.abstractColumnDescriptor();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: {
                            this.jj_consume_token(35);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 36: {
                                    this.jj_consume_token(36);
                                    queryFilter = new ColumnIsNullFilter(abstractColumn);
                                    break block0;
                                }
                                case 23: {
                                    this.jj_consume_token(23);
                                    this.jj_consume_token(36);
                                    queryFilter = new NegationFilter(new ColumnIsNullFilter(abstractColumn));
                                    break block0;
                                }
                            }
                            this.jj_la1[23] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: {
                            ComparisonFilter.Operator operator = this.comparisonOperator();
                            if (this.jj_2_2(Integer.MAX_VALUE)) {
                                Value value = this.literal();
                                queryFilter = new ColumnValueFilter(abstractColumn, value, operator, false);
                                break block0;
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 19: 
                                case 20: 
                                case 24: 
                                case 25: 
                                case 26: 
                                case 27: 
                                case 28: 
                                case 29: 
                                case 30: 
                                case 31: 
                                case 32: 
                                case 33: 
                                case 34: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 38: 
                                case 39: 
                                case 40: 
                                case 41: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 45: 
                                case 46: 
                                case 47: 
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: 
                                case 58: 
                                case 59: 
                                case 63: 
                                case 64: 
                                case 66: 
                                case 76: {
                                    AbstractColumn abstractColumn2 = this.abstractColumnDescriptor();
                                    queryFilter = new ColumnColumnFilter(abstractColumn, abstractColumn2, operator);
                                    break block0;
                                }
                            }
                            this.jj_la1[24] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_la1[25] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return queryFilter;
    }

    public final ComparisonFilter.Operator comparisonOperator() throws ParseException {
        ComparisonFilter.Operator operator;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 68: {
                this.jj_consume_token(68);
                operator = ComparisonFilter.Operator.EQ;
                break;
            }
            case 69: {
                this.jj_consume_token(69);
                operator = ComparisonFilter.Operator.NE;
                break;
            }
            case 70: {
                this.jj_consume_token(70);
                operator = ComparisonFilter.Operator.LT;
                break;
            }
            case 71: {
                this.jj_consume_token(71);
                operator = ComparisonFilter.Operator.LE;
                break;
            }
            case 72: {
                this.jj_consume_token(72);
                operator = ComparisonFilter.Operator.GT;
                break;
            }
            case 73: {
                this.jj_consume_token(73);
                operator = ComparisonFilter.Operator.GE;
                break;
            }
            case 45: {
                this.jj_consume_token(45);
                operator = ComparisonFilter.Operator.CONTAINS;
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                this.jj_consume_token(44);
                operator = ComparisonFilter.Operator.STARTS_WITH;
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                this.jj_consume_token(44);
                operator = ComparisonFilter.Operator.ENDS_WITH;
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                operator = ComparisonFilter.Operator.MATCHES;
                break;
            }
            case 49: {
                this.jj_consume_token(49);
                operator = ComparisonFilter.Operator.LIKE;
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return operator;
    }

    public final Value literal() throws ParseException, InvalidQueryException {
        Value value;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: {
                String string = this.stringLiteral();
                value = new TextValue(string);
                break;
            }
            case 58: 
            case 59: 
            case 76: {
                double d = this.decimalLiteral();
                value = new NumberValue(d);
                break;
            }
            case 19: 
            case 20: {
                boolean bl = this.booleanLiteral();
                value = BooleanValue.getInstance(bl);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                String string = this.stringLiteral();
                value = ParserUtils.stringToDate(string);
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                String string = this.stringLiteral();
                value = ParserUtils.stringToTimeOfDay(string);
                break;
            }
            case 26: 
            case 27: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 26: {
                        this.jj_consume_token(26);
                        break;
                    }
                    case 27: {
                        this.jj_consume_token(27);
                        break;
                    }
                    default: {
                        this.jj_la1[28] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                String string = this.stringLiteral();
                value = ParserUtils.stringToDatetime(string);
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final QueryOptionEnum queryOption() throws ParseException {
        QueryOptionEnum queryOptionEnum = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: {
                this.jj_consume_token(33);
                queryOptionEnum = QueryOptionEnum.NO_VALUES;
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                queryOptionEnum = QueryOptionEnum.NO_FORMAT;
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return queryOptionEnum;
    }

    public final AbstractColumn abstractColumnDescriptor() throws ParseException, InvalidQueryException {
        AbstractColumn abstractColumn = null;
        if (this.jj_2_4(2)) {
            AbstractColumn abstractColumn2;
            abstractColumn = abstractColumn2 = this.arithmeticExpression();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: 
                case 20: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 63: 
                case 64: 
                case 66: 
                case 76: {
                    AbstractColumn abstractColumn3;
                    abstractColumn = abstractColumn3 = this.atomicAbstractColumnDescriptor();
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return abstractColumn;
    }

    public final AbstractColumn atomicAbstractColumnDescriptor() throws ParseException, InvalidQueryException {
        ArrayList<AbstractColumn> arrayList = new ArrayList<AbstractColumn>();
        AbstractColumn abstractColumn = null;
        if (this.jj_2_5(2)) {
            AggregationType aggregationType = this.aggregationFunction();
            this.jj_consume_token(66);
            String string = this.columnId();
            this.jj_consume_token(67);
            abstractColumn = new AggregationColumn(new SimpleColumn(string), aggregationType);
        } else if (this.jj_2_6(2)) {
            AbstractColumn abstractColumn2;
            ScalarFunction scalarFunction = this.scalarFunction();
            this.jj_consume_token(66);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: 
                case 20: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 63: 
                case 64: 
                case 66: 
                case 76: {
                    abstractColumn2 = this.abstractColumnDescriptor();
                    arrayList.add(abstractColumn2);
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                }
            }
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 65: {
                        break;
                    }
                    default: {
                        this.jj_la1[33] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(65);
                abstractColumn2 = this.abstractColumnDescriptor();
                arrayList.add(abstractColumn2);
            }
            this.jj_consume_token(67);
            abstractColumn = new ScalarFunctionColumn(GenericsHelper.makeTypedList(arrayList), scalarFunction);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 66: {
                    this.jj_consume_token(66);
                    AbstractColumn abstractColumn3 = this.abstractColumnDescriptor();
                    this.jj_consume_token(67);
                    abstractColumn = abstractColumn3;
                    break;
                }
                case 19: 
                case 20: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 58: 
                case 59: 
                case 63: 
                case 76: {
                    Value value = this.literal();
                    abstractColumn = new ScalarFunctionColumn(new ArrayList<AbstractColumn>(), new Constant(value));
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 64: {
                    String string = this.columnId();
                    abstractColumn = new SimpleColumn(string);
                    break;
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return abstractColumn;
    }

    public final AbstractColumn arithmeticExpression() throws ParseException, InvalidQueryException {
        AbstractColumn abstractColumn = this.possibleSecondOrderArithmeticExpression();
        return abstractColumn;
    }

    public final AbstractColumn possibleSecondOrderArithmeticExpression() throws ParseException, InvalidQueryException {
        AbstractColumn abstractColumn;
        block8: {
            abstractColumn = this.possibleFirstOrderArithmeticExpression();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 75: 
                    case 76: {
                        break;
                    }
                    default: {
                        this.jj_la1[35] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 75: {
                        this.jj_consume_token(75);
                        AbstractColumn abstractColumn2 = this.possibleFirstOrderArithmeticExpression();
                        abstractColumn = new ScalarFunctionColumn(GenericsHelper.makeAbstractColumnList(new AbstractColumn[]{abstractColumn, abstractColumn2}), Sum.getInstance());
                        continue block7;
                    }
                    case 76: {
                        this.jj_consume_token(76);
                        AbstractColumn abstractColumn2 = this.possibleFirstOrderArithmeticExpression();
                        abstractColumn = new ScalarFunctionColumn(GenericsHelper.makeAbstractColumnList(new AbstractColumn[]{abstractColumn, abstractColumn2}), Difference.getInstance());
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[36] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return abstractColumn;
    }

    public final AbstractColumn possibleFirstOrderArithmeticExpression() throws ParseException, InvalidQueryException {
        AbstractColumn abstractColumn;
        block9: {
            abstractColumn = this.atomicAbstractColumnDescriptor();
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 74: 
                    case 77: 
                    case 78: {
                        break;
                    }
                    default: {
                        this.jj_la1[37] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 74: {
                        this.jj_consume_token(74);
                        AbstractColumn abstractColumn2 = this.atomicAbstractColumnDescriptor();
                        abstractColumn = new ScalarFunctionColumn(GenericsHelper.makeAbstractColumnList(new AbstractColumn[]{abstractColumn, abstractColumn2}), Product.getInstance());
                        continue block8;
                    }
                    case 77: {
                        this.jj_consume_token(77);
                        AbstractColumn abstractColumn2 = this.atomicAbstractColumnDescriptor();
                        abstractColumn = new ScalarFunctionColumn(GenericsHelper.makeAbstractColumnList(new AbstractColumn[]{abstractColumn, abstractColumn2}), Quotient.getInstance());
                        continue block8;
                    }
                    case 78: {
                        this.jj_consume_token(78);
                        AbstractColumn abstractColumn2 = this.atomicAbstractColumnDescriptor();
                        abstractColumn = new ScalarFunctionColumn(GenericsHelper.makeAbstractColumnList(new AbstractColumn[]{abstractColumn, abstractColumn2}), Modulo.getInstance());
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[38] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return abstractColumn;
    }

    public final AggregationType aggregationFunction() throws ParseException {
        AggregationType aggregationType = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                aggregationType = AggregationType.MIN;
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                aggregationType = AggregationType.MAX;
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                aggregationType = AggregationType.COUNT;
                break;
            }
            case 30: {
                this.jj_consume_token(30);
                aggregationType = AggregationType.AVG;
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                aggregationType = AggregationType.SUM;
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return aggregationType;
    }

    public final ScalarFunction scalarFunction() throws ParseException {
        ScalarFunction scalarFunction = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                scalarFunction = TimeComponentExtractor.getInstance(TimeComponentExtractor.TimeComponent.YEAR);
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                scalarFunction = TimeComponentExtractor.getInstance(TimeComponentExtractor.TimeComponent.MONTH);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                scalarFunction = TimeComponentExtractor.getInstance(TimeComponentExtractor.TimeComponent.DAY);
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                scalarFunction = TimeComponentExtractor.getInstance(TimeComponentExtractor.TimeComponent.HOUR);
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                scalarFunction = TimeComponentExtractor.getInstance(TimeComponentExtractor.TimeComponent.MINUTE);
                break;
            }
            case 42: {
                this.jj_consume_token(42);
                scalarFunction = TimeComponentExtractor.getInstance(TimeComponentExtractor.TimeComponent.SECOND);
                break;
            }
            case 43: {
                this.jj_consume_token(43);
                scalarFunction = TimeComponentExtractor.getInstance(TimeComponentExtractor.TimeComponent.MILLISECOND);
                break;
            }
            case 50: {
                this.jj_consume_token(50);
                scalarFunction = CurrentDateTime.getInstance();
                break;
            }
            case 51: {
                this.jj_consume_token(51);
                scalarFunction = DateDiff.getInstance();
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                scalarFunction = Lower.getInstance();
                break;
            }
            case 54: {
                this.jj_consume_token(54);
                scalarFunction = Upper.getInstance();
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                scalarFunction = TimeComponentExtractor.getInstance(TimeComponentExtractor.TimeComponent.QUARTER);
                break;
            }
            case 55: {
                this.jj_consume_token(55);
                scalarFunction = TimeComponentExtractor.getInstance(TimeComponentExtractor.TimeComponent.DAY_OF_WEEK);
                break;
            }
            case 56: {
                this.jj_consume_token(56);
                scalarFunction = ToDate.getInstance();
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return scalarFunction;
    }

    public final String columnId() throws ParseException {
        String string = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                Token token = this.jj_consume_token(57);
                string = token.image;
                break;
            }
            case 64: {
                Token token = this.jj_consume_token(64);
                string = ParserUtils.stripQuotes(token.image);
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                string = this.nonReservedKeyword();
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return string;
    }

    public final String nonReservedKeyword() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                token = this.jj_consume_token(28);
                break;
            }
            case 29: {
                token = this.jj_consume_token(29);
                break;
            }
            case 30: {
                token = this.jj_consume_token(30);
                break;
            }
            case 31: {
                token = this.jj_consume_token(31);
                break;
            }
            case 32: {
                token = this.jj_consume_token(32);
                break;
            }
            case 33: {
                token = this.jj_consume_token(33);
                break;
            }
            case 34: {
                token = this.jj_consume_token(34);
                break;
            }
            case 35: {
                token = this.jj_consume_token(35);
                break;
            }
            case 36: {
                token = this.jj_consume_token(36);
                break;
            }
            case 37: {
                token = this.jj_consume_token(37);
                break;
            }
            case 38: {
                token = this.jj_consume_token(38);
                break;
            }
            case 39: {
                token = this.jj_consume_token(39);
                break;
            }
            case 40: {
                token = this.jj_consume_token(40);
                break;
            }
            case 41: {
                token = this.jj_consume_token(41);
                break;
            }
            case 42: {
                token = this.jj_consume_token(42);
                break;
            }
            case 43: {
                token = this.jj_consume_token(43);
                break;
            }
            case 44: {
                token = this.jj_consume_token(44);
                break;
            }
            case 45: {
                token = this.jj_consume_token(45);
                break;
            }
            case 46: {
                token = this.jj_consume_token(46);
                break;
            }
            case 47: {
                token = this.jj_consume_token(47);
                break;
            }
            case 48: {
                token = this.jj_consume_token(48);
                break;
            }
            case 49: {
                token = this.jj_consume_token(49);
                break;
            }
            case 50: {
                token = this.jj_consume_token(50);
                break;
            }
            case 51: {
                token = this.jj_consume_token(51);
                break;
            }
            case 52: {
                token = this.jj_consume_token(52);
                break;
            }
            case 53: {
                token = this.jj_consume_token(53);
                break;
            }
            case 54: {
                token = this.jj_consume_token(54);
                break;
            }
            case 55: {
                token = this.jj_consume_token(55);
                break;
            }
            case 56: {
                token = this.jj_consume_token(56);
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token.image;
    }

    public final SortOrder sortOrder() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                return SortOrder.ASCENDING;
            }
            case 18: {
                this.jj_consume_token(18);
                return SortOrder.DESCENDING;
            }
        }
        this.jj_la1[43] = this.jj_gen;
        return SortOrder.ASCENDING;
    }

    public final int integerLiteral() throws ParseException {
        String string;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 58: {
                Token token = this.jj_consume_token(58);
                string = token.image;
                break;
            }
            case 76: {
                Token token = this.jj_consume_token(76);
                Token token2 = this.jj_consume_token(58);
                string = token.image + token2.image;
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return Integer.parseInt(string);
    }

    public final String stringLiteral() throws ParseException {
        Token token = this.jj_consume_token(63);
        return ParserUtils.stripQuotes(token.image);
    }

    public final double decimalLiteral() throws ParseException {
        String string;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: {
                Token token = this.jj_consume_token(59);
                string = token.image;
                break;
            }
            case 58: {
                Token token = this.jj_consume_token(58);
                string = token.image;
                break;
            }
            case 76: {
                Token token;
                Token token2 = this.jj_consume_token(76);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 59: {
                        token = this.jj_consume_token(59);
                        break;
                    }
                    case 58: {
                        token = this.jj_consume_token(58);
                        break;
                    }
                    default: {
                        this.jj_la1[45] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                string = token2.image + token.image;
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return Double.parseDouble(string);
    }

    public final boolean booleanLiteral() throws ParseException {
        boolean bl;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                this.jj_consume_token(19);
                bl = true;
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                bl = false;
                break;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, n);
        }
    }

    private boolean jj_3R_66() {
        return this.jj_3R_76();
    }

    private boolean jj_3_4() {
        return this.jj_3R_15();
    }

    private boolean jj_3R_47() {
        Token token = this.jj_scanpos;
        if (this.jj_3_4()) {
            this.jj_scanpos = token;
            if (this.jj_3R_66()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_25() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(26)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(27)) {
                return true;
            }
        }
        return this.jj_3R_50();
    }

    private boolean jj_3R_92() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(28)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(29)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(30)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(31)) {
                        this.jj_scanpos = token;
                        if (this.jj_scan_token(32)) {
                            this.jj_scanpos = token;
                            if (this.jj_scan_token(33)) {
                                this.jj_scanpos = token;
                                if (this.jj_scan_token(34)) {
                                    this.jj_scanpos = token;
                                    if (this.jj_scan_token(35)) {
                                        this.jj_scanpos = token;
                                        if (this.jj_scan_token(36)) {
                                            this.jj_scanpos = token;
                                            if (this.jj_scan_token(37)) {
                                                this.jj_scanpos = token;
                                                if (this.jj_scan_token(38)) {
                                                    this.jj_scanpos = token;
                                                    if (this.jj_scan_token(39)) {
                                                        this.jj_scanpos = token;
                                                        if (this.jj_scan_token(40)) {
                                                            this.jj_scanpos = token;
                                                            if (this.jj_scan_token(41)) {
                                                                this.jj_scanpos = token;
                                                                if (this.jj_scan_token(42)) {
                                                                    this.jj_scanpos = token;
                                                                    if (this.jj_scan_token(43)) {
                                                                        this.jj_scanpos = token;
                                                                        if (this.jj_scan_token(44)) {
                                                                            this.jj_scanpos = token;
                                                                            if (this.jj_scan_token(45)) {
                                                                                this.jj_scanpos = token;
                                                                                if (this.jj_scan_token(46)) {
                                                                                    this.jj_scanpos = token;
                                                                                    if (this.jj_scan_token(47)) {
                                                                                        this.jj_scanpos = token;
                                                                                        if (this.jj_scan_token(48)) {
                                                                                            this.jj_scanpos = token;
                                                                                            if (this.jj_scan_token(49)) {
                                                                                                this.jj_scanpos = token;
                                                                                                if (this.jj_scan_token(50)) {
                                                                                                    this.jj_scanpos = token;
                                                                                                    if (this.jj_scan_token(51)) {
                                                                                                        this.jj_scanpos = token;
                                                                                                        if (this.jj_scan_token(52)) {
                                                                                                            this.jj_scanpos = token;
                                                                                                            if (this.jj_scan_token(53)) {
                                                                                                                this.jj_scanpos = token;
                                                                                                                if (this.jj_scan_token(54)) {
                                                                                                                    this.jj_scanpos = token;
                                                                                                                    if (this.jj_scan_token(55)) {
                                                                                                                        this.jj_scanpos = token;
                                                                                                                        if (this.jj_scan_token(56)) {
                                                                                                                            return true;
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_24() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_3R_50();
    }

    private boolean jj_3R_23() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_3R_50();
    }

    private boolean jj_3R_22() {
        return this.jj_3R_52();
    }

    private boolean jj_3R_21() {
        return this.jj_3R_51();
    }

    private boolean jj_3R_20() {
        return this.jj_3R_50();
    }

    private boolean jj_3R_14() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_20()) {
            this.jj_scanpos = token;
            if (this.jj_3R_21()) {
                this.jj_scanpos = token;
                if (this.jj_3R_22()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_23()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_24()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_25()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_91() {
        return this.jj_3R_92();
    }

    private boolean jj_3R_90() {
        return this.jj_scan_token(64);
    }

    private boolean jj_3R_89() {
        return this.jj_scan_token(57);
    }

    private boolean jj_3R_86() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_89()) {
            this.jj_scanpos = token;
            if (this.jj_3R_90()) {
                this.jj_scanpos = token;
                if (this.jj_3R_91()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_65() {
        return this.jj_scan_token(49);
    }

    private boolean jj_3R_64() {
        return this.jj_scan_token(48);
    }

    private boolean jj_3R_63() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        return this.jj_scan_token(44);
    }

    private boolean jj_3R_45() {
        return this.jj_scan_token(56);
    }

    private boolean jj_3R_62() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        return this.jj_scan_token(44);
    }

    private boolean jj_3R_61() {
        return this.jj_scan_token(45);
    }

    private boolean jj_3R_44() {
        return this.jj_scan_token(55);
    }

    private boolean jj_3R_60() {
        return this.jj_scan_token(73);
    }

    private boolean jj_3R_59() {
        return this.jj_scan_token(72);
    }

    private boolean jj_3R_43() {
        return this.jj_scan_token(52);
    }

    private boolean jj_3R_58() {
        return this.jj_scan_token(71);
    }

    private boolean jj_3R_42() {
        return this.jj_scan_token(54);
    }

    private boolean jj_3R_57() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3R_41() {
        return this.jj_scan_token(53);
    }

    private boolean jj_3R_56() {
        return this.jj_scan_token(69);
    }

    private boolean jj_3R_40() {
        return this.jj_scan_token(51);
    }

    private boolean jj_3R_55() {
        return this.jj_scan_token(68);
    }

    private boolean jj_3R_39() {
        return this.jj_scan_token(50);
    }

    private boolean jj_3_2() {
        return this.jj_3R_14();
    }

    private boolean jj_3R_46() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_55()) {
            this.jj_scanpos = token;
            if (this.jj_3R_56()) {
                this.jj_scanpos = token;
                if (this.jj_3R_57()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_58()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_59()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_60()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_61()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_62()) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3R_63()) {
                                            this.jj_scanpos = token;
                                            if (this.jj_3R_64()) {
                                                this.jj_scanpos = token;
                                                if (this.jj_3R_65()) {
                                                    return true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_38() {
        return this.jj_scan_token(43);
    }

    private boolean jj_3R_37() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_36() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_35() {
        return this.jj_scan_token(40);
    }

    private boolean jj_3R_70() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_34() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_69() {
        return this.jj_3R_14();
    }

    private boolean jj_3R_33() {
        return this.jj_scan_token(38);
    }

    private boolean jj_3R_32() {
        return this.jj_scan_token(37);
    }

    private boolean jj_3R_49() {
        if (this.jj_3R_46()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_69()) {
            this.jj_scanpos = token;
            if (this.jj_3R_70()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_17() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_32()) {
            this.jj_scanpos = token;
            if (this.jj_3R_33()) {
                this.jj_scanpos = token;
                if (this.jj_3R_34()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_35()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_36()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_37()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_38()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_39()) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3R_40()) {
                                            this.jj_scanpos = token;
                                            if (this.jj_3R_41()) {
                                                this.jj_scanpos = token;
                                                if (this.jj_3R_42()) {
                                                    this.jj_scanpos = token;
                                                    if (this.jj_3R_43()) {
                                                        this.jj_scanpos = token;
                                                        if (this.jj_3R_44()) {
                                                            this.jj_scanpos = token;
                                                            if (this.jj_3R_45()) {
                                                                return true;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_68() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_scan_token(36);
    }

    private boolean jj_3R_67() {
        return this.jj_scan_token(36);
    }

    private boolean jj_3_3() {
        return this.jj_3R_14();
    }

    private boolean jj_3R_48() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_67()) {
            this.jj_scanpos = token;
            if (this.jj_3R_68()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_31() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_30() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_29() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_28() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_27() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3R_19() {
        if (this.jj_3R_47()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_48()) {
            this.jj_scanpos = token;
            if (this.jj_3R_49()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_16() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_27()) {
            this.jj_scanpos = token;
            if (this.jj_3R_28()) {
                this.jj_scanpos = token;
                if (this.jj_3R_29()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_30()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_31()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_18() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_3R_46()) {
            return true;
        }
        return this.jj_3R_47();
    }

    private boolean jj_3R_13() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_18()) {
            this.jj_scanpos = token;
            if (this.jj_3R_19()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_1() {
        return this.jj_3R_13();
    }

    private boolean jj_3R_85() {
        if (this.jj_scan_token(78)) {
            return true;
        }
        return this.jj_3R_76();
    }

    private boolean jj_3R_84() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        return this.jj_3R_76();
    }

    private boolean jj_3R_83() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        return this.jj_3R_76();
    }

    private boolean jj_3R_77() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_83()) {
            this.jj_scanpos = token;
            if (this.jj_3R_84()) {
                this.jj_scanpos = token;
                if (this.jj_3R_85()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_53() {
        Token token;
        if (this.jj_3R_76()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_77());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3R_79() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        return this.jj_3R_53();
    }

    private boolean jj_3R_75() {
        return this.jj_scan_token(20);
    }

    private boolean jj_3R_78() {
        if (this.jj_scan_token(75)) {
            return true;
        }
        return this.jj_3R_53();
    }

    private boolean jj_3R_74() {
        return this.jj_scan_token(19);
    }

    private boolean jj_3R_54() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_78()) {
            this.jj_scanpos = token;
            if (this.jj_3R_79()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_52() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_74()) {
            this.jj_scanpos = token;
            if (this.jj_3R_75()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_26() {
        Token token;
        if (this.jj_3R_53()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_54());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3R_73() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(59)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(58)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_72() {
        return this.jj_scan_token(58);
    }

    private boolean jj_3R_71() {
        return this.jj_scan_token(59);
    }

    private boolean jj_3R_51() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_71()) {
            this.jj_scanpos = token;
            if (this.jj_3R_72()) {
                this.jj_scanpos = token;
                if (this.jj_3R_73()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_15() {
        return this.jj_3R_26();
    }

    private boolean jj_3R_82() {
        return this.jj_3R_86();
    }

    private boolean jj_3R_50() {
        return this.jj_scan_token(63);
    }

    private boolean jj_3R_81() {
        return this.jj_3R_14();
    }

    private boolean jj_3R_80() {
        if (this.jj_scan_token(66)) {
            return true;
        }
        if (this.jj_3R_47()) {
            return true;
        }
        return this.jj_scan_token(67);
    }

    private boolean jj_3R_88() {
        if (this.jj_scan_token(65)) {
            return true;
        }
        return this.jj_3R_47();
    }

    private boolean jj_3R_87() {
        return this.jj_3R_47();
    }

    private boolean jj_3_6() {
        if (this.jj_3R_17()) {
            return true;
        }
        if (this.jj_scan_token(66)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_87()) {
            this.jj_scanpos = token;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_88());
        this.jj_scanpos = token;
        return this.jj_scan_token(67);
    }

    private boolean jj_3_5() {
        if (this.jj_3R_16()) {
            return true;
        }
        if (this.jj_scan_token(66)) {
            return true;
        }
        if (this.jj_3R_86()) {
            return true;
        }
        return this.jj_scan_token(67);
    }

    private boolean jj_3R_76() {
        Token token = this.jj_scanpos;
        if (this.jj_3_5()) {
            this.jj_scanpos = token;
            if (this.jj_3_6()) {
                this.jj_scanpos = token;
                if (this.jj_3R_80()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_81()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_82()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{32, 64, 128, 256, 512, 2048, 4096, 8192, 16384, 32768, 65536, 0, -15204352, 0, 0, 0, 0, 0, 0, 0x400000, 0x200000, -6815744, 0, 0x800000, -15204352, 0, -15204352, 0, 0xC000000, 253231104, 0, -15204352, -15204352, 0, -15204352, 0, 0, 0, 0, -268435456, 0, -268435456, -268435456, 393216, 0, 0, 0, 0x180000};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1879048193, 0, 0, 0, 0, 0, 6, 0, 0, -1879048193, 0, 16, -1879048193, 253960, -1879048193, 253952, 0, -1946157056, 6, -1879048193, -1879048193, 0, -1879048193, 0, 0, 0, 0, 1, 33296352, 0x3FFFFFF, 0x1FFFFFF, 0, 0x4000000, 0xC000000, 0xC000000, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 5125, 2, 2, 2, 2, 2, 0, 0, 0, 4101, 4, 0, 4101, 1008, 4101, 1008, 0, 4096, 0, 4101, 4101, 2, 4101, 6144, 6144, 25600, 25600, 0, 0, 1, 0, 0, 4096, 0, 4096, 0};
    }

    public QueryParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public QueryParser(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream = new JavaCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source = new QueryParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 48; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 48; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public QueryParser(Reader reader) {
        int n;
        this.jj_input_stream = new JavaCharStream(reader, 1, 1);
        this.token_source = new QueryParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 48; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 48; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public QueryParser(QueryParserTokenManager queryParserTokenManager) {
        int n;
        this.token_source = queryParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 48; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(QueryParserTokenManager queryParserTokenManager) {
        int n;
        this.token_source = queryParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 48; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] nArray : this.jj_expentries) {
                if (nArray.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.clear();
        boolean[] blArray = new boolean[80];
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 48; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) != 0) {
                    blArray[32 + n] = true;
                }
                if ((jj_la1_2[n2] & 1 << n) == 0) continue;
                blArray[64 + n] = true;
            }
        }
        for (n2 = 0; n2 < 80; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.get(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 6; ++i) {
            try {
                JJCalls jJCalls = this.jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= this.jj_gen) continue;
                    this.jj_la = jJCalls.arg;
                    this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        QueryParser.jj_la1_init_0();
        QueryParser.jj_la1_init_1();
        QueryParser.jj_la1_init_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

