/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.engine;

import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import java.util.List;
import org.apache.commons.lang.text.StrBuilder;

class ScalarFunctionColumnTitle {
    private List<Value> values;
    public ScalarFunctionColumn scalarFunctionColumn;
    public static final String PIVOT_COLUMNS_SEPARATOR = ",";
    public static final String PIVOT_SCALAR_FUNCTION_SEPARATOR = " ";

    public ScalarFunctionColumnTitle(List<Value> list, ScalarFunctionColumn scalarFunctionColumn) {
        this.values = list;
        this.scalarFunctionColumn = scalarFunctionColumn;
    }

    public List<Value> getValues() {
        return this.values;
    }

    public ColumnDescription createColumnDescription(DataTable dataTable) {
        String string = this.createIdPivotPrefix() + this.scalarFunctionColumn.getId();
        ValueType valueType = this.scalarFunctionColumn.getValueType(dataTable);
        String string2 = this.createLabelPivotPart() + PIVOT_SCALAR_FUNCTION_SEPARATOR + ScalarFunctionColumnTitle.getColumnDescriptionLabel(dataTable, this.scalarFunctionColumn);
        ColumnDescription columnDescription = new ColumnDescription(string, valueType, string2);
        return columnDescription;
    }

    private String createIdPivotPrefix() {
        if (!this.isPivot()) {
            return "";
        }
        return new StrBuilder().appendWithSeparators(this.values, PIVOT_COLUMNS_SEPARATOR).append(PIVOT_SCALAR_FUNCTION_SEPARATOR).toString();
    }

    private String createLabelPivotPart() {
        if (!this.isPivot()) {
            return "";
        }
        return new StrBuilder().appendWithSeparators(this.values, PIVOT_COLUMNS_SEPARATOR).toString();
    }

    private boolean isPivot() {
        return !this.values.isEmpty();
    }

    public static String getColumnDescriptionLabel(DataTable dataTable, AbstractColumn abstractColumn) {
        StringBuilder stringBuilder = new StringBuilder();
        if (dataTable.containsColumn(abstractColumn.getId())) {
            stringBuilder.append(dataTable.getColumnDescription(abstractColumn.getId()).getLabel());
        } else if (abstractColumn instanceof AggregationColumn) {
            AggregationColumn aggregationColumn = (AggregationColumn)abstractColumn;
            stringBuilder.append(aggregationColumn.getAggregationType().getCode()).append(PIVOT_SCALAR_FUNCTION_SEPARATOR).append(dataTable.getColumnDescription(aggregationColumn.getAggregatedColumn().getId()).getLabel());
        } else {
            ScalarFunctionColumn scalarFunctionColumn = (ScalarFunctionColumn)abstractColumn;
            List<AbstractColumn> list = scalarFunctionColumn.getColumns();
            stringBuilder.append(scalarFunctionColumn.getFunction().getFunctionName()).append("(");
            for (AbstractColumn abstractColumn2 : list) {
                stringBuilder.append(ScalarFunctionColumnTitle.getColumnDescriptionLabel(dataTable, abstractColumn2));
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof ScalarFunctionColumnTitle) {
            ScalarFunctionColumnTitle scalarFunctionColumnTitle = (ScalarFunctionColumnTitle)object;
            return ((Object)this.values).equals(scalarFunctionColumnTitle.values) && this.scalarFunctionColumn.equals(scalarFunctionColumnTitle.scalarFunctionColumn);
        }
        return false;
    }

    public int hashCode() {
        int n = 31;
        if (this.scalarFunctionColumn != null) {
            n += this.scalarFunctionColumn.hashCode();
        }
        n *= 31;
        if (this.values != null) {
            n += ((Object)this.values).hashCode();
        }
        return n;
    }
}

