/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.ColumnSort;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import com.google.visualization.datasource.query.SortOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.text.StrBuilder;

public class QuerySort {
    private List<ColumnSort> sortColumns = Lists.newArrayList();

    public boolean isEmpty() {
        return this.sortColumns.isEmpty();
    }

    public void addSort(ColumnSort columnSort) {
        this.sortColumns.add(columnSort);
    }

    public void addSort(AbstractColumn abstractColumn, SortOrder sortOrder) {
        this.addSort(new ColumnSort(abstractColumn, sortOrder));
    }

    public List<ColumnSort> getSortColumns() {
        return ImmutableList.copyOf(this.sortColumns);
    }

    public List<AbstractColumn> getColumns() {
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)this.sortColumns.size());
        for (ColumnSort columnSort : this.sortColumns) {
            arrayList.add(columnSort.getColumn());
        }
        return arrayList;
    }

    public List<AggregationColumn> getAggregationColumns() {
        ArrayList arrayList = Lists.newArrayList();
        for (ColumnSort columnSort : this.sortColumns) {
            AbstractColumn abstractColumn = columnSort.getColumn();
            for (AggregationColumn aggregationColumn : abstractColumn.getAllAggregationColumns()) {
                if (arrayList.contains(aggregationColumn)) continue;
                arrayList.add(aggregationColumn);
            }
        }
        return arrayList;
    }

    public List<ScalarFunctionColumn> getScalarFunctionColumns() {
        ArrayList arrayList = Lists.newArrayList();
        for (ColumnSort columnSort : this.sortColumns) {
            AbstractColumn abstractColumn = columnSort.getColumn();
            for (ScalarFunctionColumn scalarFunctionColumn : abstractColumn.getAllScalarFunctionColumns()) {
                if (arrayList.contains(scalarFunctionColumn)) continue;
                arrayList.add(scalarFunctionColumn);
            }
        }
        return arrayList;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.sortColumns == null ? 0 : ((Object)this.sortColumns).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        QuerySort querySort = (QuerySort)object;
        return !(this.sortColumns == null ? querySort.sortColumns != null : !((Object)this.sortColumns).equals(querySort.sortColumns));
    }

    public String toQueryString() {
        StrBuilder strBuilder = new StrBuilder();
        ArrayList arrayList = Lists.newArrayList();
        for (ColumnSort columnSort : this.sortColumns) {
            arrayList.add(columnSort.toQueryString());
        }
        strBuilder.appendWithSeparators((Collection)arrayList, ", ");
        return strBuilder.toString();
    }
}

