/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.Sets;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.DataTableColumnLookup;
import com.google.visualization.datasource.query.QueryFilter;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import java.util.List;
import java.util.Set;

public class ColumnIsNullFilter
extends QueryFilter {
    private AbstractColumn column;

    public ColumnIsNullFilter(AbstractColumn abstractColumn) {
        this.column = abstractColumn;
    }

    public AbstractColumn getColumn() {
        return this.column;
    }

    @Override
    public Set<String> getAllColumnIds() {
        return Sets.newHashSet(this.column.getAllSimpleColumnIds());
    }

    @Override
    public List<ScalarFunctionColumn> getScalarFunctionColumns() {
        return this.column.getAllScalarFunctionColumns();
    }

    @Override
    protected List<AggregationColumn> getAggregationColumns() {
        return this.column.getAllAggregationColumns();
    }

    @Override
    public boolean isMatch(DataTable dataTable, TableRow tableRow) {
        DataTableColumnLookup dataTableColumnLookup = new DataTableColumnLookup(dataTable);
        return this.column.getValue(dataTableColumnLookup, tableRow).isNull();
    }

    @Override
    public String toQueryString() {
        return this.column.toQueryString() + " IS NULL";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.column == null ? 0 : this.column.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ColumnIsNullFilter columnIsNullFilter = (ColumnIsNullFilter)object;
        return !(this.column == null ? columnIsNullFilter.column != null : !this.column.equals(columnIsNullFilter.column));
    }
}

