/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.Lists;
import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.base.MessagesEnum;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationType;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import com.google.visualization.datasource.query.SimpleColumn;
import com.ibm.icu.util.ULocale;
import java.util.List;

public class AggregationColumn
extends AbstractColumn {
    public static final String COLUMN_AGGRGATION_TYPE_SEPARATOR = "-";
    private SimpleColumn aggregatedColumn;
    private AggregationType aggregationType;

    public AggregationColumn(SimpleColumn simpleColumn, AggregationType aggregationType) {
        this.aggregatedColumn = simpleColumn;
        this.aggregationType = aggregationType;
    }

    @Override
    public String getId() {
        return this.aggregationType.getCode() + COLUMN_AGGRGATION_TYPE_SEPARATOR + this.aggregatedColumn.getId();
    }

    public SimpleColumn getAggregatedColumn() {
        return this.aggregatedColumn;
    }

    @Override
    public List<String> getAllSimpleColumnIds() {
        return Lists.newArrayList((Object[])new String[]{this.aggregatedColumn.getId()});
    }

    @Override
    public List<SimpleColumn> getAllSimpleColumns() {
        return Lists.newArrayList();
    }

    @Override
    public List<AggregationColumn> getAllAggregationColumns() {
        return Lists.newArrayList((Object[])new AggregationColumn[]{this});
    }

    @Override
    public List<ScalarFunctionColumn> getAllScalarFunctionColumns() {
        return Lists.newArrayList();
    }

    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    @Override
    public void validateColumn(DataTable dataTable) throws InvalidQueryException {
        ValueType valueType = dataTable.getColumnDescription(this.aggregatedColumn.getId()).getType();
        ULocale uLocale = dataTable.getLocaleForUserMessages();
        switch (this.aggregationType) {
            case COUNT: 
            case MAX: 
            case MIN: {
                break;
            }
            case AVG: 
            case SUM: {
                if (valueType == ValueType.NUMBER) break;
                throw new InvalidQueryException(MessagesEnum.AVG_SUM_ONLY_NUMERIC.getMessage(uLocale));
            }
            default: {
                throw new RuntimeException(MessagesEnum.INVALID_AGG_TYPE.getMessageWithArgs(uLocale, this.aggregationType.toString()));
            }
        }
    }

    @Override
    public ValueType getValueType(DataTable dataTable) {
        ValueType valueType;
        ValueType valueType2 = dataTable.getColumnDescription(this.aggregatedColumn.getId()).getType();
        switch (this.aggregationType) {
            case COUNT: {
                valueType = ValueType.NUMBER;
                break;
            }
            case MAX: 
            case MIN: 
            case AVG: 
            case SUM: {
                valueType = valueType2;
                break;
            }
            default: {
                throw new RuntimeException(MessagesEnum.INVALID_AGG_TYPE.getMessageWithArgs(dataTable.getLocaleForUserMessages(), this.aggregationType.toString()));
            }
        }
        return valueType;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof AggregationColumn) {
            AggregationColumn aggregationColumn = (AggregationColumn)object;
            return this.aggregatedColumn.equals(aggregationColumn.aggregatedColumn) && this.aggregationType.equals((Object)aggregationColumn.aggregationType);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 1279;
        n = n * 17 + this.aggregatedColumn.hashCode();
        n = n * 17 + this.aggregationType.hashCode();
        return n;
    }

    public String toString() {
        return this.aggregationType.getCode() + "(" + this.aggregatedColumn.getId() + ")";
    }

    @Override
    public String toQueryString() {
        return this.aggregationType.getCode().toUpperCase() + "(" + this.aggregatedColumn.toQueryString() + ")";
    }
}

