/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable.value;

import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.util.Comparator;

public class TextValue
extends Value {
    private static final TextValue NULL_VALUE = new TextValue("");
    private String value;

    public TextValue(String string) {
        if (string == null) {
            throw new NullPointerException("Cannot create a text value from null.");
        }
        this.value = string;
    }

    @Override
    public ValueType getType() {
        return ValueType.TEXT;
    }

    public String toString() {
        return this.value;
    }

    public static TextValue getNullValue() {
        return NULL_VALUE;
    }

    @Override
    public boolean isNull() {
        return this == NULL_VALUE;
    }

    @Override
    public int compareTo(Value value) {
        if (this == value) {
            return 0;
        }
        return this.value.compareTo(((TextValue)value).value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String getObjectToFormat() {
        return this.value;
    }

    public static Comparator<TextValue> getTextLocalizedComparator(final ULocale uLocale) {
        return new Comparator<TextValue>(){
            Collator collator;
            {
                this.collator = Collator.getInstance((ULocale)uLocale);
            }

            @Override
            public int compare(TextValue textValue, TextValue textValue2) {
                if (textValue == textValue2) {
                    return 0;
                }
                return this.collator.compare(textValue.value, textValue2.value);
            }
        };
    }

    public String getValue() {
        return this.value;
    }

    @Override
    protected String innerToQueryString() {
        if (this.value.contains("\"")) {
            if (this.value.contains("'")) {
                throw new RuntimeException("Cannot run toQueryString() on string values that contain both \" and '.");
            }
            return "'" + this.value + "'";
        }
        return "\"" + this.value + "\"";
    }
}

