/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable.value;

import com.google.visualization.datasource.datatable.value.NullValueException;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;

public class DateTimeValue
extends Value {
    private static final DateTimeValue NULL_VALUE = new DateTimeValue();
    private GregorianCalendar calendar;
    private Integer hashCode = null;

    public static DateTimeValue getNullValue() {
        return NULL_VALUE;
    }

    private DateTimeValue() {
        this.hashCode = 0;
    }

    public DateTimeValue(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.calendar = new GregorianCalendar(n, n2, n3, n4, n5, n6);
        this.calendar.set(14, n7);
        this.calendar.setTimeZone(TimeZone.getTimeZone((String)"GMT"));
        if (this.getYear() != n || this.getMonth() != n2 || this.getDayOfMonth() != n3 || this.getHourOfDay() != n4 || this.getMinute() != n5 || this.getSecond() != n6 || this.getMillisecond() != n7) {
            throw new IllegalArgumentException("Invalid java date (yyyy-MM-dd hh:mm:ss.S): " + n + '-' + n2 + '-' + n3 + ' ' + n4 + ':' + n5 + ':' + n6 + '.' + n7);
        }
    }

    public DateTimeValue(GregorianCalendar gregorianCalendar) {
        if (!gregorianCalendar.getTimeZone().equals((Object)TimeZone.getTimeZone((String)"GMT"))) {
            throw new IllegalArgumentException("Can't create DateTimeValue from GregorianCalendar that is not GMT.");
        }
        this.calendar = (GregorianCalendar)gregorianCalendar.clone();
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public int getMonth() {
        return this.calendar.get(2);
    }

    public int getDayOfMonth() {
        return this.calendar.get(5);
    }

    public int getHourOfDay() {
        return this.calendar.get(11);
    }

    public int getMinute() {
        return this.calendar.get(12);
    }

    public int getSecond() {
        return this.calendar.get(13);
    }

    public int getMillisecond() {
        return this.calendar.get(14);
    }

    @Override
    public ValueType getType() {
        return ValueType.DATETIME;
    }

    public String toString() {
        if (this == NULL_VALUE) {
            return "null";
        }
        String string = String.format("%1$d-%2$02d-%3$02d %4$02d:%5$02d:%6$02d", this.getYear(), this.getMonth() + 1, this.getDayOfMonth(), this.getHourOfDay(), this.getMinute(), this.getSecond());
        if (this.getMillisecond() > 0) {
            string = string + "." + String.format("%1$03d", this.getMillisecond());
        }
        return string;
    }

    @Override
    public boolean isNull() {
        return this == NULL_VALUE;
    }

    @Override
    public int compareTo(Value value) {
        if (this == value) {
            return 0;
        }
        DateTimeValue dateTimeValue = (DateTimeValue)value;
        if (this.isNull()) {
            return -1;
        }
        if (dateTimeValue.isNull()) {
            return 1;
        }
        return this.calendar.compareTo((Calendar)dateTimeValue.getCalendar());
    }

    @Override
    public int hashCode() {
        if (null != this.hashCode) {
            return this.hashCode;
        }
        int n = 1579;
        n = n * 11 + this.getYear();
        n = n * 11 + this.getMonth();
        n = n * 11 + this.getDayOfMonth();
        n = n * 11 + this.getHourOfDay();
        n = n * 11 + this.getMinute();
        n = n * 11 + this.getSecond();
        n = n * 11 + this.getMillisecond();
        this.hashCode = n;
        return this.hashCode;
    }

    public Calendar getObjectToFormat() {
        if (this.isNull()) {
            return null;
        }
        return this.calendar;
    }

    public GregorianCalendar getCalendar() {
        if (this.isNull()) {
            throw new NullValueException("This object is null");
        }
        return this.calendar;
    }

    @Override
    protected String innerToQueryString() {
        String string = "DATETIME '" + this.getYear() + "-" + (this.getMonth() + 1) + "-" + this.getDayOfMonth() + " " + this.getHourOfDay() + ":" + this.getMinute() + ":" + this.getSecond();
        int n = this.getMillisecond();
        if (n != 0) {
            string = string + "." + n;
        }
        string = string + "'";
        return string;
    }
}

