/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable;

import com.google.common.collect.Maps;
import com.google.visualization.datasource.datatable.value.BooleanValue;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.TextValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.ibm.icu.util.ULocale;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public class TableCell {
    private Value value;
    private String formattedValue = null;
    private Map<String, String> customProperties = null;

    public static Comparator<TableCell> getLocalizedComparator(final ULocale uLocale) {
        return new Comparator<TableCell>(){
            private Comparator<TextValue> textValueComparator;
            {
                this.textValueComparator = TextValue.getTextLocalizedComparator(uLocale);
            }

            @Override
            public int compare(TableCell tableCell, TableCell tableCell2) {
                if (tableCell == tableCell2) {
                    return 0;
                }
                if (tableCell.getType() == ValueType.TEXT) {
                    return this.textValueComparator.compare((TextValue)tableCell.value, (TextValue)tableCell2.value);
                }
                return tableCell.getValue().compareTo(tableCell2.getValue());
            }
        };
    }

    public String getFormattedValue() {
        return this.formattedValue;
    }

    public void setFormattedValue(String string) {
        this.formattedValue = string;
    }

    public TableCell(Value value) {
        this.value = value;
    }

    public TableCell(Value value, String string) {
        this.value = value;
        this.formattedValue = string;
    }

    public TableCell(TableCell tableCell) {
        this(tableCell.value, tableCell.formattedValue);
    }

    public TableCell(String string) {
        this.value = new TextValue(string);
    }

    public TableCell(boolean bl) {
        this.value = BooleanValue.getInstance(bl);
    }

    public TableCell(double d) {
        this.value = new NumberValue(d);
    }

    public Value getValue() {
        return this.value;
    }

    public ValueType getType() {
        return this.value.getType();
    }

    public boolean isNull() {
        return this.value.isNull();
    }

    public String toString() {
        return this.value.toString();
    }

    public String getCustomProperty(String string) {
        if (this.customProperties == null) {
            return null;
        }
        if (string == null) {
            throw new RuntimeException("Null keys are not allowed.");
        }
        return this.customProperties.get(string);
    }

    public void setCustomProperty(String string, String string2) {
        if (this.customProperties == null) {
            this.customProperties = Maps.newHashMap();
        }
        if (string == null || string2 == null) {
            throw new RuntimeException("Null keys/values are not allowed.");
        }
        this.customProperties.put(string, string2);
    }

    public Map<String, String> getCustomProperties() {
        if (this.customProperties == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.customProperties);
    }

    public TableCell clone() {
        TableCell tableCell = new TableCell(this.value, this.formattedValue);
        if (this.customProperties != null) {
            tableCell.customProperties = Maps.newHashMap();
            for (Map.Entry<String, String> entry : this.customProperties.entrySet()) {
                tableCell.customProperties.put(entry.getKey(), entry.getValue());
            }
        }
        return tableCell;
    }
}

