/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.base;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.util.ULocale;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocaleUtil {
    private static final Pattern LOCALE_PATTERN = Pattern.compile("(^[^_-]*)(?:[_-]([^_-]*)(?:[_-]([^_-]*))?)?");
    private static ULocale defaultLocale = ULocale.US;

    private LocaleUtil() {
    }

    public static Locale getLocaleFromLocaleString(String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = LOCALE_PATTERN.matcher(string);
        matcher.find();
        String string2 = matcher.group(1);
        string2 = string2 == null ? "" : string2;
        String string3 = matcher.group(2);
        string3 = string3 == null ? "" : string3;
        String string4 = matcher.group(3);
        string4 = string4 == null ? "" : string4;
        return new Locale(string2, string3, string4);
    }

    public static void setDefaultLocale(ULocale uLocale) {
        defaultLocale = uLocale;
    }

    public static ULocale getDefaultLocale() {
        return defaultLocale;
    }

    public static String getLocalizedMessageFromBundle(String string, String string2, Locale locale) {
        if (locale == null) {
            return ResourceBundle.getBundle(string).getString(string2);
        }
        return ResourceBundle.getBundle(string, locale).getString(string2);
    }

    public static String getLocalizedMessageFromBundleWithArguments(String string, String string2, String[] stringArray, Locale locale) {
        String string3 = LocaleUtil.getLocalizedMessageFromBundle(string, string2, locale);
        if (stringArray != null && stringArray.length > 0) {
            return MessageFormat.format((String)string3, (Object[])stringArray);
        }
        return string3;
    }
}

