/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.DoubleSubject;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import java.util.OptionalDouble;
import javax.annotation.Nullable;

public final class OptionalDoubleSubject
extends Subject<OptionalDoubleSubject, OptionalDouble> {
    OptionalDoubleSubject(FailureMetadata failureMetadata, @Nullable OptionalDouble subject, @Nullable String typeDescription) {
        super(failureMetadata, (Object)subject, typeDescription);
    }

    public void isPresent() {
        if (this.actual() == null || !((OptionalDouble)this.actual()).isPresent()) {
            this.failWithoutActual("is present");
        }
    }

    public void isEmpty() {
        if (this.actual() == null || ((OptionalDouble)this.actual()).isPresent()) {
            this.fail("is empty");
        }
    }

    public void hasValue(double expected) {
        if (this.actual() == null || !((OptionalDouble)this.actual()).isPresent()) {
            this.fail("has value", expected);
        } else {
            double actual = ((OptionalDouble)this.actual()).getAsDouble();
            if (actual != expected) {
                this.fail("has value", expected);
            }
        }
    }

    public DoubleSubject hasValueThat() {
        if (this.actual() == null || !((OptionalDouble)this.actual()).isPresent()) {
            this.failWithoutActual("is present");
            return this.ignoreCheck().that(Double.valueOf(0.0));
        }
        return this.check().that(Double.valueOf(((OptionalDouble)this.actual()).getAsDouble()));
    }

    public static Subject.Factory<OptionalDoubleSubject, OptionalDouble> optionalDoubles() {
        return (metadata, subject) -> new OptionalDoubleSubject(metadata, (OptionalDouble)subject, "optionalDouble");
    }
}

