/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.annotation.Nullable;

public final class LongStreamSubject
extends Subject<LongStreamSubject, LongStream> {
    private final List<?> actualList;

    private LongStreamSubject(FailureMetadata failureMetadata, @Nullable LongStream stream) {
        super(failureMetadata, (Object)stream);
        this.actualList = stream == null ? null : (List)stream.boxed().collect(Collectors.toCollection(ArrayList::new));
    }

    protected String actualCustomStringRepresentation() {
        return String.valueOf(this.actualList);
    }

    public static Subject.Factory<LongStreamSubject, LongStream> longStreams() {
        return LongStreamSubject::new;
    }

    public void isEmpty() {
        this.check().that(this.actualList).isEmpty();
    }

    public void isNotEmpty() {
        this.check().that(this.actualList).isNotEmpty();
    }

    public void hasSize(int expectedSize) {
        this.check().that(this.actualList).hasSize(expectedSize);
    }

    public void contains(long element) {
        this.check().that(this.actualList).contains((Object)element);
    }

    public void doesNotContain(long element) {
        this.check().that(this.actualList).doesNotContain((Object)element);
    }

    public void containsNoDuplicates() {
        this.check().that(this.actualList).containsNoDuplicates();
    }

    public void containsAnyOf(long first, long second, long ... rest) {
        this.check().that(this.actualList).containsAnyOf((Object)first, (Object)second, LongStreamSubject.box(rest));
    }

    public void containsAnyIn(Iterable<?> expected) {
        this.check().that(this.actualList).containsAnyIn(expected);
    }

    @CanIgnoreReturnValue
    public Ordered containsAllOf(long first, long second, long ... rest) {
        return this.check().that(this.actualList).containsAllOf((Object)first, (Object)second, LongStreamSubject.box(rest));
    }

    @CanIgnoreReturnValue
    public Ordered containsAllIn(Iterable<?> expected) {
        return this.check().that(this.actualList).containsAllIn(expected);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly(long ... varargs) {
        return this.check().that(this.actualList).containsExactly(LongStreamSubject.box(varargs));
    }

    @CanIgnoreReturnValue
    public Ordered containsExactlyElementsIn(Iterable<?> expected) {
        return this.check().that(this.actualList).containsExactlyElementsIn(expected);
    }

    public void containsNoneOf(long first, long second, long ... rest) {
        this.check().that(this.actualList).containsNoneOf((Object)first, (Object)second, LongStreamSubject.box(rest));
    }

    public void containsNoneIn(Iterable<?> excluded) {
        this.check().that(this.actualList).containsNoneIn(excluded);
    }

    private void isInStrictOrder() {
        this.check().that(this.actualList).isStrictlyOrdered();
    }

    private void isInStrictOrder(Comparator<?> comparator) {
        this.check().that(this.actualList).isStrictlyOrdered(comparator);
    }

    private void isInOrder() {
        this.check().that(this.actualList).isOrdered();
    }

    private void isInOrder(Comparator<?> comparator) {
        this.check().that(this.actualList).isOrdered(comparator);
    }

    private static Object[] box(long[] rest) {
        return LongStream.of(rest).boxed().toArray(Long[]::new);
    }
}

