/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.testing.junit.testparameterinjector.GenericParameterContext;
import com.google.testing.junit.testparameterinjector.TestParameter;
import com.google.testing.junit.testparameterinjector.TestParameterValue;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.Nullable;

public abstract class TestParameterValuesProvider
implements TestParameter.TestParameterValuesProvider {
    protected abstract List<?> provideValues(Context var1) throws Exception;

    @Override
    @Deprecated
    public final List<?> provideValues() {
        throw new UnsupportedOperationException("The TestParameterInjector framework should never call this method, and instead call #provideValues(Context)");
    }

    @Override
    public final TestParameterValue value(@Nullable Object wrappedValue) {
        return TestParameterValue.wrap(wrappedValue);
    }

    public static final class Context {
        private final GenericParameterContext delegate;

        Context(GenericParameterContext delegate) {
            this.delegate = delegate;
        }

        public <A extends Annotation> A getOtherAnnotation(Class<A> annotationType) {
            Preconditions.checkArgument((!TestParameter.class.equals(annotationType) ? 1 : 0) != 0, (Object)"Getting the @TestParameter annotating the field or parameter is not allowed because it is already handled by the TestParameterInjector framework.");
            return this.delegate.getAnnotation(annotationType);
        }

        public <A extends Annotation> ImmutableList<A> getOtherAnnotations(Class<A> annotationType) {
            Preconditions.checkArgument((!TestParameter.class.equals(annotationType) ? 1 : 0) != 0, (Object)"Getting the @TestParameter annotating the field or parameter is not allowed because it is already handled by the TestParameterInjector framework.");
            return this.delegate.getAnnotations(annotationType);
        }

        public Class<?> testClass() {
            return this.delegate.testClass();
        }

        @VisibleForTesting
        ImmutableList<Annotation> annotationsOnParameter() {
            return this.delegate.annotationsOnParameter();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

