/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.testing.compile.InMemoryJavaFileManager;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;

public final class Parser {
    private static final TreeScanner<Boolean, Boolean> HAS_ERRONEOUS_NODE = new TreeScanner<Boolean, Boolean>(){

        @Override
        public Boolean visitErroneous(ErroneousTree node, Boolean p) {
            return true;
        }

        @Override
        public Boolean scan(Iterable<? extends Tree> nodes, Boolean p) {
            for (Tree node : (Iterable)MoreObjects.firstNonNull(nodes, (Object)ImmutableList.of())) {
                if (!Parser.isTrue(this.scan(node, p))) continue;
                return true;
            }
            return p;
        }

        @Override
        public Boolean scan(Tree tree, Boolean p) {
            return Parser.isTrue(p) ? p : (Boolean)super.scan(tree, p);
        }

        @Override
        public Boolean reduce(Boolean r1, Boolean r2) {
            return Parser.isTrue(r1) || Parser.isTrue(r2);
        }
    };

    static ParseResult parse(Iterable<? extends JavaFileObject> sources, String sourcesDescription) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        InMemoryJavaFileManager fileManager = new InMemoryJavaFileManager(compiler.getStandardFileManager(diagnosticCollector, Locale.getDefault(), StandardCharsets.UTF_8));
        Context context = new Context();
        JavacTask task = ((JavacTool)compiler).getTask(null, fileManager, diagnosticCollector, (Iterable<String>)ImmutableSet.of(), (Iterable<String>)ImmutableSet.of(), sources, context);
        try {
            Iterable<? extends CompilationUnitTree> parsedCompilationUnits = task.parse();
            List<Diagnostic<? extends JavaFileObject>> diagnostics = diagnosticCollector.getDiagnostics();
            if (Parser.foundParseErrors(parsedCompilationUnits, diagnostics)) {
                String msgPrefix = String.format("Error while parsing %s:\n", sourcesDescription);
                throw new IllegalStateException(msgPrefix + Joiner.on((char)'\n').join(diagnostics));
            }
            ParseResult parseResult = new ParseResult(Parser.sortDiagnosticsByKind(diagnostics), parsedCompilationUnits, Trees.instance(task));
            return parseResult;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            DummyJavaCompilerSubclass.closeCompiler(context);
        }
    }

    private static boolean foundParseErrors(Iterable<? extends CompilationUnitTree> parsedCompilationUnits, List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        return diagnostics.stream().map(Diagnostic::getKind).anyMatch(Predicate.isEqual((Object)Diagnostic.Kind.ERROR)) || Iterables.any(parsedCompilationUnits, Parser::hasErrorNode);
    }

    private static boolean hasErrorNode(Tree tree) {
        return Parser.isTrue(HAS_ERRONEOUS_NODE.scan(tree, (Boolean)false));
    }

    private static boolean isTrue(Boolean p) {
        return Boolean.TRUE.equals(p);
    }

    private static ImmutableListMultimap<Diagnostic.Kind, Diagnostic<? extends JavaFileObject>> sortDiagnosticsByKind(Iterable<Diagnostic<? extends JavaFileObject>> diagnostics) {
        return Multimaps.index(diagnostics, input -> input.getKind());
    }

    private Parser() {
    }

    private static final class DummyJavaCompilerSubclass
    extends com.sun.tools.javac.main.JavaCompiler {
        private static void closeCompiler(Context context) {
            com.sun.tools.javac.main.JavaCompiler compiler = (com.sun.tools.javac.main.JavaCompiler)context.get(compilerKey);
            if (compiler != null) {
                compiler.close();
            }
        }

        private DummyJavaCompilerSubclass() {
            super(null);
        }
    }

    static final class ParseResult {
        private final ImmutableListMultimap<Diagnostic.Kind, Diagnostic<? extends JavaFileObject>> diagnostics;
        private final ImmutableList<? extends CompilationUnitTree> compilationUnits;
        private final Trees trees;

        ParseResult(ImmutableListMultimap<Diagnostic.Kind, Diagnostic<? extends JavaFileObject>> diagnostics, Iterable<? extends CompilationUnitTree> compilationUnits, Trees trees) {
            this.trees = trees;
            this.compilationUnits = ImmutableList.copyOf(compilationUnits);
            this.diagnostics = diagnostics;
        }

        ImmutableListMultimap<Diagnostic.Kind, Diagnostic<? extends JavaFileObject>> diagnosticsByKind() {
            return this.diagnostics;
        }

        ImmutableList<? extends CompilationUnitTree> compilationUnits() {
            return this.compilationUnits;
        }

        Trees trees() {
            return this.trees;
        }
    }
}

