/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.constraintsolver;

import com.google.ortools.constraintsolver.Assignment;
import com.google.ortools.constraintsolver.IntVar;
import com.google.ortools.constraintsolver.IntervalVar;
import com.google.ortools.constraintsolver.SearchMonitor;
import com.google.ortools.constraintsolver.SequenceVar;
import com.google.ortools.constraintsolver.Solver;
import com.google.ortools.constraintsolver.mainJNI;

public class SolutionCollector
extends SearchMonitor {
    private transient long swigCPtr;

    protected SolutionCollector(long cPtr, boolean cMemoryOwn) {
        super(mainJNI.SolutionCollector_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(SolutionCollector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(SolutionCollector obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_SolutionCollector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public SolutionCollector(Solver solver, Assignment assignment) {
        this(mainJNI.new_SolutionCollector__SWIG_0(Solver.getCPtr(solver), solver, Assignment.getCPtr(assignment), assignment), true);
    }

    public SolutionCollector(Solver solver) {
        this(mainJNI.new_SolutionCollector__SWIG_1(Solver.getCPtr(solver), solver), true);
    }

    @Override
    public void install() {
        mainJNI.SolutionCollector_install(this.swigCPtr, this);
    }

    @Override
    public String toString() {
        return mainJNI.SolutionCollector_toString(this.swigCPtr, this);
    }

    public void add(IntVar var) {
        mainJNI.SolutionCollector_add__SWIG_0(this.swigCPtr, this, IntVar.getCPtr(var), var);
    }

    public void add(IntVar[] vars) {
        mainJNI.SolutionCollector_add__SWIG_1(this.swigCPtr, this, vars);
    }

    public void add(IntervalVar var) {
        mainJNI.SolutionCollector_add__SWIG_2(this.swigCPtr, this, IntervalVar.getCPtr(var), var);
    }

    public void add(IntervalVar[] vars) {
        mainJNI.SolutionCollector_add__SWIG_3(this.swigCPtr, this, vars);
    }

    public void add(SequenceVar var) {
        mainJNI.SolutionCollector_add__SWIG_4(this.swigCPtr, this, SequenceVar.getCPtr(var), var);
    }

    public void add(SequenceVar[] vars) {
        mainJNI.SolutionCollector_add__SWIG_5(this.swigCPtr, this, vars);
    }

    public void addObjective(IntVar objective) {
        mainJNI.SolutionCollector_addObjective(this.swigCPtr, this, IntVar.getCPtr(objective), objective);
    }

    public void AddObjectives(IntVar[] objectives) {
        mainJNI.SolutionCollector_AddObjectives(this.swigCPtr, this, objectives);
    }

    @Override
    public void enterSearch() {
        mainJNI.SolutionCollector_enterSearch(this.swigCPtr, this);
    }

    public int solutionCount() {
        return mainJNI.SolutionCollector_solutionCount(this.swigCPtr, this);
    }

    public boolean has_solution() {
        return mainJNI.SolutionCollector_has_solution(this.swigCPtr, this);
    }

    public Assignment solution(int n) {
        long cPtr = mainJNI.SolutionCollector_solution(this.swigCPtr, this, n);
        return cPtr == 0L ? null : new Assignment(cPtr, false);
    }

    public Assignment last_solution_or_null() {
        long cPtr = mainJNI.SolutionCollector_last_solution_or_null(this.swigCPtr, this);
        return cPtr == 0L ? null : new Assignment(cPtr, false);
    }

    public long wallTime(int n) {
        return mainJNI.SolutionCollector_wallTime(this.swigCPtr, this, n);
    }

    public long branches(int n) {
        return mainJNI.SolutionCollector_branches(this.swigCPtr, this, n);
    }

    public long failures(int n) {
        return mainJNI.SolutionCollector_failures(this.swigCPtr, this, n);
    }

    public long objectiveValue(int n) {
        return mainJNI.SolutionCollector_objectiveValue(this.swigCPtr, this, n);
    }

    public long ObjectiveValueFromIndex(int n, int index) {
        return mainJNI.SolutionCollector_ObjectiveValueFromIndex(this.swigCPtr, this, n, index);
    }

    public long value(int n, IntVar var) {
        return mainJNI.SolutionCollector_value(this.swigCPtr, this, n, IntVar.getCPtr(var), var);
    }

    public long startValue(int n, IntervalVar var) {
        return mainJNI.SolutionCollector_startValue(this.swigCPtr, this, n, IntervalVar.getCPtr(var), var);
    }

    public long endValue(int n, IntervalVar var) {
        return mainJNI.SolutionCollector_endValue(this.swigCPtr, this, n, IntervalVar.getCPtr(var), var);
    }

    public long durationValue(int n, IntervalVar var) {
        return mainJNI.SolutionCollector_durationValue(this.swigCPtr, this, n, IntervalVar.getCPtr(var), var);
    }

    public long performedValue(int n, IntervalVar var) {
        return mainJNI.SolutionCollector_performedValue(this.swigCPtr, this, n, IntervalVar.getCPtr(var), var);
    }

    public int[] forwardSequence(int n, SequenceVar var) {
        return mainJNI.SolutionCollector_forwardSequence(this.swigCPtr, this, n, SequenceVar.getCPtr(var), var);
    }

    public int[] backwardSequence(int n, SequenceVar var) {
        return mainJNI.SolutionCollector_backwardSequence(this.swigCPtr, this, n, SequenceVar.getCPtr(var), var);
    }

    public int[] unperformed(int n, SequenceVar var) {
        return mainJNI.SolutionCollector_unperformed(this.swigCPtr, this, n, SequenceVar.getCPtr(var), var);
    }
}

