/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.sat;

import com.google.ortools.sat.CpModel;
import com.google.ortools.sat.CpSatHelper;
import com.google.ortools.sat.CpSolverResponse;
import com.google.ortools.sat.CpSolverSolutionCallback;
import com.google.ortools.sat.CpSolverStatus;
import com.google.ortools.sat.LinearArgument;
import com.google.ortools.sat.LinearExpr;
import com.google.ortools.sat.Literal;
import com.google.ortools.sat.SatParameters;
import com.google.ortools.sat.SolveWrapper;
import java.util.List;
import java.util.function.Consumer;

public final class CpSolver {
    private CpSolverResponse solveResponse;
    private final SatParameters.Builder solveParameters = SatParameters.newBuilder();
    private Consumer<String> logCallback = null;
    private SolveWrapper solveWrapper = null;

    public CpSolverStatus solve(CpModel model) {
        return this.solveWithSolutionCallback(model, null);
    }

    public CpSolverStatus solve(CpModel model, CpSolverSolutionCallback cb) {
        this.createSolveWrapper();
        this.solveWrapper.setParameters(this.solveParameters.build());
        if (cb != null) {
            this.solveWrapper.addSolutionCallback(cb);
        }
        if (this.logCallback != null) {
            this.solveWrapper.addLogCallback(this.logCallback);
        }
        this.solveResponse = this.solveWrapper.solve(model.model());
        if (cb != null) {
            this.solveWrapper.clearSolutionCallback(cb);
        }
        this.releaseSolveWrapper();
        return this.solveResponse.getStatus();
    }

    @Deprecated
    public CpSolverStatus solveWithSolutionCallback(CpModel model, CpSolverSolutionCallback cb) {
        return this.solve(model, cb);
    }

    @Deprecated
    public CpSolverStatus searchAllSolutions(CpModel model, CpSolverSolutionCallback cb) {
        boolean oldValue = this.solveParameters.getEnumerateAllSolutions();
        this.solveParameters.setEnumerateAllSolutions(true);
        this.solve(model, cb);
        this.solveParameters.setEnumerateAllSolutions(oldValue);
        return this.solveResponse.getStatus();
    }

    private synchronized void createSolveWrapper() {
        this.solveWrapper = new SolveWrapper();
    }

    private synchronized void releaseSolveWrapper() {
        this.solveWrapper = null;
    }

    public synchronized void stopSearch() {
        if (this.solveWrapper != null) {
            this.solveWrapper.stopSearch();
        }
    }

    public double objectiveValue() {
        return this.solveResponse.getObjectiveValue();
    }

    public double bestObjectiveBound() {
        return this.solveResponse.getBestObjectiveBound();
    }

    public long value(LinearArgument expr) {
        LinearExpr e = expr.build();
        long result = e.getOffset();
        for (int i = 0; i < e.numElements(); ++i) {
            result += this.solveResponse.getSolution(e.getVariableIndex(i)) * e.getCoefficient(i);
        }
        return result;
    }

    public Boolean booleanValue(Literal var) {
        int index = var.getIndex();
        if (index >= 0) {
            return this.solveResponse.getSolution(index) != 0L;
        }
        return this.solveResponse.getSolution(-index - 1) == 0L;
    }

    public CpSolverResponse response() {
        return this.solveResponse;
    }

    public long numBranches() {
        return this.solveResponse.getNumBranches();
    }

    public long numConflicts() {
        return this.solveResponse.getNumConflicts();
    }

    public double wallTime() {
        return this.solveResponse.getWallTime();
    }

    public double userTime() {
        return this.solveResponse.getUserTime();
    }

    public List<Integer> sufficientAssumptionsForInfeasibility() {
        return this.solveResponse.getSufficientAssumptionsForInfeasibilityList();
    }

    public SatParameters.Builder getParameters() {
        return this.solveParameters;
    }

    public void setLogCallback(Consumer<String> cb) {
        this.logCallback = cb;
    }

    public String responseStats() {
        return CpSatHelper.solverResponseStats(this.solveResponse);
    }

    public String getSolutionInfo() {
        return this.solveResponse.getSolutionInfo();
    }
}

