/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.modelbuilder;

import com.google.ortools.modelbuilder.ModelBuilderHelper;
import com.google.ortools.modelbuilder.Variable;

public class EnforcedLinearConstraint {
    private final ModelBuilderHelper helper;
    private final int index;

    public EnforcedLinearConstraint(ModelBuilderHelper helper) {
        this.helper = helper;
        this.index = helper.addEnforcedLinearConstraint();
    }

    EnforcedLinearConstraint(ModelBuilderHelper helper, int index) {
        if (!helper.isEnforcedConstraint(index)) {
            throw new IllegalArgumentException("the given index does not refer to an enforced linear constraint");
        }
        this.helper = helper;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public ModelBuilderHelper getHelper() {
        return this.helper;
    }

    public double getLowerBound() {
        return this.helper.getEnforcedConstraintLowerBound(this.index);
    }

    public void setLowerBound(double lb) {
        this.helper.setEnforcedConstraintLowerBound(this.index, lb);
    }

    public double getUpperBound() {
        return this.helper.getEnforcedConstraintUpperBound(this.index);
    }

    public void setUpperBound(double ub) {
        this.helper.setEnforcedConstraintUpperBound(this.index, ub);
    }

    public String getName() {
        return this.helper.getEnforcedConstraintName(this.index);
    }

    public void setName(String name) {
        this.helper.setEnforcedConstraintName(this.index, name);
    }

    public void addTerm(Variable v, double coeff) {
        this.helper.safeAddEnforcedConstraintTerm(this.index, v.getIndex(), coeff);
    }

    public void setCoefficient(Variable v, double coeff) {
        this.helper.setEnforcedConstraintCoefficient(this.index, v.getIndex(), coeff);
    }

    public void clearTerms() {
        this.helper.clearEnforcedConstraintTerms(this.index);
    }

    public Variable getIndicatorVariable() {
        return new Variable(this.helper, this.helper.getEnforcedIndicatorVariableIndex(this.index));
    }

    public void setIndicatorVariable(Variable v) {
        this.helper.setEnforcedIndicatorVariableIndex(this.index, v.index);
    }

    public boolean getIndicatorValue() {
        return this.helper.getEnforcedIndicatorValue(this.index);
    }

    public void setIndicatorValue(boolean b) {
        this.helper.setEnforcedIndicatorValue(this.index, b);
    }

    public EnforcedLinearConstraint withName(String name) {
        this.setName(name);
        return this;
    }
}

