/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.sat;

import com.google.ortools.sat.CpModel;
import com.google.ortools.sat.IntVar;
import com.google.ortools.sat.Literal;

public class DoubleLinearExpr {
    private final int[] variableIndices;
    private final double[] coefficients;
    private double offset;

    static DoubleLinearExpr sum(IntVar[] variables) {
        return DoubleLinearExpr.sumWithOffset(variables, 0.0);
    }

    static DoubleLinearExpr sum(Literal[] literals) {
        return DoubleLinearExpr.sumWithOffset(literals, 0.0);
    }

    static DoubleLinearExpr sumWithOffset(IntVar[] variables, double offset) {
        return new DoubleLinearExpr(variables, offset);
    }

    static DoubleLinearExpr sumWithOffset(Literal[] literals, double offset) {
        return new DoubleLinearExpr(literals, offset);
    }

    static DoubleLinearExpr weightedSum(IntVar[] variables, double[] coefficients) {
        return DoubleLinearExpr.weightedSumWithOffset(variables, coefficients, 0.0);
    }

    static DoubleLinearExpr weightedSum(Literal[] literals, double[] coefficients) {
        return DoubleLinearExpr.weightedSumWithOffset(literals, coefficients, 0.0);
    }

    static DoubleLinearExpr weightedSumWithOffset(IntVar[] variables, double[] coefficients, double offset) {
        if (variables.length != coefficients.length) {
            throw new CpModel.MismatchedArrayLengths("DoubleLinearExpr.weightedSum", "variables", "coefficients");
        }
        return new DoubleLinearExpr(variables, coefficients, offset);
    }

    static DoubleLinearExpr weightedSumWithOffset(Literal[] literals, double[] coefficients, double offset) {
        if (literals.length != coefficients.length) {
            throw new CpModel.MismatchedArrayLengths("DoubleLinearExpr.weightedSum", "literals", "coefficients");
        }
        return new DoubleLinearExpr(literals, coefficients, offset);
    }

    static DoubleLinearExpr term(IntVar variable, double coefficient) {
        return new DoubleLinearExpr(variable, coefficient, 0.0);
    }

    static DoubleLinearExpr term(Literal lit, double coefficient) {
        return new DoubleLinearExpr(lit, coefficient, 0.0);
    }

    static DoubleLinearExpr affine(IntVar variable, double coefficient, double offset) {
        return new DoubleLinearExpr(variable, coefficient, offset);
    }

    static DoubleLinearExpr affine(Literal lit, double coefficient, double offset) {
        return new DoubleLinearExpr(lit, coefficient, offset);
    }

    static DoubleLinearExpr constant(double value) {
        return new DoubleLinearExpr(new IntVar[0], value);
    }

    public int numElements() {
        return this.variableIndices.length;
    }

    public int getVariableIndex(int index) {
        if (index < 0 || index >= this.variableIndices.length) {
            throw new IllegalArgumentException("wrong index in LinearExpr.getVariable(): " + index);
        }
        return this.variableIndices[index];
    }

    public double getCoefficient(int index) {
        if (index < 0 || index >= this.variableIndices.length) {
            throw new IllegalArgumentException("wrong index in LinearExpr.getCoefficient(): " + index);
        }
        return this.coefficients[index];
    }

    public double getOffset() {
        return this.offset;
    }

    public DoubleLinearExpr(IntVar[] variables, double[] coefficients, double offset) {
        this.variableIndices = new int[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            this.variableIndices[i] = variables[i].getIndex();
        }
        this.coefficients = coefficients;
        this.offset = offset;
    }

    public DoubleLinearExpr(Literal[] literals, double[] coefficients, double offset) {
        int size = literals.length;
        this.variableIndices = new int[size];
        this.coefficients = new double[size];
        this.offset = offset;
        for (int i = 0; i < size; ++i) {
            Literal lit = literals[i];
            double coeff = coefficients[i];
            if (lit.getIndex() >= 0) {
                this.variableIndices[i] = lit.getIndex();
                this.coefficients[i] = coeff;
                continue;
            }
            this.variableIndices[i] = lit.not().getIndex();
            this.coefficients[i] = -coeff;
            this.offset -= coeff;
        }
    }

    public DoubleLinearExpr(IntVar var, double coefficient, double offset) {
        this.variableIndices = new int[]{var.getIndex()};
        this.coefficients = new double[]{coefficient};
        this.offset = offset;
    }

    public DoubleLinearExpr(Literal lit, double coefficient, double offset) {
        if (lit.getIndex() >= 0) {
            this.variableIndices = new int[]{lit.getIndex()};
            this.coefficients = new double[]{coefficient};
            this.offset = offset;
        } else {
            this.variableIndices = new int[]{lit.not().getIndex()};
            this.coefficients = new double[]{-coefficient};
            this.offset = offset + coefficient;
        }
    }

    public DoubleLinearExpr(IntVar[] vars, double offset) {
        int size = vars.length;
        this.variableIndices = new int[size];
        this.coefficients = new double[size];
        this.offset = offset;
        for (int i = 0; i < size; ++i) {
            this.variableIndices[i] = vars[i].getIndex();
            this.coefficients[i] = 1.0;
        }
    }

    public DoubleLinearExpr(Literal[] literals, double offset) {
        int size = literals.length;
        this.variableIndices = new int[size];
        this.coefficients = new double[size];
        this.offset = offset;
        for (int i = 0; i < size; ++i) {
            Literal lit = literals[i];
            if (lit.getIndex() >= 0) {
                this.variableIndices[i] = lit.getIndex();
                this.coefficients[i] = 1.0;
                continue;
            }
            this.variableIndices[i] = lit.not().getIndex();
            this.coefficients[i] = -1.0;
            this.offset -= 1.0;
        }
    }
}

