/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.auth.helpers.oauth;

import com.google.api.client.auth.oauth.OAuthHmacSigner;
import com.google.api.client.auth.oauth.OAuthParameters;
import com.google.api.client.extensions.auth.helpers.Credential;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import java.io.IOException;
import javax.jdo.InstanceCallbacks;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.annotations.NotPersistent;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;

@javax.jdo.annotations.PersistenceCapable
public final class OAuthHmacCredential
implements Credential,
InstanceCallbacks,
PersistenceCapable {
    @PrimaryKey
    private String userId;
    @Persistent
    private String consumerKey;
    @Persistent
    private String sharedSecret;
    @Persistent
    private String tokenSharedSecret;
    @Persistent
    private String token;
    @NotPersistent
    private OAuthParameters authorizer;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    public OAuthHmacCredential(String userId, String consumerKey, String sharedSecret, String tokenSharedSecret, String token) {
        this.userId = userId;
        this.consumerKey = consumerKey;
        this.sharedSecret = sharedSecret;
        this.tokenSharedSecret = tokenSharedSecret;
        this.token = token;
        this.postConstruct();
    }

    private void postConstruct() {
        OAuthHmacSigner signer = new OAuthHmacSigner();
        signer.clientSharedSecret = OAuthHmacCredential.jdoGetsharedSecret(this);
        signer.tokenSharedSecret = OAuthHmacCredential.jdoGettokenSharedSecret(this);
        this.authorizer = new OAuthParameters();
        this.authorizer.consumerKey = OAuthHmacCredential.jdoGetconsumerKey(this);
        this.authorizer.signer = signer;
        this.authorizer.token = OAuthHmacCredential.jdoGettoken(this);
    }

    public void initialize(HttpRequest request) throws IOException {
        this.authorizer.initialize(request);
        request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)this);
    }

    public void intercept(HttpRequest request) throws IOException {
        this.authorizer.intercept(request);
    }

    public boolean handleResponse(HttpRequest request, HttpResponse response, boolean retrySupported) {
        if (response.getStatusCode() == 401) {
            OAuthHmacCredential.jdoSettoken(this, null);
        }
        return false;
    }

    public void jdoPreClear() {
    }

    public void jdoPreDelete() {
    }

    public void jdoPostLoad() {
        this.postConstruct();
    }

    public void jdoPreStore() {
    }

    public boolean isInvalid() {
        return OAuthHmacCredential.jdoGettoken(this) == null;
    }

    static {
        jdoFieldNames = OAuthHmacCredential.__jdoFieldNamesInit();
        jdoFieldTypes = OAuthHmacCredential.__jdoFieldTypesInit();
        jdoFieldFlags = OAuthHmacCredential.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = OAuthHmacCredential.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = OAuthHmacCredential.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)OAuthHmacCredential.___jdo$loadClass("com.google.api.client.extensions.auth.helpers.oauth.OAuthHmacCredential"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new OAuthHmacCredential());
    }

    protected OAuthHmacCredential() {
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(4, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.userId = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        return null;
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        return null;
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        return false;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.userId);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public boolean jdoIsDetached() {
        return false;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        OAuthHmacCredential result = new OAuthHmacCredential();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        OAuthHmacCredential result = new OAuthHmacCredential();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.consumerKey = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.sharedSecret = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.token = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.tokenSharedSecret = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.userId = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.consumerKey);
                break;
            }
            case 1: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.sharedSecret);
                break;
            }
            case 2: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.token);
                break;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.tokenSharedSecret);
                break;
            }
            case 4: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.userId);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(OAuthHmacCredential obj, int index) {
        switch (index) {
            case 0: {
                this.consumerKey = obj.consumerKey;
                break;
            }
            case 1: {
                this.sharedSecret = obj.sharedSecret;
                break;
            }
            case 2: {
                this.token = obj.token;
                break;
            }
            case 3: {
                this.tokenSharedSecret = obj.tokenSharedSecret;
                break;
            }
            case 4: {
                this.userId = obj.userId;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof OAuthHmacCredential)) {
            throw new IllegalArgumentException("object is not an object of type com.google.api.client.extensions.auth.helpers.oauth.OAuthHmacCredential");
        }
        OAuthHmacCredential other = (OAuthHmacCredential)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"consumerKey", "sharedSecret", "token", "tokenSharedSecret", "userId"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{OAuthHmacCredential.___jdo$loadClass("java.lang.String"), OAuthHmacCredential.___jdo$loadClass("java.lang.String"), OAuthHmacCredential.___jdo$loadClass("java.lang.String"), OAuthHmacCredential.___jdo$loadClass("java.lang.String"), OAuthHmacCredential.___jdo$loadClass("java.lang.String")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 21, 21, 24};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 5;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        OAuthHmacCredential o = (OAuthHmacCredential)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static String jdoGetconsumerKey(OAuthHmacCredential objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 0, objPC.consumerKey);
        }
        return objPC.consumerKey;
    }

    private static void jdoSetconsumerKey(OAuthHmacCredential objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 0, objPC.consumerKey, val);
        } else {
            objPC.consumerKey = val;
        }
    }

    private static String jdoGetsharedSecret(OAuthHmacCredential objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 1, objPC.sharedSecret);
        }
        return objPC.sharedSecret;
    }

    private static void jdoSetsharedSecret(OAuthHmacCredential objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 1, objPC.sharedSecret, val);
        } else {
            objPC.sharedSecret = val;
        }
    }

    private static String jdoGettoken(OAuthHmacCredential objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 2, objPC.token);
        }
        return objPC.token;
    }

    private static void jdoSettoken(OAuthHmacCredential objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 2, objPC.token, val);
        } else {
            objPC.token = val;
        }
    }

    private static String jdoGettokenSharedSecret(OAuthHmacCredential objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 3, objPC.tokenSharedSecret);
        }
        return objPC.tokenSharedSecret;
    }

    private static void jdoSettokenSharedSecret(OAuthHmacCredential objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3, objPC.tokenSharedSecret, val);
        } else {
            objPC.tokenSharedSecret = val;
        }
    }

    private static String jdoGetuserId(OAuthHmacCredential objPC) {
        return objPC.userId;
    }

    private static void jdoSetuserId(OAuthHmacCredential objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.userId = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 4, objPC.userId, val);
        }
    }
}

