/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.jdo.auth.oauth2;

import com.google.api.client.auth.oauth2.Credential;
import com.google.common.base.Preconditions;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;

@javax.jdo.annotations.PersistenceCapable
class JdoPersistedCredential
implements PersistenceCapable {
    @PrimaryKey
    private String userId;
    @Persistent
    private String accessToken;
    @Persistent
    private String refreshToken;
    @Persistent
    private Long expirationTimeMillis;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    JdoPersistedCredential(String userId, Credential credential) {
        this.userId = (String)Preconditions.checkNotNull((Object)userId);
        this.accessToken = credential.getAccessToken();
        this.refreshToken = credential.getRefreshToken();
        this.expirationTimeMillis = credential.getExpirationTimeMilliseconds();
    }

    void load(Credential credential) {
        credential.setAccessToken(JdoPersistedCredential.jdoGetaccessToken(this));
        credential.setRefreshToken(JdoPersistedCredential.jdoGetrefreshToken(this));
        credential.setExpirationTimeMilliseconds(JdoPersistedCredential.jdoGetexpirationTimeMillis(this));
    }

    static {
        jdoFieldNames = JdoPersistedCredential.__jdoFieldNamesInit();
        jdoFieldTypes = JdoPersistedCredential.__jdoFieldTypesInit();
        jdoFieldFlags = JdoPersistedCredential.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = JdoPersistedCredential.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = JdoPersistedCredential.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)JdoPersistedCredential.___jdo$loadClass("com.google.api.client.extensions.jdo.auth.oauth2.JdoPersistedCredential"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new JdoPersistedCredential());
    }

    protected JdoPersistedCredential() {
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(3, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.userId = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        return null;
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        return null;
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        return false;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.userId);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public boolean jdoIsDetached() {
        return false;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        JdoPersistedCredential result = new JdoPersistedCredential();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        JdoPersistedCredential result = new JdoPersistedCredential();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.accessToken = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.expirationTimeMillis = (Long)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.refreshToken = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.userId = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.accessToken);
                break;
            }
            case 1: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.expirationTimeMillis);
                break;
            }
            case 2: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.refreshToken);
                break;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.userId);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(JdoPersistedCredential obj, int index) {
        switch (index) {
            case 0: {
                this.accessToken = obj.accessToken;
                break;
            }
            case 1: {
                this.expirationTimeMillis = obj.expirationTimeMillis;
                break;
            }
            case 2: {
                this.refreshToken = obj.refreshToken;
                break;
            }
            case 3: {
                this.userId = obj.userId;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof JdoPersistedCredential)) {
            throw new IllegalArgumentException("object is not an object of type com.google.api.client.extensions.jdo.auth.oauth2.JdoPersistedCredential");
        }
        JdoPersistedCredential other = (JdoPersistedCredential)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"accessToken", "expirationTimeMillis", "refreshToken", "userId"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{JdoPersistedCredential.___jdo$loadClass("java.lang.String"), JdoPersistedCredential.___jdo$loadClass("java.lang.Long"), JdoPersistedCredential.___jdo$loadClass("java.lang.String"), JdoPersistedCredential.___jdo$loadClass("java.lang.String")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 21, 24};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 4;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        JdoPersistedCredential o = (JdoPersistedCredential)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static String jdoGetaccessToken(JdoPersistedCredential objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 0, objPC.accessToken);
        }
        return objPC.accessToken;
    }

    private static void jdoSetaccessToken(JdoPersistedCredential objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 0, objPC.accessToken, val);
        } else {
            objPC.accessToken = val;
        }
    }

    private static Long jdoGetexpirationTimeMillis(JdoPersistedCredential objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return (Long)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 1, (Object)objPC.expirationTimeMillis);
        }
        return objPC.expirationTimeMillis;
    }

    private static void jdoSetexpirationTimeMillis(JdoPersistedCredential objPC, Long val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 1, (Object)objPC.expirationTimeMillis, (Object)val);
        } else {
            objPC.expirationTimeMillis = val;
        }
    }

    private static String jdoGetrefreshToken(JdoPersistedCredential objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 2, objPC.refreshToken);
        }
        return objPC.refreshToken;
    }

    private static void jdoSetrefreshToken(JdoPersistedCredential objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 2, objPC.refreshToken, val);
        } else {
            objPC.refreshToken = val;
        }
    }

    private static String jdoGetuserId(JdoPersistedCredential objPC) {
        return objPC.userId;
    }

    private static void jdoSetuserId(JdoPersistedCredential objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.userId = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3, objPC.userId, val);
        }
    }
}

