/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.auth.helpers.oauth;

import com.google.api.client.auth.oauth.OAuthHmacSigner;
import com.google.api.client.auth.oauth.OAuthParameters;
import com.google.api.client.extensions.auth.helpers.Credential;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import java.io.IOException;
import javax.jdo.InstanceCallbacks;
import javax.jdo.annotations.NotPersistent;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;

@PersistenceCapable
public final class OAuthHmacCredential
implements Credential,
InstanceCallbacks {
    @PrimaryKey
    private String userId;
    @Persistent
    private String consumerKey;
    @Persistent
    private String sharedSecret;
    @Persistent
    private String tokenSharedSecret;
    @Persistent
    private String token;
    @NotPersistent
    private OAuthParameters authorizer;

    public OAuthHmacCredential(String userId, String consumerKey, String sharedSecret, String tokenSharedSecret, String token) {
        this.userId = userId;
        this.consumerKey = consumerKey;
        this.sharedSecret = sharedSecret;
        this.tokenSharedSecret = tokenSharedSecret;
        this.token = token;
        this.postConstruct();
    }

    private void postConstruct() {
        OAuthHmacSigner signer = new OAuthHmacSigner();
        signer.clientSharedSecret = this.sharedSecret;
        signer.tokenSharedSecret = this.tokenSharedSecret;
        this.authorizer = new OAuthParameters();
        this.authorizer.consumerKey = this.consumerKey;
        this.authorizer.signer = signer;
        this.authorizer.token = this.token;
    }

    public void initialize(HttpRequest request) throws IOException {
        this.authorizer.initialize(request);
        request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)this);
    }

    public void intercept(HttpRequest request) throws IOException {
        this.authorizer.intercept(request);
    }

    public boolean handleResponse(HttpRequest request, HttpResponse response, boolean retrySupported) {
        if (response.getStatusCode() == 401) {
            this.token = null;
        }
        return false;
    }

    public void jdoPreClear() {
    }

    public void jdoPreDelete() {
    }

    public void jdoPostLoad() {
        this.postConstruct();
    }

    public void jdoPreStore() {
    }

    public boolean isInvalid() {
        return this.token == null;
    }
}

