/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.java6.auth.oauth2;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.extensions.java6.auth.oauth2.FilePersistedCredential;
import com.google.api.client.json.GenericJson;
import com.google.api.client.util.Key;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;

public class FilePersistedCredentials
extends GenericJson {
    @Key
    private Map<String, FilePersistedCredential> credentials = Maps.newHashMap();

    void store(String userId, Credential credential) {
        Preconditions.checkNotNull((Object)userId);
        FilePersistedCredential fileCredential = this.credentials.get(userId);
        if (fileCredential == null) {
            fileCredential = new FilePersistedCredential();
            this.credentials.put(userId, fileCredential);
        }
        fileCredential.store(credential);
    }

    boolean load(String userId, Credential credential) {
        Preconditions.checkNotNull((Object)userId);
        FilePersistedCredential fileCredential = this.credentials.get(userId);
        if (fileCredential == null) {
            return false;
        }
        fileCredential.load(credential);
        return true;
    }

    void delete(String userId) {
        Preconditions.checkNotNull((Object)userId);
        this.credentials.remove(userId);
    }
}

