/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.metrics;

import io.opencensus.stats.Aggregation;
import io.opencensus.stats.BucketBoundaries;
import io.opencensus.stats.Measure;
import io.opencensus.stats.Stats;
import io.opencensus.stats.View;
import io.opencensus.stats.ViewManager;
import io.opencensus.tags.TagKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class OpenCensusMetrics {
    private OpenCensusMetrics() {
    }

    public static void registerAllViews() {
        OpenCensusMetrics.registerAllViews(Stats.getViewManager());
    }

    public static void registerAllViews(ViewManager viewManager) {
        View[] views_to_register;
        for (View view : views_to_register = new View[]{Views.REQUEST_COUNT, Views.REQUEST_LATENCY, Views.NETWORK_LATENCY, Views.RETRY_COUNT}) {
            viewManager.registerView(view);
        }
    }

    private static List<TagKey> tags(TagKey ... items) {
        return Collections.unmodifiableList(Arrays.asList(items));
    }

    static /* synthetic */ List access$000(TagKey[] x0) {
        return OpenCensusMetrics.tags(x0);
    }

    public static final class Views {
        private static final List<TagKey> fields = OpenCensusMetrics.access$000(new TagKey[]{Tags.REQUEST_NAME, Tags.HTTP_CODE, Tags.API_STATUS});
        public static final View REQUEST_COUNT = View.create((View.Name)View.Name.create((String)"maps.googleapis.com/client/request_count"), (String)"Request counts", (Measure)Measures.LATENCY, (Aggregation)Aggregations.access$100(), fields);
        public static final View REQUEST_LATENCY = View.create((View.Name)View.Name.create((String)"maps.googleapis.com/client/request_latency"), (String)"Latency in msecs", (Measure)Measures.LATENCY, (Aggregation)Aggregations.access$200(), fields);
        public static final View NETWORK_LATENCY = View.create((View.Name)View.Name.create((String)"maps.googleapis.com/client/network_latency"), (String)"Network latency in msecs (internal)", (Measure)Measures.NETWORK_LATENCY, (Aggregation)Aggregations.access$200(), fields);
        public static final View RETRY_COUNT = View.create((View.Name)View.Name.create((String)"maps.googleapis.com/client/retry_count"), (String)"Retries per request", (Measure)Measures.RETRY_COUNT, (Aggregation)Aggregations.access$300(), fields);

        private Views() {
        }
    }

    private static final class Aggregations {
        private static final Aggregation COUNT = Aggregation.Count.create();
        private static final Aggregation DISTRIBUTION_INTEGERS_10 = Aggregation.Distribution.create((BucketBoundaries)BucketBoundaries.create(Arrays.asList(0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0)));
        private static final Aggregation DISTRIBUTION_LATENCY = Aggregation.Distribution.create((BucketBoundaries)BucketBoundaries.create(Arrays.asList(0.0, 20.0, 25.2, 31.7, 40.0, 50.4, 63.5, 80.0, 100.8, 127.0, 160.0, 201.6, 254.0, 320.0, 403.2, 508.0, 640.0, 806.3, 1015.9, 1280.0, 1612.7, 2031.9, 2560.0, 3225.4, 4063.7)));

        private Aggregations() {
        }

        static /* synthetic */ Aggregation access$100() {
            return COUNT;
        }

        static /* synthetic */ Aggregation access$200() {
            return DISTRIBUTION_LATENCY;
        }

        static /* synthetic */ Aggregation access$300() {
            return DISTRIBUTION_INTEGERS_10;
        }
    }

    public static final class Measures {
        public static final Measure.MeasureLong LATENCY = Measure.MeasureLong.create((String)"maps.googleapis.com/measure/client/latency", (String)"Total time between library method called and results returned", (String)"ms");
        public static final Measure.MeasureLong NETWORK_LATENCY = Measure.MeasureLong.create((String)"maps.googleapis.com/measure/client/network_latency", (String)"Network time inside the library", (String)"ms");
        public static final Measure.MeasureLong RETRY_COUNT = Measure.MeasureLong.create((String)"maps.googleapis.com/measure/client/retry_count", (String)"How many times any request was retried", (String)"1");

        private Measures() {
        }
    }

    public static final class Tags {
        public static final TagKey REQUEST_NAME = TagKey.create((String)"request_name");
        public static final TagKey HTTP_CODE = TagKey.create((String)"http_code");
        public static final TagKey API_STATUS = TagKey.create((String)"api_status");

        private Tags() {
        }
    }
}

