/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.maps.GeoApiContext;
import com.google.maps.ImageResult;
import com.google.maps.PendingResultBase;
import com.google.maps.internal.ApiConfig;
import com.google.maps.internal.StringJoin;
import com.google.maps.model.LatLng;
import com.google.maps.model.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class StaticMapsRequest
extends PendingResultBase<ImageResult, StaticMapsRequest, ImageResult.Response> {
    static final ApiConfig API_CONFIG = new ApiConfig("/maps/api/staticmap");

    public StaticMapsRequest(GeoApiContext context) {
        super(context, API_CONFIG, ImageResult.Response.class);
    }

    @Override
    protected void validateRequest() {
        if (!(this.params().containsKey("center") && this.params().containsKey("zoom") || this.params().containsKey("markers"))) {
            throw new IllegalArgumentException("Request must contain 'center' and 'zoom' if 'markers' isn't present.");
        }
        if (!this.params().containsKey("size")) {
            throw new IllegalArgumentException("Request must contain 'size'.");
        }
    }

    public StaticMapsRequest center(LatLng location) {
        return (StaticMapsRequest)this.param("center", location);
    }

    public StaticMapsRequest center(String location) {
        return (StaticMapsRequest)this.param("center", location);
    }

    public StaticMapsRequest zoom(int zoom) {
        return (StaticMapsRequest)this.param("zoom", zoom);
    }

    public StaticMapsRequest size(Size size) {
        return (StaticMapsRequest)this.param("size", size);
    }

    public StaticMapsRequest scale(int scale) {
        return (StaticMapsRequest)this.param("scale", scale);
    }

    public StaticMapsRequest format(ImageFormat format) {
        return (StaticMapsRequest)this.param("format", format);
    }

    public StaticMapsRequest maptype(StaticMapType maptype) {
        return (StaticMapsRequest)this.param("maptype", maptype);
    }

    public StaticMapsRequest region(String region) {
        return (StaticMapsRequest)this.param("region", region);
    }

    public StaticMapsRequest markers(Markers markers) {
        return (StaticMapsRequest)this.paramAddToList("markers", markers);
    }

    public StaticMapsRequest path(Path path) {
        return (StaticMapsRequest)this.paramAddToList("path", path);
    }

    public StaticMapsRequest visible(LatLng visibleLocation) {
        return (StaticMapsRequest)this.param("visible", visibleLocation);
    }

    public StaticMapsRequest visible(String visibleLocation) {
        return (StaticMapsRequest)this.param("visible", visibleLocation);
    }

    public static class Path
    implements StringJoin.UrlValue {
        private int weight;
        private String color;
        private String fillcolor;
        private boolean geodesic;
        private final List<String> points = new ArrayList<String>();

        public void weight(int weight) {
            this.weight = weight;
        }

        public void color(String color) {
            this.color = color;
        }

        public void fillcolor(String color) {
            this.fillcolor = color;
        }

        public void geodesic(boolean geodesic) {
            this.geodesic = geodesic;
        }

        public void addPoint(String point) {
            this.points.add(point);
        }

        public void addPoint(LatLng point) {
            this.points.add(point.toUrlValue());
        }

        @Override
        public String toUrlValue() {
            ArrayList<String> urlParts = new ArrayList<String>();
            if (this.weight > 0) {
                urlParts.add("weight:" + this.weight);
            }
            if (this.color != null) {
                urlParts.add("color:" + this.color);
            }
            if (this.fillcolor != null) {
                urlParts.add("fillcolor:" + this.fillcolor);
            }
            if (this.geodesic) {
                urlParts.add("geodesic:" + this.geodesic);
            }
            urlParts.addAll(this.points);
            return StringJoin.join('|', urlParts.toArray(new String[urlParts.size()]));
        }
    }

    public static class Markers
    implements StringJoin.UrlValue {
        private MarkersSize size;
        private String color;
        private String label;
        private String customIconURL;
        private CustomIconAnchor anchorPoint;
        private Integer scale;
        private final List<String> locations = new ArrayList<String>();
        private static final Pattern labelPattern = Pattern.compile("^[A-Z0-9]$");

        public void size(MarkersSize size) {
            this.size = size;
        }

        public void color(String color) {
            this.color = color;
        }

        public void label(String label) {
            if (!labelPattern.matcher(label).matches()) {
                throw new IllegalArgumentException("Label '" + label + "' doesn't match acceptable label pattern.");
            }
            this.label = label;
        }

        public void customIcon(String url, CustomIconAnchor anchorPoint) {
            this.customIconURL = url;
            this.anchorPoint = anchorPoint;
        }

        public void customIcon(String url, CustomIconAnchor anchorPoint, int scale) {
            this.customIconURL = url;
            this.anchorPoint = anchorPoint;
            this.scale = scale;
        }

        public void addLocation(String location) {
            this.locations.add(location);
        }

        public void addLocation(LatLng location) {
            this.locations.add(location.toUrlValue());
        }

        @Override
        public String toUrlValue() {
            ArrayList<String> urlParts = new ArrayList<String>();
            if (this.customIconURL != null) {
                urlParts.add("icon:" + this.customIconURL);
            }
            if (this.anchorPoint != null) {
                urlParts.add("anchor:" + this.anchorPoint.toUrlValue());
            }
            if (this.scale != null) {
                urlParts.add("scale:" + this.scale);
            }
            if (this.size != null && this.size != MarkersSize.normal) {
                urlParts.add("size:" + this.size.toUrlValue());
            }
            if (this.color != null) {
                urlParts.add("color:" + this.color);
            }
            if (this.label != null) {
                urlParts.add("label:" + this.label);
            }
            urlParts.addAll(this.locations);
            return StringJoin.join('|', urlParts.toArray(new String[urlParts.size()]));
        }

        public static enum CustomIconAnchor implements StringJoin.UrlValue
        {
            top,
            bottom,
            left,
            right,
            center,
            topleft,
            topright,
            bottomleft,
            bottomright;


            @Override
            public String toUrlValue() {
                return this.name();
            }
        }

        public static enum MarkersSize implements StringJoin.UrlValue
        {
            tiny,
            mid,
            small,
            normal;


            @Override
            public String toUrlValue() {
                return this.name();
            }
        }
    }

    public static enum StaticMapType implements StringJoin.UrlValue
    {
        roadmap,
        satellite,
        terrain,
        hybrid;


        @Override
        public String toUrlValue() {
            return this.name();
        }
    }

    public static enum ImageFormat implements StringJoin.UrlValue
    {
        png("png"),
        png8("png8"),
        png32("png32"),
        gif("gif"),
        jpg("jpg"),
        jpgBaseline("jpg-baseline");

        private final String format;

        private ImageFormat(String format) {
            this.format = format;
        }

        @Override
        public String toUrlValue() {
            return this.format;
        }
    }
}

