/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.maps.GeoApiContext;
import com.google.maps.PendingResult;
import com.google.maps.internal.ApiResponse;
import com.google.maps.internal.StringJoin;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

abstract class PendingResultBase<T, A extends PendingResultBase<T, A, R>, R extends ApiResponse<T>>
implements PendingResult<T> {
    private final GeoApiContext context;
    private HashMap<String, String> params = new HashMap();
    private PendingResult<T> delegate;
    private Class<R> responseClass;
    private String base;

    protected PendingResultBase(GeoApiContext context, Class<R> responseClass, String base) {
        this.context = context;
        this.responseClass = responseClass;
        this.base = base;
    }

    @Override
    public final void setCallback(PendingResult.Callback<T> callback) {
        this.makeRequest().setCallback(callback);
    }

    @Override
    public final T await() throws Exception {
        PendingResult<T> request = this.makeRequest();
        T result = request.await();
        return result;
    }

    @Override
    public final T awaitIgnoreError() {
        return this.makeRequest().awaitIgnoreError();
    }

    @Override
    public final void cancel() {
        if (this.delegate == null) {
            return;
        }
        this.delegate.cancel();
    }

    private PendingResult<T> makeRequest() {
        if (this.delegate != null) {
            throw new IllegalStateException("'await', 'awaitIgnoreError' or 'setCallback' was already called.");
        }
        this.validateRequest();
        this.delegate = this.context.get(this.responseClass, this.base, this.params);
        return this.delegate;
    }

    protected abstract void validateRequest();

    protected A param(String key, String val) {
        this.params.put(key, val);
        PendingResultBase result = this;
        return (A)result;
    }

    protected A param(String key, StringJoin.UrlValue val) {
        this.params.put(key, val.toString());
        PendingResultBase result = this;
        return (A)result;
    }

    protected Map<String, String> params() {
        return Collections.unmodifiableMap(this.params);
    }

    public final A language(String language) {
        return this.param("language", language);
    }
}

