/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.mapsplatformdatasets.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.maps.mapsplatformdatasets.v1.CreateDatasetRequest;
import com.google.maps.mapsplatformdatasets.v1.Dataset;
import com.google.maps.mapsplatformdatasets.v1.DeleteDatasetRequest;
import com.google.maps.mapsplatformdatasets.v1.GetDatasetRequest;
import com.google.maps.mapsplatformdatasets.v1.ListDatasetsRequest;
import com.google.maps.mapsplatformdatasets.v1.ListDatasetsResponse;
import com.google.maps.mapsplatformdatasets.v1.MapsPlatformDatasetsClient;
import com.google.maps.mapsplatformdatasets.v1.UpdateDatasetMetadataRequest;
import com.google.maps.mapsplatformdatasets.v1.stub.GrpcMapsPlatformDatasetsCallableFactory;
import com.google.maps.mapsplatformdatasets.v1.stub.MapsPlatformDatasetsStub;
import com.google.maps.mapsplatformdatasets.v1.stub.MapsPlatformDatasetsStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcMapsPlatformDatasetsStub
extends MapsPlatformDatasetsStub {
    private static final MethodDescriptor<CreateDatasetRequest, Dataset> createDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.maps.mapsplatformdatasets.v1.MapsPlatformDatasets/CreateDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Dataset.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateDatasetMetadataRequest, Dataset> updateDatasetMetadataMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.maps.mapsplatformdatasets.v1.MapsPlatformDatasets/UpdateDatasetMetadata").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateDatasetMetadataRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Dataset.getDefaultInstance())).build();
    private static final MethodDescriptor<GetDatasetRequest, Dataset> getDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.maps.mapsplatformdatasets.v1.MapsPlatformDatasets/GetDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)GetDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Dataset.getDefaultInstance())).build();
    private static final MethodDescriptor<ListDatasetsRequest, ListDatasetsResponse> listDatasetsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.maps.mapsplatformdatasets.v1.MapsPlatformDatasets/ListDatasets").setRequestMarshaller(ProtoUtils.marshaller((Message)ListDatasetsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListDatasetsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteDatasetRequest, Empty> deleteDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.maps.mapsplatformdatasets.v1.MapsPlatformDatasets/DeleteDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private final UnaryCallable<CreateDatasetRequest, Dataset> createDatasetCallable;
    private final UnaryCallable<UpdateDatasetMetadataRequest, Dataset> updateDatasetMetadataCallable;
    private final UnaryCallable<GetDatasetRequest, Dataset> getDatasetCallable;
    private final UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> listDatasetsCallable;
    private final UnaryCallable<ListDatasetsRequest, MapsPlatformDatasetsClient.ListDatasetsPagedResponse> listDatasetsPagedCallable;
    private final UnaryCallable<DeleteDatasetRequest, Empty> deleteDatasetCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcMapsPlatformDatasetsStub create(MapsPlatformDatasetsStubSettings settings) throws IOException {
        return new GrpcMapsPlatformDatasetsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcMapsPlatformDatasetsStub create(ClientContext clientContext) throws IOException {
        return new GrpcMapsPlatformDatasetsStub(MapsPlatformDatasetsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcMapsPlatformDatasetsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcMapsPlatformDatasetsStub(MapsPlatformDatasetsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcMapsPlatformDatasetsStub(MapsPlatformDatasetsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcMapsPlatformDatasetsCallableFactory());
    }

    protected GrpcMapsPlatformDatasetsStub(MapsPlatformDatasetsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createDatasetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateDatasetMetadataTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateDatasetMetadataMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("dataset.name", String.valueOf(request.getDataset().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDatasetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listDatasetsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listDatasetsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteDatasetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createDatasetCallable = callableFactory.createUnaryCallable(createDatasetTransportSettings, settings.createDatasetSettings(), clientContext);
        this.updateDatasetMetadataCallable = callableFactory.createUnaryCallable(updateDatasetMetadataTransportSettings, settings.updateDatasetMetadataSettings(), clientContext);
        this.getDatasetCallable = callableFactory.createUnaryCallable(getDatasetTransportSettings, settings.getDatasetSettings(), clientContext);
        this.listDatasetsCallable = callableFactory.createUnaryCallable(listDatasetsTransportSettings, settings.listDatasetsSettings(), clientContext);
        this.listDatasetsPagedCallable = callableFactory.createPagedCallable(listDatasetsTransportSettings, settings.listDatasetsSettings(), clientContext);
        this.deleteDatasetCallable = callableFactory.createUnaryCallable(deleteDatasetTransportSettings, settings.deleteDatasetSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateDatasetRequest, Dataset> createDatasetCallable() {
        return this.createDatasetCallable;
    }

    @Override
    public UnaryCallable<UpdateDatasetMetadataRequest, Dataset> updateDatasetMetadataCallable() {
        return this.updateDatasetMetadataCallable;
    }

    @Override
    public UnaryCallable<GetDatasetRequest, Dataset> getDatasetCallable() {
        return this.getDatasetCallable;
    }

    @Override
    public UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> listDatasetsCallable() {
        return this.listDatasetsCallable;
    }

    @Override
    public UnaryCallable<ListDatasetsRequest, MapsPlatformDatasetsClient.ListDatasetsPagedResponse> listDatasetsPagedCallable() {
        return this.listDatasetsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteDatasetRequest, Empty> deleteDatasetCallable() {
        return this.deleteDatasetCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

