/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.mapsplatformdatasets.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.maps.mapsplatformdatasets.v1.CreateDatasetRequest;
import com.google.maps.mapsplatformdatasets.v1.Dataset;
import com.google.maps.mapsplatformdatasets.v1.DatasetName;
import com.google.maps.mapsplatformdatasets.v1.DeleteDatasetRequest;
import com.google.maps.mapsplatformdatasets.v1.GetDatasetRequest;
import com.google.maps.mapsplatformdatasets.v1.ListDatasetsRequest;
import com.google.maps.mapsplatformdatasets.v1.ListDatasetsResponse;
import com.google.maps.mapsplatformdatasets.v1.MapsPlatformDatasetsSettings;
import com.google.maps.mapsplatformdatasets.v1.ProjectName;
import com.google.maps.mapsplatformdatasets.v1.UpdateDatasetMetadataRequest;
import com.google.maps.mapsplatformdatasets.v1.stub.MapsPlatformDatasetsStub;
import com.google.maps.mapsplatformdatasets.v1.stub.MapsPlatformDatasetsStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class MapsPlatformDatasetsClient
implements BackgroundResource {
    private final MapsPlatformDatasetsSettings settings;
    private final MapsPlatformDatasetsStub stub;

    public static final MapsPlatformDatasetsClient create() throws IOException {
        return MapsPlatformDatasetsClient.create(MapsPlatformDatasetsSettings.newBuilder().build());
    }

    public static final MapsPlatformDatasetsClient create(MapsPlatformDatasetsSettings settings) throws IOException {
        return new MapsPlatformDatasetsClient(settings);
    }

    public static final MapsPlatformDatasetsClient create(MapsPlatformDatasetsStub stub) {
        return new MapsPlatformDatasetsClient(stub);
    }

    protected MapsPlatformDatasetsClient(MapsPlatformDatasetsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MapsPlatformDatasetsStubSettings)settings.getStubSettings()).createStub();
    }

    protected MapsPlatformDatasetsClient(MapsPlatformDatasetsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final MapsPlatformDatasetsSettings getSettings() {
        return this.settings;
    }

    public MapsPlatformDatasetsStub getStub() {
        return this.stub;
    }

    public final Dataset createDataset(ProjectName parent, Dataset dataset) {
        CreateDatasetRequest request = CreateDatasetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDataset(dataset).build();
        return this.createDataset(request);
    }

    public final Dataset createDataset(String parent, Dataset dataset) {
        CreateDatasetRequest request = CreateDatasetRequest.newBuilder().setParent(parent).setDataset(dataset).build();
        return this.createDataset(request);
    }

    public final Dataset createDataset(CreateDatasetRequest request) {
        return (Dataset)this.createDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDatasetRequest, Dataset> createDatasetCallable() {
        return this.stub.createDatasetCallable();
    }

    public final Dataset updateDatasetMetadata(Dataset dataset, FieldMask updateMask) {
        UpdateDatasetMetadataRequest request = UpdateDatasetMetadataRequest.newBuilder().setDataset(dataset).setUpdateMask(updateMask).build();
        return this.updateDatasetMetadata(request);
    }

    public final Dataset updateDatasetMetadata(UpdateDatasetMetadataRequest request) {
        return (Dataset)this.updateDatasetMetadataCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDatasetMetadataRequest, Dataset> updateDatasetMetadataCallable() {
        return this.stub.updateDatasetMetadataCallable();
    }

    public final Dataset getDataset(DatasetName name) {
        GetDatasetRequest request = GetDatasetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataset(request);
    }

    public final Dataset getDataset(String name) {
        GetDatasetRequest request = GetDatasetRequest.newBuilder().setName(name).build();
        return this.getDataset(request);
    }

    public final Dataset getDataset(GetDatasetRequest request) {
        return (Dataset)this.getDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<GetDatasetRequest, Dataset> getDatasetCallable() {
        return this.stub.getDatasetCallable();
    }

    public final ListDatasetsPagedResponse listDatasets(ProjectName parent) {
        ListDatasetsRequest request = ListDatasetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDatasets(request);
    }

    public final ListDatasetsPagedResponse listDatasets(String parent) {
        ListDatasetsRequest request = ListDatasetsRequest.newBuilder().setParent(parent).build();
        return this.listDatasets(request);
    }

    public final ListDatasetsPagedResponse listDatasets(ListDatasetsRequest request) {
        return (ListDatasetsPagedResponse)((Object)this.listDatasetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDatasetsRequest, ListDatasetsPagedResponse> listDatasetsPagedCallable() {
        return this.stub.listDatasetsPagedCallable();
    }

    public final UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> listDatasetsCallable() {
        return this.stub.listDatasetsCallable();
    }

    public final void deleteDataset(DatasetName name) {
        DeleteDatasetRequest request = DeleteDatasetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDataset(request);
    }

    public final void deleteDataset(String name) {
        DeleteDatasetRequest request = DeleteDatasetRequest.newBuilder().setName(name).build();
        this.deleteDataset(request);
    }

    public final void deleteDataset(DeleteDatasetRequest request) {
        this.deleteDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDatasetRequest, Empty> deleteDatasetCallable() {
        return this.stub.deleteDatasetCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDatasetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage, ListDatasetsFixedSizeCollection> {
        private ListDatasetsFixedSizeCollection(List<ListDatasetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDatasetsFixedSizeCollection createEmptyCollection() {
            return new ListDatasetsFixedSizeCollection(null, 0);
        }

        protected ListDatasetsFixedSizeCollection createCollection(List<ListDatasetsPage> pages, int collectionSize) {
            return new ListDatasetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDatasetsPage
    extends AbstractPage<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage> {
        private ListDatasetsPage(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ListDatasetsResponse response) {
            super(context, (Object)response);
        }

        private static ListDatasetsPage createEmptyPage() {
            return new ListDatasetsPage(null, null);
        }

        protected ListDatasetsPage createPage(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ListDatasetsResponse response) {
            return new ListDatasetsPage(context, response);
        }

        public ApiFuture<ListDatasetsPage> createPageAsync(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ApiFuture<ListDatasetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDatasetsPagedResponse
    extends AbstractPagedListResponse<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage, ListDatasetsFixedSizeCollection> {
        public static ApiFuture<ListDatasetsPagedResponse> createAsync(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ApiFuture<ListDatasetsResponse> futureResponse) {
            ApiFuture<ListDatasetsPage> futurePage = ListDatasetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDatasetsPagedResponse((ListDatasetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDatasetsPagedResponse(ListDatasetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDatasetsFixedSizeCollection.createEmptyCollection());
        }
    }
}

