/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.geometry;

import com.google.maps.android.geometry.Point;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J&\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0000J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/google/maps/android/geometry/Bounds;", "", "minX", "", "maxX", "minY", "maxY", "<init>", "(DDDD)V", "midX", "midY", "contains", "", "x", "y", "point", "Lcom/google/maps/android/geometry/Point;", "intersects", "bounds", "library_release"})
public final class Bounds {
    @JvmField
    public final double minX;
    @JvmField
    public final double maxX;
    @JvmField
    public final double minY;
    @JvmField
    public final double maxY;
    @JvmField
    public final double midX;
    @JvmField
    public final double midY;

    public Bounds(double minX, double maxX, double minY, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.midX = (this.minX + this.maxX) / (double)2;
        this.midY = (this.minY + this.maxY) / (double)2;
    }

    public final boolean contains(double x, double y) {
        return this.minX <= x && x <= this.maxX && this.minY <= y && y <= this.maxY;
    }

    public final boolean contains(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.contains(point.x, point.y);
    }

    public final boolean intersects(double minX, double maxX, double minY, double maxY) {
        return minX < this.maxX && this.minX < maxX && minY < this.maxY && this.minY < maxY;
    }

    public final boolean intersects(@NotNull Bounds bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return this.intersects(bounds.minX, bounds.maxX, bounds.minY, bounds.maxY);
    }

    public final boolean contains(@NotNull Bounds bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return bounds.minX >= this.minX && bounds.maxX <= this.maxX && bounds.minY >= this.minY && bounds.maxY <= this.maxY;
    }
}

