/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.heatmaps;

import android.graphics.Color;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0012\u0010\u0013\u001a\u00020\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/google/maps/android/heatmaps/Gradient;", "", "colors", "", "startPoints", "", "colorMapSize", "", "<init>", "([I[FI)V", "getColors", "()[I", "getStartPoints", "()[F", "getColorMapSize", "()I", "generateColorIntervals", "Ljava/util/HashMap;", "Lcom/google/maps/android/heatmaps/Gradient$ColorInterval;", "generateColorMap", "opacity", "", "ColorInterval", "Companion", "library_release"})
@SourceDebugExtension(value={"SMAP\nGradient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Gradient.kt\ncom/google/maps/android/heatmaps/Gradient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1#2:155\n*E\n"})
public final class Gradient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] colors;
    @NotNull
    private final float[] startPoints;
    private final int colorMapSize;
    private static final int DEFAULT_COLOR_MAP_SIZE = 1000;

    @JvmOverloads
    public Gradient(@NotNull int[] colors, @NotNull float[] startPoints, int colorMapSize) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)startPoints, (String)"startPoints");
        this.colors = colors;
        this.startPoints = startPoints;
        this.colorMapSize = colorMapSize;
        if (!(this.colors.length == this.startPoints.length)) {
            boolean $i$a$-require-Gradient$42 = false;
            String $i$a$-require-Gradient$42 = "colors and startPoints should be same length";
            throw new IllegalArgumentException($i$a$-require-Gradient$42.toString());
        }
        if (!(!(this.colors.length == 0))) {
            boolean bl = false;
            String string = "No colors have been defined";
            throw new IllegalArgumentException(string.toString());
        }
        int n = this.startPoints.length;
        for (int i = 1; i < n; ++i) {
            if (this.startPoints[i] > this.startPoints[i - 1]) continue;
            boolean bl = false;
            String string = "startPoints should be in increasing order";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Gradient(int[] nArray, float[] fArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 1000;
        }
        this(nArray, fArray, n);
    }

    @NotNull
    public final int[] getColors() {
        return this.colors;
    }

    @NotNull
    public final float[] getStartPoints() {
        return this.startPoints;
    }

    public final int getColorMapSize() {
        return this.colorMapSize;
    }

    private final HashMap<Integer, ColorInterval> generateColorIntervals() {
        int i;
        HashMap<Integer, ColorInterval> colorIntervals = new HashMap<Integer, ColorInterval>();
        if (!(this.startPoints[0] == 0.0f)) {
            int initialColor = Color.argb((int)0, (int)Color.red((int)this.colors[0]), (int)Color.green((int)this.colors[0]), (int)Color.blue((int)this.colors[0]));
            ((Map)colorIntervals).put(0, new ColorInterval(initialColor, this.colors[0], (float)this.colorMapSize * this.startPoints[0]));
        }
        int n = this.colors.length;
        for (i = 1; i < n; ++i) {
            int start = (int)((float)this.colorMapSize * this.startPoints[i - 1]);
            float duration = (float)this.colorMapSize * (this.startPoints[i] - this.startPoints[i - 1]);
            ((Map)colorIntervals).put(start, new ColorInterval(this.colors[i - 1], this.colors[i], duration));
        }
        if (!(ArraysKt.last((float[])this.startPoints) == 1.0f)) {
            i = this.startPoints.length - 1;
            int start = (int)((float)this.colorMapSize * this.startPoints[i]);
            ((Map)colorIntervals).put(start, new ColorInterval(this.colors[i], this.colors[i], (float)this.colorMapSize * (1.0f - this.startPoints[i])));
        }
        return colorIntervals;
    }

    @JvmOverloads
    @NotNull
    public final int[] generateColorMap(double opacity) {
        int i;
        HashMap<Integer, ColorInterval> colorIntervals = this.generateColorIntervals();
        int[] colorMap = new int[this.colorMapSize];
        ColorInterval interval = colorIntervals.get(0);
        int start = 0;
        int n = this.colorMapSize;
        for (i = 0; i < n; ++i) {
            if (colorIntervals.containsKey(i)) {
                interval = colorIntervals.get(i);
                start = i;
            }
            float f = i - start;
            ColorInterval colorInterval = interval;
            Intrinsics.checkNotNull((Object)colorInterval);
            float ratio = f / colorInterval.getDuration();
            colorMap[i] = Companion.interpolateColor(interval.getColor1(), interval.getColor2(), ratio);
        }
        if (!(opacity == 1.0)) {
            n = this.colorMapSize;
            for (i = 0; i < n; ++i) {
                int c = colorMap[i];
                colorMap[i] = Color.argb((int)((int)((double)Color.alpha((int)c) * opacity)), (int)Color.red((int)c), (int)Color.green((int)c), (int)Color.blue((int)c));
            }
        }
        return colorMap;
    }

    public static /* synthetic */ int[] generateColorMap$default(Gradient gradient, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.7;
        }
        return gradient.generateColorMap(d);
    }

    @JvmOverloads
    public Gradient(@NotNull int[] colors, @NotNull float[] startPoints) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)startPoints, (String)"startPoints");
        this(colors, startPoints, 0, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final int[] generateColorMap() {
        return Gradient.generateColorMap$default(this, 0.0, 1, null);
    }

    @JvmStatic
    public static final int interpolateColor(int color1, int color2, float ratio) {
        return Companion.interpolateColor(color1, color2, ratio);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/google/maps/android/heatmaps/Gradient$ColorInterval;", "", "color1", "", "color2", "duration", "", "<init>", "(IIF)V", "getColor1", "()I", "getColor2", "getDuration", "()F", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "library_release"})
    private static final class ColorInterval {
        private final int color1;
        private final int color2;
        private final float duration;

        public ColorInterval(int color1, int color2, float duration) {
            this.color1 = color1;
            this.color2 = color2;
            this.duration = duration;
        }

        public final int getColor1() {
            return this.color1;
        }

        public final int getColor2() {
            return this.color2;
        }

        public final float getDuration() {
            return this.duration;
        }

        public final int component1() {
            return this.color1;
        }

        public final int component2() {
            return this.color2;
        }

        public final float component3() {
            return this.duration;
        }

        @NotNull
        public final ColorInterval copy(int color1, int color2, float duration) {
            return new ColorInterval(color1, color2, duration);
        }

        public static /* synthetic */ ColorInterval copy$default(ColorInterval colorInterval, int n, int n2, float f, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = colorInterval.color1;
            }
            if ((n3 & 2) != 0) {
                n2 = colorInterval.color2;
            }
            if ((n3 & 4) != 0) {
                f = colorInterval.duration;
            }
            return colorInterval.copy(n, n2, f);
        }

        @NotNull
        public String toString() {
            return "ColorInterval(color1=" + this.color1 + ", color2=" + this.color2 + ", duration=" + this.duration + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.color1);
            result = result * 31 + Integer.hashCode(this.color2);
            result = result * 31 + Float.hashCode(this.duration);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ColorInterval)) {
                return false;
            }
            ColorInterval colorInterval = (ColorInterval)other;
            if (this.color1 != colorInterval.color1) {
                return false;
            }
            if (this.color2 != colorInterval.color2) {
                return false;
            }
            return Float.compare(this.duration, colorInterval.duration) == 0;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/google/maps/android/heatmaps/Gradient$Companion;", "", "<init>", "()V", "DEFAULT_COLOR_MAP_SIZE", "", "interpolateColor", "color1", "color2", "ratio", "", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final int interpolateColor(int color1, int color2, float ratio) {
            int alpha = (int)((float)(Color.alpha((int)color2) - Color.alpha((int)color1)) * ratio + (float)Color.alpha((int)color1));
            float[] hsv1 = new float[3];
            Color.RGBToHSV((int)Color.red((int)color1), (int)Color.green((int)color1), (int)Color.blue((int)color1), (float[])hsv1);
            float[] hsv2 = new float[3];
            Color.RGBToHSV((int)Color.red((int)color2), (int)Color.green((int)color2), (int)Color.blue((int)color2), (float[])hsv2);
            if (hsv1[0] - hsv2[0] > 180.0f) {
                hsv2[0] = hsv2[0] + 360.0f;
            } else if (hsv2[0] - hsv1[0] > 180.0f) {
                hsv1[0] = hsv1[0] + 360.0f;
            }
            float[] result = new float[3];
            for (int i = 0; i < 3; ++i) {
                result[i] = (hsv2[i] - hsv1[i]) * ratio + hsv1[i];
            }
            return Color.HSVToColor((int)alpha, (float[])result);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

