/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.data.geojson;

import androidx.annotation.NonNull;
import com.google.android.gms.maps.model.Cap;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.PolylineOptions;
import com.google.maps.android.data.Style;
import com.google.maps.android.data.geojson.GeoJsonStyle;
import java.util.Arrays;
import java.util.List;

public class GeoJsonLineStringStyle
extends Style
implements GeoJsonStyle {
    private static final String[] GEOMETRY_TYPE = new String[]{"LineString", "MultiLineString", "GeometryCollection"};

    public GeoJsonLineStringStyle() {
        this.mPolylineOptions = new PolylineOptions();
        this.mPolylineOptions.clickable(true);
    }

    @Override
    public String[] getGeometryType() {
        return GEOMETRY_TYPE;
    }

    public int getColor() {
        return this.mPolylineOptions.getColor();
    }

    public void setColor(int color) {
        this.mPolylineOptions.color(color);
        this.styleChanged();
    }

    public boolean isClickable() {
        return this.mPolylineOptions.isClickable();
    }

    public void setClickable(boolean clickable) {
        this.mPolylineOptions.clickable(clickable);
        this.styleChanged();
    }

    public boolean isGeodesic() {
        return this.mPolylineOptions.isGeodesic();
    }

    public void setGeodesic(boolean geodesic) {
        this.mPolylineOptions.geodesic(geodesic);
        this.styleChanged();
    }

    public float getWidth() {
        return this.mPolylineOptions.getWidth();
    }

    public void setWidth(float width) {
        this.setLineStringWidth(width);
        this.styleChanged();
    }

    public float getZIndex() {
        return this.mPolylineOptions.getZIndex();
    }

    public void setZIndex(float zIndex) {
        this.mPolylineOptions.zIndex(zIndex);
        this.styleChanged();
    }

    @Override
    public boolean isVisible() {
        return this.mPolylineOptions.isVisible();
    }

    @Override
    public void setVisible(boolean visible) {
        this.mPolylineOptions.visible(visible);
        this.styleChanged();
    }

    private void styleChanged() {
        this.setChanged();
        this.notifyObservers();
    }

    public PolylineOptions toPolylineOptions() {
        PolylineOptions polylineOptions = new PolylineOptions();
        polylineOptions.color(this.mPolylineOptions.getColor());
        polylineOptions.clickable(this.mPolylineOptions.isClickable());
        polylineOptions.geodesic(this.mPolylineOptions.isGeodesic());
        polylineOptions.visible(this.mPolylineOptions.isVisible());
        polylineOptions.width(this.mPolylineOptions.getWidth());
        polylineOptions.zIndex(this.mPolylineOptions.getZIndex());
        polylineOptions.pattern(this.getPattern());
        polylineOptions.startCap(this.getStartCap());
        polylineOptions.endCap(this.getEndCap());
        return polylineOptions;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder("LineStringStyle{");
        sb.append("\n geometry type=").append(Arrays.toString(GEOMETRY_TYPE));
        sb.append(",\n color=").append(this.getColor());
        sb.append(",\n clickable=").append(this.isClickable());
        sb.append(",\n geodesic=").append(this.isGeodesic());
        sb.append(",\n visible=").append(this.isVisible());
        sb.append(",\n width=").append(this.getWidth());
        sb.append(",\n z index=").append(this.getZIndex());
        sb.append(",\n pattern=").append(this.getPattern());
        sb.append(",\n startCap=").append(this.getStartCap());
        sb.append(",\n endCap=").append(this.getEndCap());
        sb.append("\n}\n");
        return sb.toString();
    }

    public List<PatternItem> getPattern() {
        return this.mPolylineOptions.getPattern();
    }

    public void setPattern(List<PatternItem> pattern) {
        this.mPolylineOptions.pattern(pattern);
        this.styleChanged();
    }

    public void setStartCap(@NonNull Cap cap) {
        this.mPolylineOptions.startCap(cap);
        this.styleChanged();
    }

    public void setEndCap(@NonNull Cap cap) {
        this.mPolylineOptions.endCap(cap);
        this.styleChanged();
    }

    public Cap getStartCap() {
        return this.mPolylineOptions.getStartCap();
    }

    public Cap getEndCap() {
        return this.mPolylineOptions.getEndCap();
    }
}

