/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.clustering.algo;

import com.google.android.gms.maps.model.LatLng;
import com.google.maps.android.clustering.Cluster;
import com.google.maps.android.clustering.ClusterItem;
import com.google.maps.android.clustering.algo.CentroidNonHierarchicalDistanceBasedAlgorithm;
import com.google.maps.android.clustering.algo.NonHierarchicalDistanceBasedAlgorithm;
import com.google.maps.android.clustering.algo.StaticCluster;
import com.google.maps.android.geometry.Bounds;
import com.google.maps.android.quadtree.PointQuadTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ContinuousZoomEuclideanCentroidAlgorithm<T extends ClusterItem>
extends CentroidNonHierarchicalDistanceBasedAlgorithm<T> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<? extends Cluster<T>> getClusters(float zoom) {
        double zoomSpecificSpan = (double)this.getMaxDistanceBetweenClusteredItems() / Math.pow(2.0, zoom) / 256.0;
        HashSet<NonHierarchicalDistanceBasedAlgorithm.QuadItem<Object>> visitedCandidates = new HashSet<NonHierarchicalDistanceBasedAlgorithm.QuadItem<Object>>();
        HashSet results = new HashSet();
        HashMap<NonHierarchicalDistanceBasedAlgorithm.QuadItem, Double> distanceToCluster = new HashMap<NonHierarchicalDistanceBasedAlgorithm.QuadItem, Double>();
        HashMap itemToCluster = new HashMap();
        PointQuadTree pointQuadTree = this.mQuadTree;
        synchronized (pointQuadTree) {
            for (NonHierarchicalDistanceBasedAlgorithm.QuadItem quadItem : this.getClusteringItems(this.mQuadTree, zoom)) {
                Object clusterItem22;
                if (visitedCandidates.contains(quadItem)) continue;
                Bounds searchBounds = this.createBoundsFromSpan(quadItem.getPoint(), zoomSpecificSpan);
                ArrayList<Object> clusterItems = new ArrayList<Object>();
                for (Object clusterItem22 : this.mQuadTree.search(searchBounds)) {
                    double radiusSquared;
                    double distance = this.distanceSquared(((NonHierarchicalDistanceBasedAlgorithm.QuadItem)clusterItem22).getPoint(), quadItem.getPoint());
                    if (!(distance < (radiusSquared = Math.pow(zoomSpecificSpan / 2.0, 2.0)))) continue;
                    clusterItems.add(clusterItem22);
                }
                if (clusterItems.size() == 1) {
                    results.add(quadItem);
                    visitedCandidates.add(quadItem);
                    distanceToCluster.put(quadItem, 0.0);
                    continue;
                }
                StaticCluster cluster = new StaticCluster(quadItem.mClusterItem.getPosition());
                results.add(cluster);
                clusterItem22 = clusterItems.iterator();
                while (clusterItem22.hasNext()) {
                    NonHierarchicalDistanceBasedAlgorithm.QuadItem clusterItem3 = (NonHierarchicalDistanceBasedAlgorithm.QuadItem)clusterItem22.next();
                    Double existingDistance = (Double)distanceToCluster.get(clusterItem3);
                    double distance = this.distanceSquared(clusterItem3.getPoint(), quadItem.getPoint());
                    if (existingDistance != null) {
                        if (existingDistance < distance) continue;
                        ((StaticCluster)itemToCluster.get(clusterItem3)).remove(clusterItem3.mClusterItem);
                    }
                    distanceToCluster.put(clusterItem3, distance);
                    cluster.add(clusterItem3.mClusterItem);
                    itemToCluster.put(clusterItem3, cluster);
                }
                visitedCandidates.addAll(clusterItems);
            }
        }
        HashSet newClusters = new HashSet();
        for (Cluster cluster : results) {
            LatLng centroid = this.computeCentroid(cluster.getItems());
            StaticCluster<ClusterItem> newCluster = new StaticCluster<ClusterItem>(centroid);
            for (ClusterItem item : cluster.getItems()) {
                newCluster.add(item);
            }
            newClusters.add(newCluster);
        }
        return newClusters;
    }
}

