/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.collections;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.google.android.gms.maps.GoogleMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

abstract class MapObjectManager<O, C extends Collection> {
    protected final GoogleMap mMap;
    private final Map<String, C> mNamedCollections = new HashMap<String, C>();
    protected final Map<O, C> mAllObjects = new HashMap<O, C>();

    public MapObjectManager(@NonNull GoogleMap map) {
        this.mMap = map;
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                MapObjectManager.this.setListenersOnUiThread();
            }
        });
    }

    abstract void setListenersOnUiThread();

    public abstract C newCollection();

    public C newCollection(String id2) {
        if (this.mNamedCollections.get(id2) != null) {
            throw new IllegalArgumentException("collection id is not unique: " + id2);
        }
        C collection = this.newCollection();
        this.mNamedCollections.put(id2, collection);
        return collection;
    }

    public C getCollection(String id2) {
        return (C)((Collection)this.mNamedCollections.get(id2));
    }

    public boolean remove(O object) {
        Collection collection = (Collection)this.mAllObjects.get(object);
        return collection != null && collection.remove(object);
    }

    protected abstract void removeObjectFromMap(O var1);

    public class Collection {
        private final Set<O> mObjects = new LinkedHashSet();

        protected void add(O object) {
            this.mObjects.add(object);
            MapObjectManager.this.mAllObjects.put(object, this);
        }

        protected boolean remove(O object) {
            if (this.mObjects.remove(object)) {
                MapObjectManager.this.mAllObjects.remove(object);
                MapObjectManager.this.removeObjectFromMap(object);
                return true;
            }
            return false;
        }

        public void clear() {
            for (Object object : this.mObjects) {
                MapObjectManager.this.removeObjectFromMap(object);
                MapObjectManager.this.mAllObjects.remove(object);
            }
            this.mObjects.clear();
        }

        protected java.util.Collection<O> getObjects() {
            return Collections.unmodifiableCollection(this.mObjects);
        }
    }
}

