/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.data;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import androidx.collection.LruCache;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.GroundOverlay;
import com.google.android.gms.maps.model.GroundOverlayOptions;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.PolylineOptions;
import com.google.maps.android.R;
import com.google.maps.android.data.DataPolygon;
import com.google.maps.android.data.Feature;
import com.google.maps.android.data.Geometry;
import com.google.maps.android.data.LineString;
import com.google.maps.android.data.Point;
import com.google.maps.android.data.geojson.BiMultiMap;
import com.google.maps.android.data.geojson.GeoJsonFeature;
import com.google.maps.android.data.geojson.GeoJsonGeometryCollection;
import com.google.maps.android.data.geojson.GeoJsonLineString;
import com.google.maps.android.data.geojson.GeoJsonLineStringStyle;
import com.google.maps.android.data.geojson.GeoJsonMultiLineString;
import com.google.maps.android.data.geojson.GeoJsonMultiPoint;
import com.google.maps.android.data.geojson.GeoJsonMultiPolygon;
import com.google.maps.android.data.geojson.GeoJsonPoint;
import com.google.maps.android.data.geojson.GeoJsonPointStyle;
import com.google.maps.android.data.geojson.GeoJsonPolygon;
import com.google.maps.android.data.geojson.GeoJsonPolygonStyle;
import com.google.maps.android.data.kml.KmlContainer;
import com.google.maps.android.data.kml.KmlGroundOverlay;
import com.google.maps.android.data.kml.KmlMultiGeometry;
import com.google.maps.android.data.kml.KmlPlacemark;
import com.google.maps.android.data.kml.KmlPoint;
import com.google.maps.android.data.kml.KmlStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Renderer {
    private static final Object FEATURE_NOT_ON_MAP = null;
    private static final int LRU_CACHE_SIZE = 50;
    private GoogleMap mMap;
    private final BiMultiMap<Feature> mFeatures = new BiMultiMap();
    private HashMap<String, KmlStyle> mStyles;
    private HashMap<String, KmlStyle> mStylesRenderer;
    private HashMap<String, String> mStyleMaps;
    private BiMultiMap<Feature> mContainerFeatures;
    private HashMap<KmlGroundOverlay, GroundOverlay> mGroundOverlays;
    private final ArrayList<String> mMarkerIconUrls;
    private final LruCache<String, Bitmap> mImagesCache;
    private boolean mLayerOnMap;
    private Context mContext;
    private ArrayList<KmlContainer> mContainers;
    private final GeoJsonPointStyle mDefaultPointStyle;
    private final GeoJsonLineStringStyle mDefaultLineStringStyle;
    private final GeoJsonPolygonStyle mDefaultPolygonStyle;

    public Renderer(GoogleMap map, Context context) {
        this.mMap = map;
        this.mContext = context;
        this.mLayerOnMap = false;
        this.mImagesCache = new LruCache(50);
        this.mMarkerIconUrls = new ArrayList();
        this.mStylesRenderer = new HashMap();
        this.mDefaultPointStyle = null;
        this.mDefaultLineStringStyle = null;
        this.mDefaultPolygonStyle = null;
        this.mContainerFeatures = new BiMultiMap();
    }

    public Renderer(GoogleMap map, HashMap<? extends Feature, Object> features) {
        this.mMap = map;
        this.mFeatures.putAll((Map<Feature, ?>)features);
        this.mLayerOnMap = false;
        this.mMarkerIconUrls = null;
        this.mDefaultPointStyle = new GeoJsonPointStyle();
        this.mDefaultLineStringStyle = new GeoJsonLineStringStyle();
        this.mDefaultPolygonStyle = new GeoJsonPolygonStyle();
        this.mImagesCache = null;
        this.mContainerFeatures = null;
    }

    public boolean isLayerOnMap() {
        return this.mLayerOnMap;
    }

    protected void setLayerVisibility(boolean layerOnMap) {
        this.mLayerOnMap = layerOnMap;
    }

    public GoogleMap getMap() {
        return this.mMap;
    }

    public void setMap(GoogleMap map) {
        this.mMap = map;
    }

    protected void putContainerFeature(Object mapObject, Feature placemark) {
        this.mContainerFeatures.put(placemark, mapObject);
    }

    public Set<Feature> getFeatures() {
        return this.mFeatures.keySet();
    }

    public Feature getFeature(Object mapObject) {
        return this.mFeatures.getKey(mapObject);
    }

    public Feature getContainerFeature(Object mapObject) {
        if (this.mContainerFeatures != null) {
            return this.mContainerFeatures.getKey(mapObject);
        }
        return null;
    }

    public Collection<Object> getValues() {
        return this.mFeatures.values();
    }

    protected HashMap<? extends Feature, Object> getAllFeatures() {
        return this.mFeatures;
    }

    public ArrayList<String> getMarkerIconUrls() {
        return this.mMarkerIconUrls;
    }

    public HashMap<String, KmlStyle> getStylesRenderer() {
        return this.mStylesRenderer;
    }

    public HashMap<String, String> getStyleMaps() {
        return this.mStyleMaps;
    }

    public LruCache<String, Bitmap> getImagesCache() {
        return this.mImagesCache;
    }

    public HashMap<KmlGroundOverlay, GroundOverlay> getGroundOverlayMap() {
        return this.mGroundOverlays;
    }

    public ArrayList<KmlContainer> getContainerList() {
        return this.mContainers;
    }

    protected KmlStyle getPlacemarkStyle(String styleId) {
        KmlStyle style2 = this.mStylesRenderer.get(null);
        if (this.mStylesRenderer.get(styleId) != null) {
            style2 = this.mStylesRenderer.get(styleId);
        }
        return style2;
    }

    public GeoJsonPointStyle getDefaultPointStyle() {
        return this.mDefaultPointStyle;
    }

    public GeoJsonLineStringStyle getDefaultLineStringStyle() {
        return this.mDefaultLineStringStyle;
    }

    public GeoJsonPolygonStyle getDefaultPolygonStyle() {
        return this.mDefaultPolygonStyle;
    }

    public void putFeatures(Feature feature, Object object) {
        this.mFeatures.put(feature, object);
    }

    public void putStyles() {
        this.mStylesRenderer.putAll(this.mStyles);
    }

    public void putStyles(HashMap<String, KmlStyle> styles) {
        this.mStylesRenderer.putAll(styles);
    }

    public void putImagesCache(String groundOverlayUrl, Bitmap bitmap) {
        this.mImagesCache.put((Object)groundOverlayUrl, (Object)bitmap);
    }

    public boolean hasFeatures() {
        return this.mFeatures.size() > 0;
    }

    protected static void removeFeatures(HashMap<Feature, Object> features) {
        for (Object mapObject : features.values()) {
            if (mapObject instanceof Marker) {
                ((Marker)mapObject).remove();
                continue;
            }
            if (mapObject instanceof Polyline) {
                ((Polyline)mapObject).remove();
                continue;
            }
            if (!(mapObject instanceof Polygon)) continue;
            ((Polygon)mapObject).remove();
        }
    }

    protected void removeFeature(Feature feature) {
        if (this.mFeatures.containsKey(feature)) {
            Renderer.removeFromMap(this.mFeatures.remove(feature));
        }
    }

    private void setFeatureDefaultStyles(GeoJsonFeature feature) {
        if (feature.getPointStyle() == null) {
            feature.setPointStyle(this.mDefaultPointStyle);
        }
        if (feature.getLineStringStyle() == null) {
            feature.setLineStringStyle(this.mDefaultLineStringStyle);
        }
        if (feature.getPolygonStyle() == null) {
            feature.setPolygonStyle(this.mDefaultPolygonStyle);
        }
    }

    public void clearStylesRenderer() {
        this.mStylesRenderer.clear();
    }

    protected void storeData(HashMap<String, KmlStyle> styles, HashMap<String, String> styleMaps, HashMap<KmlPlacemark, Object> features, ArrayList<KmlContainer> folders, HashMap<KmlGroundOverlay, GroundOverlay> groundOverlays) {
        this.mStyles = styles;
        this.mStyleMaps = styleMaps;
        this.mFeatures.putAll((Map<Feature, ?>)features);
        this.mContainers = folders;
        this.mGroundOverlays = groundOverlays;
    }

    public void addFeature(Feature feature) {
        Object mapObject = FEATURE_NOT_ON_MAP;
        if (feature instanceof GeoJsonFeature) {
            this.setFeatureDefaultStyles((GeoJsonFeature)feature);
        }
        if (this.mLayerOnMap) {
            if (this.mFeatures.containsKey(feature)) {
                Renderer.removeFromMap(this.mFeatures.get(feature));
            }
            if (feature.hasGeometry()) {
                if (feature instanceof KmlPlacemark) {
                    boolean isPlacemarkVisible = Renderer.getPlacemarkVisibility(feature);
                    String placemarkId = feature.getId();
                    Geometry geometry = feature.getGeometry();
                    KmlStyle style2 = this.getPlacemarkStyle(placemarkId);
                    KmlStyle inlineStyle = ((KmlPlacemark)feature).getInlineStyle();
                    mapObject = this.addKmlPlacemarkToMap((KmlPlacemark)feature, geometry, style2, inlineStyle, isPlacemarkVisible);
                } else {
                    mapObject = this.addGeoJsonFeatureToMap(feature, feature.getGeometry());
                }
            }
        }
        this.mFeatures.put(feature, mapObject);
    }

    public static void removeFromMap(Object mapObject) {
        if (mapObject instanceof Marker) {
            ((Marker)mapObject).remove();
        } else if (mapObject instanceof Polyline) {
            ((Polyline)mapObject).remove();
        } else if (mapObject instanceof Polygon) {
            ((Polygon)mapObject).remove();
        } else if (mapObject instanceof ArrayList) {
            for (Object mapObjectElement : (ArrayList)mapObject) {
                Renderer.removeFromMap(mapObjectElement);
            }
        }
    }

    protected Object addGeoJsonFeatureToMap(Feature feature, Geometry geometry) {
        String geometryType;
        switch (geometryType = geometry.getGeometryType()) {
            case "Point": {
                MarkerOptions markerOptions = null;
                if (feature instanceof GeoJsonFeature) {
                    markerOptions = ((GeoJsonFeature)feature).getMarkerOptions();
                } else if (feature instanceof KmlPlacemark) {
                    markerOptions = ((KmlPlacemark)feature).getMarkerOptions();
                }
                return this.addPointToMap(markerOptions, (GeoJsonPoint)geometry);
            }
            case "LineString": {
                PolylineOptions polylineOptions = null;
                if (feature instanceof GeoJsonFeature) {
                    polylineOptions = ((GeoJsonFeature)feature).getPolylineOptions();
                } else if (feature instanceof KmlPlacemark) {
                    polylineOptions = ((KmlPlacemark)feature).getPolylineOptions();
                }
                return this.addLineStringToMap(polylineOptions, (GeoJsonLineString)geometry);
            }
            case "Polygon": {
                PolygonOptions polygonOptions = null;
                if (feature instanceof GeoJsonFeature) {
                    polygonOptions = ((GeoJsonFeature)feature).getPolygonOptions();
                } else if (feature instanceof KmlPlacemark) {
                    polygonOptions = ((KmlPlacemark)feature).getPolygonOptions();
                }
                return this.addPolygonToMap(polygonOptions, (DataPolygon)geometry);
            }
            case "MultiPoint": {
                return this.addMultiPointToMap(((GeoJsonFeature)feature).getPointStyle(), (GeoJsonMultiPoint)geometry);
            }
            case "MultiLineString": {
                return this.addMultiLineStringToMap(((GeoJsonFeature)feature).getLineStringStyle(), (GeoJsonMultiLineString)geometry);
            }
            case "MultiPolygon": {
                return this.addMultiPolygonToMap(((GeoJsonFeature)feature).getPolygonStyle(), (GeoJsonMultiPolygon)geometry);
            }
            case "GeometryCollection": {
                return this.addGeometryCollectionToMap((GeoJsonFeature)feature, ((GeoJsonGeometryCollection)geometry).getGeometries());
            }
        }
        return null;
    }

    protected Object addKmlPlacemarkToMap(KmlPlacemark placemark, Geometry geometry, KmlStyle style2, KmlStyle inlineStyle, boolean isVisible) {
        String geometryType = geometry.getGeometryType();
        boolean hasDrawOrder = placemark.hasProperty("drawOrder");
        float drawOrder = 0.0f;
        if (hasDrawOrder) {
            try {
                drawOrder = Float.parseFloat(placemark.getProperty("drawOrder"));
            }
            catch (NumberFormatException e) {
                hasDrawOrder = false;
            }
        }
        switch (geometryType) {
            case "Point": {
                MarkerOptions markerOptions = style2.getMarkerOptions();
                if (inlineStyle != null) {
                    this.setInlinePointStyle(markerOptions, inlineStyle, style2.getIconUrl());
                } else if (style2.getIconUrl() != null) {
                    this.addMarkerIcons(style2.getIconUrl(), markerOptions);
                }
                Marker marker = this.addPointToMap(markerOptions, (KmlPoint)geometry);
                marker.setVisible(isVisible);
                this.setMarkerInfoWindow(style2, marker, placemark);
                if (hasDrawOrder) {
                    marker.setZIndex(drawOrder);
                }
                return marker;
            }
            case "LineString": {
                PolylineOptions polylineOptions = style2.getPolylineOptions();
                if (inlineStyle != null) {
                    this.setInlineLineStringStyle(polylineOptions, inlineStyle);
                } else if (style2.isLineRandomColorMode()) {
                    polylineOptions.color(KmlStyle.computeRandomColor(polylineOptions.getColor()));
                }
                Polyline polyline = this.addLineStringToMap(polylineOptions, (LineString)geometry);
                polyline.setVisible(isVisible);
                if (hasDrawOrder) {
                    polyline.setZIndex(drawOrder);
                }
                return polyline;
            }
            case "Polygon": {
                PolygonOptions polygonOptions = style2.getPolygonOptions();
                if (inlineStyle != null) {
                    this.setInlinePolygonStyle(polygonOptions, inlineStyle);
                } else if (style2.isPolyRandomColorMode()) {
                    polygonOptions.fillColor(KmlStyle.computeRandomColor(polygonOptions.getFillColor()));
                }
                Polygon polygon = this.addPolygonToMap(polygonOptions, (DataPolygon)geometry);
                polygon.setVisible(isVisible);
                if (hasDrawOrder) {
                    polygon.setZIndex(drawOrder);
                }
                return polygon;
            }
            case "MultiGeometry": {
                return this.addMultiGeometryToMap(placemark, (KmlMultiGeometry)geometry, style2, inlineStyle, isVisible);
            }
        }
        return null;
    }

    protected Marker addPointToMap(MarkerOptions markerOptions, Point point) {
        markerOptions.position(point.getGeometryObject());
        return this.mMap.addMarker(markerOptions);
    }

    private void setInlinePointStyle(MarkerOptions markerOptions, KmlStyle inlineStyle, String markerUrlIconUrl) {
        MarkerOptions inlineMarkerOptions = inlineStyle.getMarkerOptions();
        if (inlineStyle.isStyleSet("heading")) {
            markerOptions.rotation(inlineMarkerOptions.getRotation());
        }
        if (inlineStyle.isStyleSet("hotSpot")) {
            markerOptions.anchor(inlineMarkerOptions.getAnchorU(), inlineMarkerOptions.getAnchorV());
        }
        if (inlineStyle.isStyleSet("markerColor")) {
            markerOptions.icon(inlineMarkerOptions.getIcon());
        }
        if (inlineStyle.isStyleSet("iconUrl")) {
            this.addMarkerIcons(inlineStyle.getIconUrl(), markerOptions);
        } else if (markerUrlIconUrl != null) {
            this.addMarkerIcons(markerUrlIconUrl, markerOptions);
        }
    }

    protected Polyline addLineStringToMap(PolylineOptions polylineOptions, LineString lineString) {
        polylineOptions.addAll((Iterable)lineString.getGeometryObject());
        Polyline addedPolyline = this.mMap.addPolyline(polylineOptions);
        addedPolyline.setClickable(true);
        return addedPolyline;
    }

    private void setInlineLineStringStyle(PolylineOptions polylineOptions, KmlStyle inlineStyle) {
        PolylineOptions inlinePolylineOptions = inlineStyle.getPolylineOptions();
        if (inlineStyle.isStyleSet("outlineColor")) {
            polylineOptions.color(inlinePolylineOptions.getColor());
        }
        if (inlineStyle.isStyleSet("width")) {
            polylineOptions.width(inlinePolylineOptions.getWidth());
        }
        if (inlineStyle.isLineRandomColorMode()) {
            polylineOptions.color(KmlStyle.computeRandomColor(inlinePolylineOptions.getColor()));
        }
    }

    protected Polygon addPolygonToMap(PolygonOptions polygonOptions, DataPolygon polygon) {
        polygonOptions.addAll(polygon.getOuterBoundaryCoordinates());
        List<List<LatLng>> innerBoundaries = polygon.getInnerBoundaryCoordinates();
        for (List<LatLng> innerBoundary : innerBoundaries) {
            polygonOptions.addHole(innerBoundary);
        }
        Polygon addedPolygon = this.mMap.addPolygon(polygonOptions);
        addedPolygon.setClickable(polygonOptions.isClickable());
        return addedPolygon;
    }

    private void setInlinePolygonStyle(PolygonOptions polygonOptions, KmlStyle inlineStyle) {
        PolygonOptions inlinePolygonOptions = inlineStyle.getPolygonOptions();
        if (inlineStyle.hasFill() && inlineStyle.isStyleSet("fillColor")) {
            polygonOptions.fillColor(inlinePolygonOptions.getFillColor());
        }
        if (inlineStyle.hasOutline()) {
            if (inlineStyle.isStyleSet("outlineColor")) {
                polygonOptions.strokeColor(inlinePolygonOptions.getStrokeColor());
            }
            if (inlineStyle.isStyleSet("width")) {
                polygonOptions.strokeWidth(inlinePolygonOptions.getStrokeWidth());
            }
        }
        if (inlineStyle.isPolyRandomColorMode()) {
            polygonOptions.fillColor(KmlStyle.computeRandomColor(inlinePolygonOptions.getFillColor()));
        }
    }

    private ArrayList<Object> addGeometryCollectionToMap(GeoJsonFeature feature, List<Geometry> geoJsonGeometries) {
        ArrayList<Object> geometries = new ArrayList<Object>();
        for (Geometry geometry : geoJsonGeometries) {
            geometries.add(this.addGeoJsonFeatureToMap(feature, geometry));
        }
        return geometries;
    }

    protected static boolean getPlacemarkVisibility(Feature feature) {
        String placemarkVisibility;
        boolean isFeatureVisible = true;
        if (feature.hasProperty("visibility") && Integer.parseInt(placemarkVisibility = feature.getProperty("visibility")) == 0) {
            isFeatureVisible = false;
        }
        return isFeatureVisible;
    }

    public void assignStyleMap(HashMap<String, String> styleMap, HashMap<String, KmlStyle> styles) {
        for (String styleMapKey : styleMap.keySet()) {
            String styleMapValue = styleMap.get(styleMapKey);
            if (!styles.containsKey(styleMapValue)) continue;
            styles.put(styleMapKey, styles.get(styleMapValue));
        }
    }

    private ArrayList<Object> addMultiGeometryToMap(KmlPlacemark placemark, KmlMultiGeometry multiGeometry, KmlStyle urlStyle, KmlStyle inlineStyle, boolean isContainerVisible) {
        ArrayList<Object> mapObjects = new ArrayList<Object>();
        List kmlObjects = multiGeometry.getGeometryObject();
        for (Geometry kmlGeometry : kmlObjects) {
            mapObjects.add(this.addKmlPlacemarkToMap(placemark, kmlGeometry, urlStyle, inlineStyle, isContainerVisible));
        }
        return mapObjects;
    }

    private ArrayList<Marker> addMultiPointToMap(GeoJsonPointStyle pointStyle, GeoJsonMultiPoint multiPoint) {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        for (GeoJsonPoint geoJsonPoint : multiPoint.getPoints()) {
            markers.add(this.addPointToMap(pointStyle.toMarkerOptions(), geoJsonPoint));
        }
        return markers;
    }

    private ArrayList<Polyline> addMultiLineStringToMap(GeoJsonLineStringStyle lineStringStyle, GeoJsonMultiLineString multiLineString) {
        ArrayList<Polyline> polylines = new ArrayList<Polyline>();
        for (GeoJsonLineString geoJsonLineString : multiLineString.getLineStrings()) {
            polylines.add(this.addLineStringToMap(lineStringStyle.toPolylineOptions(), geoJsonLineString));
        }
        return polylines;
    }

    private ArrayList<Polygon> addMultiPolygonToMap(GeoJsonPolygonStyle polygonStyle, GeoJsonMultiPolygon multiPolygon) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (GeoJsonPolygon geoJsonPolygon : multiPolygon.getPolygons()) {
            polygons.add(this.addPolygonToMap(polygonStyle.toPolygonOptions(), geoJsonPolygon));
        }
        return polygons;
    }

    private void addMarkerIcons(String styleUrl, MarkerOptions markerOptions) {
        if (this.mImagesCache.get((Object)styleUrl) != null) {
            Bitmap bitmap = (Bitmap)this.mImagesCache.get((Object)styleUrl);
            markerOptions.icon(BitmapDescriptorFactory.fromBitmap((Bitmap)bitmap));
        } else if (!this.mMarkerIconUrls.contains(styleUrl)) {
            this.mMarkerIconUrls.add(styleUrl);
        }
    }

    public GroundOverlay attachGroundOverlay(GroundOverlayOptions groundOverlayOptions) {
        return this.mMap.addGroundOverlay(groundOverlayOptions);
    }

    private void setMarkerInfoWindow(KmlStyle style2, Marker marker, KmlPlacemark placemark) {
        boolean hasName = placemark.hasProperty("name");
        boolean hasDescription = placemark.hasProperty("description");
        boolean hasBalloonOptions = style2.hasBalloonStyle();
        boolean hasBalloonText = style2.getBalloonOptions().containsKey("text");
        if (hasBalloonOptions && hasBalloonText) {
            marker.setTitle(style2.getBalloonOptions().get("text"));
            this.createInfoWindow();
        } else if (hasBalloonOptions && hasName) {
            marker.setTitle(placemark.getProperty("name"));
            this.createInfoWindow();
        } else if (hasName && hasDescription) {
            marker.setTitle(placemark.getProperty("name"));
            marker.setSnippet(placemark.getProperty("description"));
            this.createInfoWindow();
        } else if (hasDescription) {
            marker.setTitle(placemark.getProperty("description"));
            this.createInfoWindow();
        } else if (hasName) {
            marker.setTitle(placemark.getProperty("name"));
            this.createInfoWindow();
        }
    }

    private void createInfoWindow() {
        this.mMap.setInfoWindowAdapter(new GoogleMap.InfoWindowAdapter(){

            public View getInfoWindow(Marker arg0) {
                return null;
            }

            public View getInfoContents(Marker arg0) {
                View view = LayoutInflater.from((Context)Renderer.this.mContext).inflate(R.layout.amu_info_window, null);
                TextView infoWindowText = (TextView)view.findViewById(R.id.window);
                if (arg0.getSnippet() != null) {
                    infoWindowText.setText((CharSequence)Html.fromHtml((String)(arg0.getTitle() + "<br>" + arg0.getSnippet())));
                } else {
                    infoWindowText.setText((CharSequence)Html.fromHtml((String)arg0.getTitle()));
                }
                return view;
            }
        });
    }
}

