/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.geojson;

import com.google.android.gms.maps.model.PolylineOptions;
import com.google.maps.android.geojson.GeoJsonStyle;
import java.util.Arrays;
import java.util.Observable;

public class GeoJsonLineStringStyle
extends Observable
implements GeoJsonStyle {
    private static final String[] GEOMETRY_TYPE = new String[]{"LineString", "MultiLineString", "GeometryCollection"};
    private final PolylineOptions mPolylineOptions = new PolylineOptions();

    @Override
    public String[] getGeometryType() {
        return GEOMETRY_TYPE;
    }

    public int getColor() {
        return this.mPolylineOptions.getColor();
    }

    public void setColor(int color) {
        this.mPolylineOptions.color(color);
        this.styleChanged();
    }

    public boolean isGeodesic() {
        return this.mPolylineOptions.isGeodesic();
    }

    public void setGeodesic(boolean geodesic) {
        this.mPolylineOptions.geodesic(geodesic);
        this.styleChanged();
    }

    public float getWidth() {
        return this.mPolylineOptions.getWidth();
    }

    public void setWidth(float width) {
        this.mPolylineOptions.width(width);
        this.styleChanged();
    }

    public float getZIndex() {
        return this.mPolylineOptions.getZIndex();
    }

    public void setZIndex(float zIndex) {
        this.mPolylineOptions.zIndex(zIndex);
        this.styleChanged();
    }

    @Override
    public boolean isVisible() {
        return this.mPolylineOptions.isVisible();
    }

    @Override
    public void setVisible(boolean visible) {
        this.mPolylineOptions.visible(visible);
        this.styleChanged();
    }

    private void styleChanged() {
        this.setChanged();
        this.notifyObservers();
    }

    public PolylineOptions toPolylineOptions() {
        PolylineOptions polylineOptions = new PolylineOptions();
        polylineOptions.color(this.mPolylineOptions.getColor());
        polylineOptions.geodesic(this.mPolylineOptions.isGeodesic());
        polylineOptions.visible(this.mPolylineOptions.isVisible());
        polylineOptions.width(this.mPolylineOptions.getWidth());
        polylineOptions.zIndex(this.mPolylineOptions.getZIndex());
        return polylineOptions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LineStringStyle{");
        sb.append("\n geometry type=").append(Arrays.toString(GEOMETRY_TYPE));
        sb.append(",\n color=").append(this.getColor());
        sb.append(",\n geodesic=").append(this.isGeodesic());
        sb.append(",\n visible=").append(this.isVisible());
        sb.append(",\n width=").append(this.getWidth());
        sb.append(",\n z index=").append(this.getZIndex());
        sb.append("\n}\n");
        return sb.toString();
    }
}

