/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.google.maps.android.R;
import com.google.maps.android.ui.RotationLayout;

public class BubbleIconFactory {
    private final Context mContext;
    private ViewGroup mContainer;
    private RotationLayout mRotationLayout;
    private TextView mTextView;
    private View mContentView;
    private int mRotation;

    public BubbleIconFactory(Context context) {
        this.mContext = context;
    }

    public Bitmap makeIcon(String text) {
        this.ensureViewsSetUp();
        if (this.mTextView != null) {
            this.mTextView.setText((CharSequence)text);
        }
        return this.makeIcon();
    }

    public Bitmap makeIcon() {
        ViewGroup container = this.getContainer();
        int measureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        container.measure(measureSpec, measureSpec);
        int measuredWidth = container.getMeasuredWidth();
        int measuredHeight = container.getMeasuredHeight();
        container.layout(0, 0, measuredWidth, measuredHeight);
        if (this.mRotation == 1 || this.mRotation == 3) {
            measuredHeight = container.getMeasuredWidth();
            measuredWidth = container.getMeasuredHeight();
        }
        Bitmap r = Bitmap.createBitmap((int)measuredWidth, (int)measuredHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        r.eraseColor(0);
        Canvas canvas = new Canvas(r);
        if (this.mRotation != 0) {
            if (this.mRotation == 1) {
                canvas.translate((float)measuredWidth, 0.0f);
                canvas.rotate(90.0f);
            } else if (this.mRotation == 2) {
                canvas.rotate(180.0f, (float)(measuredWidth / 2), (float)(measuredHeight / 2));
            } else {
                canvas.translate(0.0f, (float)measuredHeight);
                canvas.rotate(270.0f);
            }
        }
        container.draw(canvas);
        return r;
    }

    public void setContentView(View contentView) {
        this.ensureViewsSetUp();
        this.mRotationLayout.removeAllViews();
        this.mRotationLayout.addView(contentView);
        this.mContentView = contentView;
        try {
            this.mTextView = (TextView)this.mRotationLayout.findViewById(R.id.text);
        }
        catch (Exception e) {
            this.mTextView = null;
        }
    }

    public void setContentRotation(int degrees) {
        this.ensureViewsSetUp();
        this.mRotationLayout.setViewRotation(degrees);
    }

    public void setRotation(int degrees) {
        this.mRotation = (degrees + 360) % 360 / 90;
    }

    public void setTextAppearance(Context context, int resid) {
        this.ensureViewsSetUp();
        if (this.mTextView != null) {
            this.mTextView.setTextAppearance(context, resid);
        }
    }

    public void setStyle(Style style2) {
        this.setBackground(this.mContext.getResources().getDrawable(style2.mResid));
        this.setTextAppearance(this.mContext, style2.mTextResid);
    }

    public void setBackground(Drawable background) {
        this.getContainer().setBackgroundDrawable(background);
    }

    private ViewGroup getContainer() {
        this.ensureViewsSetUp();
        return this.mContainer;
    }

    private void ensureViewsSetUp() {
        if (this.mContainer == null) {
            LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
            this.mContainer = (ViewGroup)inflater.inflate(R.layout.text_bubble, null);
            this.mRotationLayout = (RotationLayout)this.mContainer.getChildAt(0);
            this.mTextView = (TextView)this.mRotationLayout.findViewById(R.id.text);
            this.mContentView = this.mTextView;
        }
    }

    public void setContentPadding(int left, int top, int right, int bottom) {
        this.ensureViewsSetUp();
        this.mContentView.setPadding(left, top, right, bottom);
    }

    public static enum Style {
        DEFAULT(R.drawable.bubble_white, R.style.Bubble_TextAppearance_Dark),
        WHITE(R.drawable.bubble_white, R.style.Bubble_TextAppearance_Dark),
        RED(R.drawable.bubble_red, R.style.Bubble_TextAppearance_Light),
        BLUE(R.drawable.bubble_blue, R.style.Bubble_TextAppearance_Light),
        GREEN(R.drawable.bubble_green, R.style.Bubble_TextAppearance_Light),
        PURPLE(R.drawable.bubble_purple, R.style.Bubble_TextAppearance_Light),
        ORANGE(R.drawable.bubble_orange, R.style.Bubble_TextAppearance_Light);

        private final int mResid;
        private final int mTextResid;

        private Style(int resid, int textResid) {
            this.mResid = resid;
            this.mTextResid = textResid;
        }
    }
}

