/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android;

import com.google.android.gms.maps.model.LatLng;
import java.util.ArrayList;
import java.util.List;

public class PolyUtil {
    private PolyUtil() {
    }

    public static List<LatLng> decode(String encodedPath) {
        int len = encodedPath.length();
        ArrayList<LatLng> path = new ArrayList<LatLng>();
        int index = 0;
        int lat = 0;
        int lng = 0;
        int pointIndex = 0;
        while (index < len) {
            int b;
            int result = 1;
            int shift = 0;
            do {
                b = encodedPath.charAt(index++) - 63 - 1;
                result += b << shift;
                shift += 5;
            } while (b >= 31);
            lat += (result & 1) != 0 ? ~(result >> 1) : result >> 1;
            result = 1;
            shift = 0;
            do {
                b = encodedPath.charAt(index++) - 63 - 1;
                result += b << shift;
                shift += 5;
            } while (b >= 31);
            path.add(new LatLng((double)lat * 1.0E-5, (double)(lng += (result & 1) != 0 ? ~(result >> 1) : result >> 1) * 1.0E-5));
            ++pointIndex;
        }
        return path;
    }

    public static String encode(List<LatLng> path) {
        long lastLat = 0L;
        long lastLng = 0L;
        StringBuffer result = new StringBuffer();
        for (LatLng point : path) {
            long lat = Math.round(point.latitude * 100000.0);
            long lng = Math.round(point.longitude * 100000.0);
            long dLat = lat - lastLat;
            long dLng = lng - lastLng;
            PolyUtil.encode(dLat, result);
            PolyUtil.encode(dLng, result);
            lastLat = lat;
            lastLng = lng;
        }
        return result.toString();
    }

    private static void encode(long v, StringBuffer result) {
        long l = v = v < 0L ? v << 1 ^ 0xFFFFFFFFFFFFFFFFL : v << 1;
        while (v >= 32L) {
            result.append(Character.toChars((int)((0x20L | v & 0x1FL) + 63L)));
            v >>= 5;
        }
        result.append(Character.toChars((int)(v + 63L)));
    }
}

