/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.jscomp.jarjar.com.google.common.collect.Sets;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.NamedType;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.Set;

final class ContainsUpperBoundSuperTypeVisitor
extends Visitor.WithDefaultCase<Result> {
    private final JSType target;
    private final Set<JSType> seen = Sets.newIdentityHashSet();

    public ContainsUpperBoundSuperTypeVisitor(JSType target) {
        this.target = target;
    }

    @Override
    protected Result caseDefault(@Nullable JSType type) {
        if (this.target == null) {
            return Result.ABSENT;
        }
        return JSType.areIdentical(type, this.target) ? Result.PRESENT : Result.ABSENT;
    }

    @Override
    public Result caseTemplateType(TemplateType type) {
        return this.caseForwardingType(type, type.getBound());
    }

    @Override
    public Result caseNamedType(NamedType type) {
        return this.caseForwardingType(type, type.getReferencedType());
    }

    @Override
    public Result caseTemplatizedType(TemplatizedType type) {
        return this.caseForwardingType(type, type.getReferencedType());
    }

    @Override
    public Result caseUnionType(UnionType type) {
        if (JSType.areIdentical(type, this.target)) {
            return Result.PRESENT;
        }
        for (JSType alt : type.getAlternates()) {
            Result foundInAlt = alt.visit(this);
            if (foundInAlt == Result.ABSENT) continue;
            return foundInAlt;
        }
        return Result.ABSENT;
    }

    private Result caseForwardingType(JSType type, JSType reference) {
        if (JSType.areIdentical(type, this.target)) {
            return Result.PRESENT;
        }
        if (this.seen.contains(type)) {
            return Result.CYCLE;
        }
        this.seen.add(type);
        return reference.visit(this);
    }

    static enum Result {
        PRESENT,
        ABSENT,
        CYCLE;

    }
}

